#ifndef TTF_DRAW_H
#define TTF_DRAW_H

/*!
  \file
  \brief TTF T[tFX̍쐬

  \author Satofumi KAMIMURA

  $Id$
*/

#include "sdlBase.h"
#include "colors.h"
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_CONFIG_H || HAVE_LIBSDL_TTF
#include <SDL_ttf.h>
#endif
#include <string>
#include <map>


/*!
  \brief `
*/
class TTF_Draw {
  static bool ttf_initialized;
#if !HAVE_CONFIG_H || HAVE_LIBSDL_TTF
  std::map<int,TTF_Font*> fonts;
#endif
  char* fileName;

  void initTTF(void);
  void createFontResource(int pxSize);
public:
  TTF_Draw(void);
  ~TTF_Draw(void);

  /*!
    \brief TrueTypeFont̓ǂݏo

    \param file [i] TrueTypeFont̃t@C
    \return ɓǂݍ߂ꍇ true
  */
  bool load(const char* file);

  /*!
    \brief T[tFX̍쐬

    \param text [i] jR[h
    \param pxSize [i] TCY
    \param color [i] F
    \param background wiF
  */
  SDL_Surface* createText(const unsigned short* text, int pxSize,
			  unsigned long color = White,
			  unsigned long background = Black);

  /*!
    \overload

    \param text [i] 
    \param pxSize [i] TCY
    \param color [i] F
    \param background wiF
  */
  SDL_Surface* createText(const char* text, int pxSize,
			  unsigned long color = White,
			  unsigned long background = Black);
};


/*!
  \brief SDL ̗ONX
*/
class TTF_Exception : public std::exception {
  std::string error_message;

public:
  /*!
    \brief TTFÕRXgN^

    \param message [i] OG[bZ[W
  */
  TTF_Exception(const char* message) : error_message(message) {}
  virtual ~TTF_Exception(void) throw () {}

  /*!
    \brief O̕Ԃ
  */
  virtual const char* what(void) const throw() {
    return error_message.c_str();
  }
};

#endif /* !TTF_DRAW_H */
