/*
  [U͏̊Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include "userInput.h"
#include "joystickCtrl.h"
#include <ctype.h>
#include <algorithm>


UserInput* UserInput::obj = NULL;


UserInput::UserInput(void) {
  stateClear();
  state.quit = false;
  SDL_EnableUNICODE(1);
}


UserInput::~UserInput(void) {
}


UserInput& UserInput::getObject(void) {
  if (!obj) {
    obj = new UserInput();
  }
  return *obj;
}


void UserInput::stateClear(void) {
  if (!obj) {
    return;
  }
  obj->state.left_released = false;
  obj->state.left_clicked = false;
  obj->state.wheel_moved = 0;
  obj->state.mouse_moved = false;
  obj->state.keys.clear();
  obj->state.sdl_keys.clear();
  obj->state.tab_pressed = false;
  obj->state.ctrl_pressed = false;
  obj->state.alt_pressed = false;
}


void UserInput::internal_stateClear(void) {
  toggle_fullscreen = false;
  left_release = false;
}


void UserInput::internal_update(void) {
  internal_stateClear();

  SDL_Event event;
  while (SDL_PollEvent(&event)) {
    int mx, my;
    switch (event.type) {
    case SDL_QUIT:
      state.quit = true;
      break;

    case SDL_KEYUP:
      keyupHandler(event.key);
      break;

    case SDL_KEYDOWN:
      keydownHandler(event.key);
      break;

    case SDL_MOUSEBUTTONUP:
    case SDL_MOUSEBUTTONDOWN:
      mousebuttonHandler(event.button);
      break;

    case SDL_MOUSEMOTION:
      SDL_GetMouseState(&mx, &my);
      state.mxx = mx - mpos.x;
      state.myy = my - mpos.y;
      mpos.x = mx;
      mpos.y = my;
      state.mpos = mpos;
      if (state.mxx || state.myy) {
	state.mouse_moved = true;
      }
      break;
    }
    JoystickCtrl::joystickEventHandler(event);

    // }EX̉̍XV
    // !!!
  }
}


void UserInput::keydownHandler(SDL_KeyboardEvent& key_event) {
  SDLKey sym = key_event.keysym.sym;
  SDLMod mod = key_event.keysym.mod;

  if (sym == SDLK_TAB) {	// TAB L[
    state.tab_pressed = true;
  }

  if (mod & KMOD_CTRL) {	// Ctrl L[
    state.ctrl_pressed = true;

    if (sym == SDLK_q) {
      state.quit = true;
      return;
    }
  }
  if (mod & KMOD_ALT) {		// Alt L[
    state.alt_pressed = true;

    if (sym == SDLK_RETURN) {
      toggle_fullscreen = true;
      return;
    } else if (sym == SDLK_F4) {
      state.quit = true;
      return;
    }
  }

  char ch = static_cast<char>(key_event.keysym.unicode);
  if (isprint(ch)) {
    state.keys.push_back(ch);
  }
  keys_sys.push_back(ch);
  sdl_keys_sys.push_back(sym);
  sdl_mods_sys.push_back(mod);
  state.sdl_keys.push_back(sym);

  if (find(state.now_keys.begin(),
	   state.now_keys.end(), sym) == state.now_keys.end()) {
    state.now_keys.push_back(sym);
  }
}


void UserInput::keyupHandler(SDL_KeyboardEvent& key_event) {
  SDLKey sym = key_event.keysym.sym;
  now_keys_t::iterator it =
    find(state.now_keys.begin(), state.now_keys.end(), sym);
  if (it != state.now_keys.end()) {
    state.now_keys.erase(it);
  }
}


void UserInput::mousebuttonHandler(SDL_MouseButtonEvent& button_event) {
  if (button_event.button == SDL_BUTTON_LEFT) {
    if (button_event.type == SDL_MOUSEBUTTONUP) {
      left_release = true;
      state.left_released = true;
    } else if (button_event.type == SDL_MOUSEBUTTONDOWN) {
      state.left_clicked = true;
    }
  }

  if (button_event.button == SDL_BUTTON_WHEELUP) {
    --state.wheel_moved;
  } else if (button_event.button == SDL_BUTTON_WHEELDOWN) {
    ++state.wheel_moved;
  }
}


UserInput::userInput_t UserInput::getInputed(void) {
  if (!obj) {
    getObject();
    stateClear();
  }
  userInput_t ret_state = obj->state;
  stateClear();

  return ret_state;
}


bool UserInput::userInput_t::isPressed(char ch) const {
  return (find(keys.begin(), keys.end(), ch) == keys.end())
    ? false : true;
}


bool UserInput::userInput_t::isPressedCode(int code) const {
  return (find(sdl_keys.begin(), sdl_keys.end(), code) == sdl_keys.end())
    ? false : true;
}


bool UserInput::userInput_t::nowPressedCode(int code) const {
  return (find(now_keys.begin(), now_keys.end(), code) == now_keys.end())
    ? false : true;
}
