/*
  ̃R[fbN
  Satofumi KAMIMURA
  $Id$
*/

#include "environmentCodec.h"
#include <ctype.h>


enum {
  env_Fail = EnvironmentCodecStream::Fail,
};


static bool isLF(char ch) {
  return ((ch == '\r') || (ch == '\n')) ? true : false;
}


void EnvironmentCodecStream::read1ch(void) {
  char ch = get1ch();

  // !!! {́AA # ƈׂ
  while (ch == '#') {
    while (!eof()) {
      ch = get1ch();
      if (isLF(ch)) {
	ch = get1ch();
	break;
      }
    }
  }
  buffer.push_back(ch);
}


void EnvironmentCodecStream::clearBuffer(int n) {
  if (n <= All) {
    buffer.clear();

  } else {
    int remove_size = (static_cast<unsigned int>(n) > buffer.size()) ?
      static_cast<int>(buffer.size()) : n;
    buffer.erase(buffer.begin(), buffer.begin() + remove_size);
  }
}


static void readRequireSize(EnvironmentCodecStream& codec, int offset,
			    int require_size) {

  int read_size =
    static_cast<int>((require_size + offset) - codec.buffer.size());
  for (int i = 0; i < read_size; ++i) {
    codec.read1ch();
  }
}


static int compareToText(const char* text,
			 EnvironmentCodecStream& codec, int offset) {
  unsigned int require_size = static_cast<unsigned int>(strlen(text));
  readRequireSize(codec, offset, require_size);
  if ((codec.buffer.size() < require_size) ||
      strncmp(text, &codec.buffer[offset], require_size)) {
    return env_Fail;
  }
  return require_size;
}


// s		:= '\r' | '\n'
extern int encodeLineFeedFromText(EnvironmentCodecStream& codec, int offset) {
  readRequireSize(codec, offset, 1);
  if ((codec.buffer.size() - offset) < 1) {
    return env_Fail;
  }
  return (isLF(codec.buffer[offset])) ? 1 : 0;
}


// 		:= ( ' ' | '\t' | (s)) []
extern int encodeSpaceFromText(EnvironmentCodecStream& codec, int offset,
			       int require_size) {
  unsigned int index = offset;
  readRequireSize(codec, index, require_size);

  for (readRequireSize(codec,index,1);
       (codec.buffer.size() > index) && (isspace(codec.buffer[index]));
       ++index) {
    readRequireSize(codec, index, 1);
  }
  return index - offset;
}


// 		:= 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9
// 	:= () []
// l		:= [ + | - ] ()
extern int encodeNumericFromText(EnvironmentCodecStream& codec, int offset,
				 int* numeric) {
  int index = offset;
  int sign = +1;
  int num = 0;

  // 
  readRequireSize(codec, offset, 1);
  if ((codec.buffer[index] == '-') || (codec.buffer[index] == '+')) {
    if (codec.buffer[index] == '-') {
      sign = -1;
    }
    ++index;
    readRequireSize(codec, index, 1);
  }

  // l
  while (1) {
    readRequireSize(codec, index, 1);
    if (isdigit(codec.buffer[index])) {
      num = (num * 10) + (codec.buffer[index] - '0');
      ++index;
    } else {
      break;
    }
  }
  *numeric = sign * num;
  return index - offset;
}


//  _		:= '(' [] (l) [] ',' [] (l) [] ')'
int encodeAPointFromText(EnvironmentCodecStream& codec, int offset,
			 VXV::Grid3D& point) {
  int index = offset;

  // '('
  int n = compareToText("(", codec, index);
  if (n <= 0) {
    return env_Fail;
  }
  index += n;

  // []
  index += encodeSpaceFromText(codec, index);

  // (l)
  int x = 0;
  n = encodeNumericFromText(codec, index, &x);
  if (n <= 0) {
    return env_Fail;
  }
  index += n;

  // []
  index += encodeSpaceFromText(codec, index);

  // ','
  n = compareToText(",", codec, index);
  if (n <= 0) {
    return env_Fail;
  }
  index += n;

  // []
  index += encodeSpaceFromText(codec, index);

  // (l)
  int y = 0;
  n = encodeNumericFromText(codec, index, &y);
  if (n <= 0) {
    return env_Fail;
  }
  index += n;

  // []
  index += encodeSpaceFromText(codec, index);

  // ')'
  n = compareToText(")", codec, index);
  if (n <= 0) {
    return env_Fail;
  }
  point = VXV::Grid3D(x, y, 0);
  index += n;

  return index - offset;
}


// _		:= (_) [] [_]
int encodePointsFromText(EnvironmentCodecStream& codec, int offset,
			 std::vector<VXV::Grid3D>& points) {
  int index = offset;

  // (_)
  VXV::Grid3D tmp_point;
  int n = encodeAPointFromText(codec, index, tmp_point);
  if (n <= 0) {
    return env_Fail;
  }
  index += n;
  points.push_back(tmp_point);

  do {
    // []
    index += encodeSpaceFromText(codec, index);

    // [_]
    n = encodeAPointFromText(codec, index, tmp_point);
    if (n > 0) {
      index += n;
      points.push_back(tmp_point);
    }
  } while (n > 0);
  return index - offset;
}


// |S	:= '(polygon' () (_) [] ')'
int encodePolygonFromText(EnvironmentCodecStream& codec, int offset,
			  std::vector<CoordinateCtrl::polygon_t>& polygons) {
  int index = offset;

  // '(polygon'
  int n = compareToText("(polygon", codec, index);
  if (n <= 0) {
    return env_Fail;
  }
  index += n;

  // ()
  n = encodeSpaceFromText(codec, index, 1);
  if (n <= 0) {
    return env_Fail;
  }
  index += n;

  // (_)
  std::vector<VXV::Grid3D> tmp_points;
  n = encodePointsFromText(codec, index, tmp_points);
  if (n <= 0) {
    return env_Fail;
  }
  index += n;

  // []
  index += encodeSpaceFromText(codec, index);

  // ')'
  n = compareToText(")", codec, index);
  if (n <= 0) {
    return env_Fail;
  }
  polygons.push_back(tmp_points);

  index += n;
  return index - offset;
}
