/*
  ̊Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include "environmentManage.h"
#include "fileStreamToCodec.h"


typedef EnvironmentManage::crd_polygon_t crd_polygon_t;


EnvironmentManage::EnvironmentManage(void) {
}


EnvironmentManage::~EnvironmentManage(void) {
}


bool EnvironmentManage::loadEnvironment(EnvironmentCodecStream& codec) {
  enum { First = 0 };

  while (!codec.eof()) {
    int n;
    codec.read1ch();

    // s𖳎
    n = encodeSpaceFromText(codec, First);
    if (n > 0) {
      codec.clearBuffer(n);
      continue;
    }

    n = encodePolygonFromText(codec, First, crd_env.crd_polygons);
    if (n > 0) {
      codec.clearBuffer();
      continue;
    }
  }
  return true;
}


bool EnvironmentManage::load(const char* envFile) {
  // t@CJAeǂݏoĊi[
  FileStreamToCodec fs(envFile);
  if (!fs.is_open()) {
    // !!! ǂ悤...Bwhat() pɃbZ[Wł쐬邩ȁH
    return false;
  }
  return loadEnvironment(fs);
}


std::vector<crd_polygon_t> EnvironmentManage::getPolygonsCopy(void){
  return crd_env.crd_polygons;
}


std::vector<crd_polygon_t>& EnvironmentManage::getPolygonsReference(void) {
  return crd_env.crd_polygons;
}
