/*
  j^Ή̑sNX
  Satofumi KAMIMURA
  $Id$
*/

#include "mRunCtrl.h"
#include "parseArgs.h"
#include "multiConnectionDevice.h"


#ifndef PACKAGE_STR_VERSION
#define PACKAGE_STR_VERSION "0.0.0"
#endif

bool mRunCtrl::isVersionPrinted = false;
bool mRunCtrl::isHelpPrinted = false;


mRunCtrl::mRunCtrl(void)
  : mon(vmonitor::getObject()), MonitorMode(Monitor::Unknown),
    cond(SDL_CreateCond()), mutex(SDL_CreateMutex()),
    simulator(new tRunCtrl_Simulator()), ticksPos(simulator->ticksPos) {
  mon->add(simulator);
  mon->task->setRunObject(this);
}


mRunCtrl::~mRunCtrl(void) {
  if (isConnected()) {
    mon->del(simulator);
    delete simulator;
  }
  SDL_DestroyMutex(mutex);
  SDL_DestroyCond(cond);
}


void mRunCtrl::printVersion(void) {
  printf("Run Ctrl Library with Monitor " PACKAGE_STR_VERSION "\n");
}


void mRunCtrl::printHelp(void) {
  printf("\n"
	 "----- Run Ctrl Library with Monitor -----\n"
	 "Options:\n"
	 "None\n"
	 "\n");
}


void mRunCtrl::parseArgs(int argc, char* argv[]) {
  bool help = false;
  bool version = false;

  for (int i = 0; i < argc; ++i) {
    if (!strcmp("--help", argv[i]) || !strcmp("-h", argv[i])) {
      help = true;

    } else if (!strcmp("--version", argv[i]) || !strcmp("-v", argv[i])) {
      version = true;
    }
  }
  if (version && !isVersionPrinted) {
    printVersion();
    isVersionPrinted = true;
  }
  if (help && !isHelpPrinted) {
    printHelp();
    isHelpPrinted = true;
  }
}


int mRunCtrl::connect(int argc, char *argv[]) {

  MonitorMode = mon->connect(argc, argv);
  parseArgs(argc-1, &argv[1]);
  return RunCtrl::connect(argc, argv);
}


int mRunCtrl::connect(void) {
  return RunCtrl::connect();
}


int mRunCtrl::connect(const char* device, long baudrate) {

  MonitorMode = mon->getMonitorMode();
  if (MonitorMode == Monitor::RealDevice) {
    MultiConnectionDevice* conObj = new MultiConnectionDevice();
    conObj->subConnect("localhost", SimulatorPort);
    return raw_connect(conObj, device, baudrate);

  } else {
    return connectSocket("localhost", SimulatorPort);
  }
}


unsigned long mRunCtrl::getHostTicks(void) {
  unsigned long host_ticks = 0;

  mon->log->lock();
  if (MonitorMode == Monitor::Playback) {
    // O̓ǂݏo
    unsigned long ticks = mon->log->readTag("run", "getHostTicks");
    const char* line = mon->log->getLineBuffer();
    sscanf(line, "%*s %*s ret=%lu", &host_ticks);
    mon->log->unlock();
    mon->task->waitToTicks(ticks, cond, mutex);

  } else {
    // Oւ̏
    host_ticks = RunCtrl::getHostTicks();
    mon->log->writeTag("run", "getHostTicks", mon->getTicks());
    fprintf(mon->log->fd, " ret=%lu", host_ticks);
    mon->log->writeTagEnd();
    mon->log->unlock();
  }
  return host_ticks;
}


void mRunCtrl::adjustOwnTicks(unsigned long setTicks) {
  unsigned long ticks = mon->getTicks();
  RunCtrl::adjustOwnTicks(setTicks);
  simulator->ticksPos.adjustOwnTicks(setTicks, ticks);
}
