/*
  mRunCtrl p TircksPositionInterface 
  Satofumi KAMIMURA
  $Id$
*/

#include "tRunCtrlSimulator.h"


tRunCtrl_Simulator::TicksPosition::TicksPosition(void)
  : first_ticks(0), offset_length(3000), ticksDiff(0) {
}


tRunCtrl_Simulator::TicksPosition::~TicksPosition(void) {
}


void tRunCtrl_Simulator::TicksPosition::add(const VXV::Position3D& pos,
					    unsigned long total_msec) {

  unsigned long ticks = adjustTicksDiff(total_msec);
  if (pos_deque.empty()) {
    first_ticks = ticks;
  }
  pos_deque.push_back(pos);
  int length = static_cast<int>(pos_deque.size() - offset_length);
  if (length > 0) {
    pos_deque.erase(pos_deque.begin(), pos_deque.begin() + length);
    first_ticks += length;
  }
}


VXV::Position3D tRunCtrl_Simulator::TicksPosition::getPosition(unsigned long
							       ticks) const {
  int size = static_cast<int>(pos_deque.size());
  if (pos_deque.empty()) {
    return VXV::Position3D();

  } else if (ticks < first_ticks) {
    return pos_deque.front();

  } else if (ticks > first_ticks + size-1) {
    return pos_deque.back();

  } else {
    return pos_deque[ticks - first_ticks];
  }
}


void tRunCtrl_Simulator::TicksPosition::adjustOwnTicks(unsigned long setTicks,
						       unsigned long ticks) {
  ticksDiff = ticks - setTicks;
  pos_deque.clear();
}


unsigned long tRunCtrl_Simulator::TicksPosition::adjustTicksDiff(unsigned long
								 ticks) const {
  return ticks - ticksDiff;
}


void tRunCtrl_Simulator::TicksPosition::clear(void) {
  pos_deque.clear();
}


void tRunCtrl_Simulator::TicksPosition::set_dataLength(unsigned long msec) {
  offset_length = msec;
}
