#ifndef M_URG_CTRL_H
#define M_URG_CTRL_H

/*!
  \file
  \brief j^Ή URG NX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "vmonitor.h"
#include "urgCtrl.h"
#include "urgSimulator.h"


/*!
  \brief j^Ή URG NX
*/
class mURGCtrl : public URGCtrl {
  SDL_cond* cond;
  SDL_mutex* mutex;
  vmonitor* mon;
  int MonitorMode;
  int pre_captureTimes;
  int pre_ret_value;
  bool playback_isconnected;
  bool no_record;
  static bool isVersionPrinted;
  static bool isHelpPrinted;

  static URG_Simulator* simulator;
  static int sim_add_count;
  long pre_length[SenseSteps];

  void printVersion(void);
  void printHelp(void);
  void parseArgs(int argc, char* argv[]);
  void readLogData(int *ret_value, unsigned long* raw_timestamp);
  void writeLogData(int ret_value, unsigned long ticks,
		    unsigned long raw_timestamp);
  void writeVersionInfo(int ret_value, char lines[][LineLength],
			unsigned long ticks);
  void readVersionInfo(int* ret_value, char lines[][LineLength]);

  int raw_capture(long length[], int first_index, int last_index, int group,
		  unsigned long* raw_timestamp = NULL);

  unsigned long getHostTicks(void);
  void beginTimeAdjust(void);
  unsigned long getURGTimestamp(void);
  void endTimeAdjust(void);

public:
  mURGCtrl(void);
  virtual ~mURGCtrl(void);

  /*!
    \overload

    \param autoCapture [i] ڑ̍ۂ urg_capture_mode_page w
    \param device [i] ڑfoCX
    \param baudrate [i] ڑ{[[g
  */
  int connect(bool autoCapture, const char* device,
	      long baudrate = URG::DefaultBaudrate);

  /*!
    \overload

    \param autoCapture [i] ڑ̍ۂ urg_capture_mode_page w
  */
  int connect(bool autoCapture = true);

  /*!
    \overload

    \param argc [i] ̌
    \param argv [i] i[z
    \param autoCapture [i] ڑ̍ۂ urg_capture_mode_page w
  */
  int connect(int argc, char *argv[], bool autoCapture = URG::AutoCapture);

  /*!
    \overload

    \param lines [i] V R}hs؂Ŋi[
  */
  int getVersionInfo(char lines[][LineLength]);

  /*!
    \overload
  */
  bool isConnected(void);

  /*!
    \overload
  */
  int getCaptureTimes(void);
};

#endif /* !M_URG_CTRL_H */
