/*
  SCIʐM TCP/IP 
  Satofumi KAMIMURA
  $Id$
*/

#include "tRunCtrl.h"
#include "sh7045lib.h"
#include "connectionDevice.h"
#include <vector>

#include <stdio.h>


static std::vector<ConnectionDevice*> cons;
static int size_max = 0;


void init_sci(int port, ConnectionDevice* con) {
  while (cons.size() < static_cast<unsigned int>(port) +1) {
    cons.push_back(NULL);
    size_max = static_cast<int>(cons.size());
  }
  cons[port] = con;
}


void init_sci(int port, int level) {
}


void stop_sci(int port) {
  if (port > size_max -1) {
    return;
  }
  cons[port] = NULL;
}


int sci_write(int port, const unsigned char* data, int size) {
  if (port > size_max -1) {
    return -1;
  }

  return cons[port]->send((char*)data, size);
}


int sci_read(int port, unsigned char *data, int size) {
  if (port > size_max -1) {
    return -1;
  }

  return cons[port]->recv((char*)data, size);
}


int sci_copy(int port, unsigned char *data, int size) {
  if (port > size_max -1) {
    return -1;
  }

  return -1;
}


int get_sciReadable(int port) {
  if (port > size_max -1) {
    return 0;
  }
  // Oobt@œǂݍ݉\ȃTCYԂ
  return cons[port]->size();
}


void flush_sciRecv(int port) {
  if (port > size_max -1) {
    return;
  }

  // Oobt@̓ej
  cons[port]->flush();
}
