/*
  `R}h̏
  Satofumi KAMIMURA
  $Id$
*/

#include "screenTask.h"
#include <stdarg.h>

using namespace std;


vector<BasicDrawInterface*> ScreenTask::graphix_groups;
set<unsigned long> ScreenTask::delete_index;
map<unsigned long,BasicDrawInterface*> ScreenTask::text_map;
map<unsigned long,BasicDrawInterface*> ScreenTask::graphix_map;


void ScreenTask::clear(unsigned long index) {
  win->lock();

  switch (index) {

  case INVALID_LAYER_ID:
    break;

  case ALL_LAYER:
  case TEXT_LAYER:
    // XN[̍폜
    debug_area_clear = true;

    // zu̍폜
    for (map<unsigned long,BasicDrawInterface*>::iterator it
	   = text_map.begin(); it != text_map.end(); ++it) {
      delete_index.insert(it->first);
    }
    if (index == TEXT_LAYER) {
      break;
    }

  case GRAPHIX_LAYER:
    for (map<unsigned long,BasicDrawInterface*>::iterator it
	   = graphix_map.begin(); it != graphix_map.end(); ++it) {
      delete_index.insert(it->first);
    }
    break;

  default:
    delete_index.insert(index);
    break;
  }
  win->unlock();
}


unsigned long ScreenTask::setPoints(const vector<VXV::Grid3D>& points,
				    unsigned long color, int width) {
  win->lock();
  vector<VXV::Grid> points_2d(points.begin(), points.end());
  PixelGroupDraw* obj = new PixelGroupDraw(points_2d, color);
  graphix_groups.push_back(obj);
  graphix_map.insert(pair<unsigned long,BasicDrawInterface*>(layer_index,obj));
  win->unlock();

  int ret = layer_index++;
  win->unlock();
  return ret;
}


unsigned long ScreenTask::setLine(const VXV::Grid3D& p0, const VXV::Grid3D& p1,
				  unsigned long color) {
  win->lock();
  LineDraw* obj = new LineDraw(p0, p1, color);
  graphix_groups.push_back(obj);
  graphix_map.insert(pair<unsigned long,BasicDrawInterface*>(layer_index,obj));

  int ret = layer_index++;
  win->unlock();
  return ret;
}


unsigned long ScreenTask::setContLine(const std::deque<VXV::Grid3D>& points,
				      unsigned long color) {
  win->lock();
  deque<VXV::Grid> points_2d(points.begin(), points.end());
  ContLineDraw* obj = new ContLineDraw(points_2d, color);
  graphix_groups.push_back(obj);
  graphix_map.insert(pair<unsigned long,BasicDrawInterface*>(layer_index,obj));

  int ret = layer_index++;
  win->unlock();
  return ret;
}


unsigned long ScreenTask::setCircle(const VXV::Grid& center, int r,
				    unsigned long color) {
  win->lock();
  CircleDraw* obj = new CircleDraw(center, r, color);
  graphix_groups.push_back(obj);
  graphix_map.insert(pair<unsigned long,BasicDrawInterface*>(layer_index,obj));

  int ret = layer_index++;
  win->unlock();
  return ret;
}


unsigned long ScreenTask::setText(const char* text, const VXV::Grid& pos,
				  int pxSize, bool pin, unsigned long color,
				  unsigned long back) {
  win->lock();
  TextDraw* obj = new TextDraw(*ttf, text, pos, pxSize, pin, color, back);
  graphix_groups.push_back(obj);
  graphix_map.insert(pair<unsigned long,BasicDrawInterface*>(layer_index,obj));

  int ret = layer_index++;
  win->unlock();
  return ret;
}


void ScreenTask::drawObjects(void) {

  if (debug_area_clear) {
    debug_area_clear = false;
    debug_area->clear();
  }

  for (vector<BasicDrawInterface*>::iterator it = graphix_groups.begin();
       it != graphix_groups.end(); ++it) {
    user_view->add(*it);
  }
  graphix_groups.clear();

  for (set<unsigned long>::iterator it = delete_index.begin();
       it != delete_index.end(); ++it) {
    map<unsigned long,BasicDrawInterface*>::iterator p = text_map.find(*it);
    if (p != text_map.end()) {
      user_view->del(p->second);
      text_map.erase(*it);

    } else {
      p = graphix_map.find(*it);
      if (p != graphix_map.end()) {
	user_view->del(p->second);
	graphix_map.erase(*it);
      }
    }
  }
  delete_index.clear();
}


int ScreenTask::printf(ScrollAreaComponent* area,
		       const char* fmt, va_list ap) {
  win->lock();
  int n = area->printf(fmt, ap);
  win->unlock();

  return n;
}


int ScreenTask::consolePrintf(const char* fmt, va_list ap) {
  return printf(debug_area, fmt, ap);
}


int ScreenTask::commandLogPrintf(const char* fmt, ...) {
  va_list ap;
  va_start(ap, fmt);
  return printf(command_log, fmt, ap);
}
