#!/usr/bin/ruby
#
# isin(), icos() 邽߂̃XNvg
# Satofumi KAMIMURA
# $Id$

# Βl̍őlApx̐ݒ
angle_div = 65536	# [0, 65535]
divid_shift = 15
divid_max = 1 << divid_shift	# [-32767, +32767]
angle_quad = angle_div >> 2

# ̐ݒ (0Ō덷Ȃ)
#table_shift_value = 5 
table_shift_value = 0

if ARGV[0] == "header"
print <<-"EOB"
#ifndef I_SIN_COS_H
#define I_SIN_COS_H

/*!
  \\file
  \\brief ^ sin(), cos()

  ^̎Op֐(sin(), cos())
  pxׂ̍Aől̓RpCɎw

  \\author Satofumi KAMIMURA

  $Id$
*/


enum {
  ISINCOS_ANGLE_DIVIDED = #{angle_div}, /* [0, #{angle_div}] */
  ISINCOS_VALUE_MAX = #{divid_max},	/* [-#{divid_max}, +#{divid_max}] */
  ISINCOS_VALUE_SHIFT = #{divid_shift},
};


#include "cpp_extern_macro.h"
BEGIN_C_DECLS;

extern int isin(unsigned short div16);
extern int icos(unsigned short div16);

END_C_DECLS;
#endif /* !I_SIN_COS_H */
EOB
  exit
end

# e[ȕo

# get this file name
__FILE__ =~ /\/*(.+)$/
thisFile = $1

print <<-"EOB"
/*
  \\brief ^ sin, cos ֐

  This program generated by #{thisFile}

  \\author Satofumi KAMIMURA

  $Id$

  angle_max = #{angle_div-1}
  divid_max = #{divid_max}
*/

#include "isincos.h"


static unsigned short sin_table[] = {
EOB

# ̐l̕\
for i in 0 .. angle_div.to_i
  if i > (angle_quad.to_i >> table_shift_value)
    break
  end
  sin_val = divid_max.to_i \
  * Math::sin((2.0 * Math::PI * (i << table_shift_value).to_f / angle_div.to_f))
  print ' ', sin_val.to_i, ','
  if (i+1) % 10 == 0
    print "\n"
  end
end
print "};\n\n"

# isin(), icos() ̏̕o
print <<-"EOB"

static int sin_table_func(int n) {
EOB
if table_shift_value == 0
  print "  return sin_table[n];\n"
else
  print "  return sin_table[n >> #{table_shift_value}];\n"
end
print <<-"EOB"
}

/*!
  \\brief ^ sin()

  ^ sin()

  \\param div16 [i] px[div16]
  \\retval divid_max * sin(2.0 * M_PI * div16 / 65536.0)
*/
int isin(unsigned short div16) {
  int ret;

  if (div16 <= #{angle_quad}) {
    ret = sin_table_func(div16);
  } else if (div16 <= #{2 * angle_quad}) {
    ret = sin_table_func(#{2 * angle_quad} - div16);
  } else if (div16 <= #{3 * angle_quad}) {
    ret = -sin_table_func(div16 -#{2 * angle_quad});
  } else {
    ret = -sin_table_func(#{4 * angle_quad} - div16);
  }
  return ret;
}


/*!
  \\brief ^ cos()

  ^ cos()B

  \\param div16 [i] px[div16]
  \\retval divid_max * cos(2.0 * M_PI * div16 / 65536.0)
*/
int icos(unsigned short div16) {
  div16 += #{3 * angle_quad};
EOB
if angle_div-1 != 0xffff
  print "  div16 &= #{angle_div - 1};\n"
end
print <<-"EOB"
  return -1 * isin(div16);
}
EOB
