/*!
  \file
  \brief GR[_

  \author Satofumi KAMIMURA

  $Id$
*/

#include <7040S.H>
#include "encCtrl.h"


/*!
  \brief GR[_foCX̏

  GR[_ɗp͒[qB
*/
void initEnc(void) {
  MTU1.TMDR.BYTE = 0xc4;	/* encoder mode 1 */
  MTU2.TMDR.BYTE = 0xc4;	/* encoder mode 1 */
  MTU.TSTR.BYTE |= 0x06;	/* start count up */

  PFC.PECR2.WORD |= 0x1100;	/* TIOC1A, TIOC2A */
  MTU1.TIOR.BYTE = 0x0a;	/* input capture */
  MTU2.TIOR.BYTE = 0x0a;	/* input capture */

  PFC.PEIOR.WORD &= ~0x0050;	/* use TIOC1A, TIOC2A port */

  PFC.PACRL2.WORD &= ~0xf000;	/* TCLKA, TCLKB */
  PFC.PACRL2.WORD |= 0x5000;
  PFC.PACRL1.WORD &= ~0x000f;	/* TCLKC, TCLKD */
  PFC.PACRL1.WORD |= 0x0005;

  MTU1.TCNT = 0;		/* counter=0 */
  MTU2.TCNT = 0;
  MTU1.TGRA = 0;		/* buffer=0 */
  MTU2.TGRA = 0;
}


/*!
  \brief wfoCXID ̃GR[_lǂݏo

  id Ŏw肳ꂽGR[_foCX̃JEgl(GR[_l)ǂݏoB

  \param id [i] GR[_foCXID
  \retval GR[_l
*/
static unsigned short getEncValue(const unsigned char id) {
  unsigned short cnt = -1;

  if (id == 0) {
    cnt = MTU1.TGRA;
  } else if (id == 1) {
    cnt = MTU2.TGRA;
  }
  return cnt;
}


/*!
  \brief GR[_p̍\̂

  GR[_p̍\̂̃oϐB

  \param id [i] GR[_foCXID
  \param enc [o] GR[_p̍\
*/
void initEncInfo(const unsigned char id, encInfo_t *enc) {
  enc->prev = getEncValue(id);
  enc->id = id;
  enc->enc_direction = ENC_CW_TO_PLUSE;
  enc->diff = 0;
  enc->total = 0;
}


/*!
  \brief GR[_lXV

  GR[_l̕ψʗʂXV

  \param enc [i/o] GR[_p̍\

  \attention ɂPxǂݏoׂ
*/
void updateEncDiff(encInfo_t *enc) {

  short now = getEncValue(enc->id);
  enc->diff = enc->enc_direction * (now - enc->prev);
  enc->total += enc->diff;
  enc->prev = now;
}


/*!
  \brief GR[_l̕ψʂ擾

  O̐ɂGR[_l̕ψʗʂGR[_p̍\̂Ɋi[ƓɁAԂlƂĕԂB

  \param enc [i/o] GR[_p̍\
  \retval GR[_̕ψʗ
*/
int getEncDiff(encInfo_t *enc) {
  return enc->diff;
}
