#ifndef URG_AUTO_CAPTURE_H
#define URG_AUTO_CAPTURE_H

/*!
  \file
  \brief URG Ɏf[^擾@\ǉ

  \brief Satofumi KAMIMURA

  $Id$
*/

#include "urgManualCapture.h"
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_CONFIG_H || HAVE_LIBSDL
#include <SDL_thread.h>
#endif


/*!
  \brief URG ̊{
*/
class URGAutoCapture : public URGManualCapture {
#if !HAVE_CONFIG_H || HAVE_LIBSDL
  enum { WaitMsec = 10 };
  SDL_Thread* thread;
  SDL_mutex* mutex;
  bool active;
  typedef struct {
    int first, last, group;
    long* length;
    bool captured;
    int ret_value;
    unsigned long raw_timestamp;
    long capture_times;
  } captureBuffer_t;
  captureBuffer_t capture_buffer[2];
  int next_first, next_last, next_group;
  unsigned long raw_timestamp;
  bool initialized;
  int active_index;
  URGInterface::urgParams_t* urg_params;
  long auto_capture_times;

  void lock(void);
  void unlock(void);
  void initCaptureBuffer(URGInterface::urgParams_t& params);
  static int captureThread(void* args);

public:
  URGAutoCapture(void);
  ~URGAutoCapture(void);

  int capture(long length[],
	      int first_index, int last_index, int group,
	      URGInterface::urgParams_t& params,
	      unsigned long* raw_timestamp);
  int getCaptureTimes(void);
#endif
};

#endif /* !URG_AUTO_CAPTURE_H */
