#ifndef URG_CAPTURE_H
#define URG_CAPTURE_H

/*!
  \file
  \brief URG {̃C^[tF[X`

  \author Satofumi KAMIMURA

  $Id$
*/

#include "urgInterface.h"
#include <exception>
#include <string>


/*!
  \brief URG {̃C^[tF[X
*/
class URGCapture {
public:
  enum {
    HeaderError = -2,
    RecvSizeError = -3,
    MissmatchLF = -4,
  };
  virtual ~URGCapture(void) {}

  /*!
    \brief G[ԂԂ

    \todo Lq
  */
  virtual const char* what(void) = 0;

  /*!
    \brief ZTւ̐ڑs

    \todo Lq

    \param device [i] ڑfoCX
    \param baudrate [i] ڑ{[[g

    \retval 0 I
    \retval ߂l < 0 G[
  */
  virtual int connect(const char* device, long baudrate) = 0;

  /*!
    \brief \Pbgɑ΂Đڑ

    \todo Lq

    \param host [i] ڑzXg
    \param port [i] ڑ|[g

    \retval 0 I
    \retval ߂l < 0 G[
  */
  virtual int connectSocket(const char* host, short port) = 0;

  /*!
    \brief ZTƂ̐ڑؒf

    \todo Lq
  */
  virtual void disconnect(void) = 0;

  /*!
    \brief ZTƐڑĂ邩Ԃ

    \todo Lq
  */
  virtual bool isConnected(void) = 0;

  /*!
    \brief M̃^CAEgw

    \param timeout [i] ^CAEg [msec]
  */
  virtual void set_recvTimeout(int timeout) = 0;

  /*!
    \brief ^CX^v擾[hɐݒ肷

    \todo Lq

    \param withTimestamp [i] ^CX^vpłꍇ true
  */
  virtual void setTimestampMode(bool withTimestamp) = 0;

  /*!
    \brief ZT̃f[^擾

    \todo ɂĂ̐Lq

    \image html urgIndex.png zɊi[f[^Ɗpx̊֌W(ZT^)

    \param length [o] f[^i[z
    \param first_index [i] f[^̗vJnʒu
    \param last_index [i] f[^̗vIʒu
    \param group [i] O[sOsf[^
    \param params [i] ZT̃p[^
    \param raw_timestamp [o] ZT̃^CX^vl

    \retval ߂l > 0 擾f[^z̓Y̍ől
    \retval ߂l < 0 G[
  */
  virtual int capture(long length[],
		      int first_index, int last_index, int group,
		      URGInterface::urgParams_t& params,
		      unsigned long* raw_timestamp = NULL) = 0;

  /*!
    \brief ZTf[^擾񐔂Ԃ

    \todo Lq
  */
  virtual int getCaptureTimes(void) = 0;

  /*!
    \brief ZTɒڃR}h]

    \todo Lq

    \param data [i] Mf[^
    \param size [i] Mf[^TCY

    \retval ߂l >= 0 MoCg
    \retval ߂l < 0 G[
  */
  virtual int send(const char* data, int size) = 0;

  /*!
    \brief ZT璼ڃbZ[W󂯎

    \todo Lq

    \param data	[o] Mf[^
    \param maxsize [i] M\TCY
    \param timeout [i] ^CAEg [msec]

    \retval ߂l >= 0 MoCg
    \retval ߂l < 0 G[
  */
  virtual int recv(char* data, int maxsize, long timeout = 0) = 0;

  /*!
    \brief ZTPs̃bZ[W𒼐ڎ󂯎

    \todo Lq
    s܂

    \param data	[o] Mf[^
    \param maxsize [i] M\TCY
    \param timeout [i] ^CAEg [msec]

    \retval ߂l >= 0 MoCg
    \retval ߂l < 0 G[
  */
  virtual int recv_line(char* data, int maxsize, long timeout = 0) = 0;

  virtual int laser(bool on) = 0;
};


/*!
  \brief URGCapture ̗ONX
*/
class URGCapture_Exception : public std::exception {
  std::string error_message;

public:
  /*!
    \brief bZ[Ww肵ėO𓊂
  */
  URGCapture_Exception(const char* message) throw ()
    : error_message(message) {}
  virtual ~URGCapture_Exception(void) throw () {}

  /*!
    \brief O̕Ԃ

    \todo Lq
  */
  virtual const char* what(void) const throw() {
    return error_message.c_str();
  }
};

#endif /* !URG_CAPTURE_H */
