/*
  o[WǂݏoăhCȍXV
  Satofumi KAMIMURA
  $Id$
*/

#include "urgCtrl.h"

enum {
  VersionLines = 8,
};


int URGCtrl::getVersionInfo(char lines[][LineLength]) {
  if (!isConnected()) {
    throw URG_Exception("URG is not connected");
  }

  // SCIP1.0  TMx R}hgȂ̂ŁASCIP2.0 ɕύX
  con->send("SCIP2.0\r", 8);
  char buffer[8];
  con->recv(buffer, 8, 130);
  skipReply(2);

  con->send("VV\r", 3);
  for (int i = 0; i < VersionLines; ++i) {
    if ((con->recv_line(lines[i], LineLength, 150) <= 0) &&
	(i < (VersionLines-1))) {
      return -1;
    }
  }
  return 0;
}


void URGCtrl::checkVersion(void) {

  enableTimestamp = false;
  enableOver4096 = false;
  eachDataByte = 2;

  // o[W̓ǂݏo
  char lines[VersionLines][LineLength];
  if (getVersionInfo(lines) < 0) {
    return;
  }

  // ^CX^v[hp\̔
  //if (! strcmp("PROD:SOKUIKI Sensor TOP-URG UTM-X001S;E", lines[PROD])) {
  enableTimestamp = true;
  if (con) {
    con->setTimestampMode(true);
  }
  //}

  // M[hύXł邩̔
  if (!strcmp("PROD:SOKUIKI Sensor URG-X003", lines[PROD])) {
    enableOver4096 = true;

    // ݂̎M[h̃oCg𔻒
    if (strncmp("PROT:00003,(SCIP1.0z", lines[PROT], 20)) {
      eachDataByte = 3;
    }
  }

#if 0
  // [Uo͂ On ɂ
  // {́ApR}h capture() ŏׂAۗB̎őΉH
  con->send("L1\r", 3);

  char buffer[7];
  con->recv(buffer, 7, 230);
#endif
}
