#ifndef URG_CTRL_H
#define URG_CTRL_H

/*!
  \file
  \brief URG ̐NX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "coordinateCtrl.h"
#include "ticksCtrlInterface.h"
#include "urgCapture.h"
#include "timeUtils.h"
#include "ticksPositionInterface.h"


/*!
  \brief URG NX
*/
class URGCtrl : public URGInterface, public CoordinateCtrl,
		public TicksCtrlInterface {
  friend class URG_Simulator;
  friend class URGCtrlTest;

  enum {
    DefaultBaudrate = 115200,
    SimulatorPort = 49763,
  };
  URGCapture* con;
  bool isHandstand;

  int eachDataByte;
  bool enableOver4096;

  std::string error_message;
  static bool isVersionPrinted;
  static bool isHelpPrinted;

  bool ignore_beginTimeAdjust;
  unsigned short pre_module_ticks;
  long total_msec;

  ticksInfo_t ticksInfoObj;
  ticksInfo_t& getTicksInfo(void) {
    return ticksInfoObj;
  }

  void skipReply(int n);
  long decode(const char* data, int data_byte);
  int updateTicksDiff(unsigned short ticks);
  unsigned long getModuleRawTicks(void);

  void printVersion(void);
  void printHelp(void);
  int getIndexTicks(int index);
  URGCtrl(const URGCtrl& rhs);

protected:
  enum {
    SenseSteps = (1024 * 270 / 360) + 1,
  };
  bool to_simulator;		/*!< V~[^ւ̐ڑ */
  bool enableTimestamp;		/*!< ^CX^vp\ */

  /*!
    \brief 킹̏
  */
  void initTicksInfo(void);

  /*!
    \brief zXg̃^CX^v擾
  */
  virtual unsigned long getHostTicks(void);

  /*!
    \brief ^CX^v킹[h̊Jn
  */
  virtual void beginTimeAdjust(void);

  /*!
    \brief URG ̃^CX^v擾

    \todo Lq

    \retval ^CX^v
  */
  virtual unsigned long getURGTimestamp(void);

  /*!
    \brief ^CX^v킹[h̏I
  */
  virtual void endTimeAdjust(void);

  /*!
    \brief ZT̃p[^i[
  */
  urgParams_t params;

  long* getLengthData(void) {
    return length;
  }

  /*!
    \brief ñIvV

    \todo Lq

    argv[]  0 Ԗڂ]

    \param ret_value [i] ڑsꂽꍇ̖߂li[
    \param argc [i] ̌
    \param argv [i] i[z
    \param autoCapture [i] ڑ̍ۂ \ref urg_capture_mode_page w

    \retval true ret_value Lȏꍇ
    \retval false ret_value ȏꍇ
  */
  bool parseArgs(int* ret_value, int argc, char *argv[], bool autoCapture);

  /*!
    \brief o[W񂩂hCő肷
  */
  void checkVersion(void);

  /*!
    \brief URG f[^擾s

    \todo Lq

    \param length [o] 擾f[^i[z
    \param first_index [i] f[^̗vJnʒu
    \param last_index [i] f[^̗vIʒu
    \param group [i] O[sOsf[^
    \param raw_timestamp [o] ZT̃^CX^vl

    \retval ߂l > 0 擾f[^z̓Y̍ől
    \retval ߂l < 0 G[
  */
  virtual int raw_capture(long length[],
			  int first_index, int last_index, int group,
			  unsigned long* raw_timestamp = NULL);

public:
  enum {
    VEND = 3,
    PROD,
    FIRM,
    PROT,
    SERI,
    DefaultTimeout = -1,
  };

  //virtual void adjustOwnTicks(unsigned long setTicks);

  urgParams_t& getParameters(void) {
    return params;
  }

  /*!
    \brief ZT̑f[^i[
  */
  long length[SenseSteps];

  URGCtrl(void);
  ~URGCtrl(void);

  const char* what(void);

  /*!
    \brief ZT̎tԂݒ

    \todo Lq

    \param on [i] ZTVntɎtĂꍇAtrue w
  */
  void setHandstand(bool on);

  virtual int connect(const char* device, long baudrate = DefaultBaudrate,
		      bool autoCapture = URG::AutoCapture);

  /*!
    \brief \Pbgɑ΂Đڑ

    \todo Lq

    \param autoCapture [i] ڑ̍ۂ \ref urg_capture_mode_page w
    \param host [i] ڑzXg
    \param port [i] ڑ|[g

    \retval 0 I
    \retval ߂l < 0 G[
  */
  int connectSocket(const char* host, short port, bool autoCapture);

  virtual int connect(int argc, char *argv[],
		      bool autoCapture = URG::AutoCapture);

  /*!
    \brief b5conf.txt ̓e]ăZTւ̐ڑs

    \todo Lq

    \param autoCapture [i] ڑ̍ۂ \ref urg_capture_mode_page w
  */
  virtual int connect(bool autoCapture = true);

  virtual void disconnect(void);

  /*!
    \brief ZTƐڑĂ邩Ԃ

    \todo Lq
  */
  virtual bool isConnected(void);

  /*!
    \brief M̃^CAEgw

    \param timeout [i] ^CAEg [msec]
  */
  void set_recvTimeout(int timeout = DefaultTimeout);

  /*!
    \brief o[W̎擾

    SCIP  V R}h̉i[ĕԂBzTCÝA64 x 8 ȏvB

    \param lines [i] V R}hs؂Ŋi[

    \retval ǂݍ񂾏̍s
  */
  enum { LineLength = 64 + 16 };
  virtual int getVersionInfo(char lines[][LineLength]);

  int capture(int first_index, int last_index, int group = 1);

  int capture(int group = 1);

  /*!
    \brief ZTf[^擾񐔂Ԃ

    \todo Lq
  */
  int getCaptureTimes(void);

  /*!
    \brief f[^WJ

    ϊʒúAcapture ̐莩Ȉʒup
  */
  void convert(void);

  /*!
    \brief f[^wʒuɓWJ

    \todo Lq

    \param crd_position [i] ϊʒu
  */
  void convert(const VXV::Position3D& crd_position);

  /*!
    \brief f[^WJ

    \todo Lq

    \param position [i] t̕ϊʒu
  */
  void convert(const VXV::TicksPositionInterface& position);
};


/*!
  \brief URG ̗ONX
*/
class URG_Exception : public std::exception {
  std::string error_message;

public:
  /*!
    \brief bZ[Ww肵ėO𓊂
  */
  URG_Exception(const char* message) throw () : error_message(message) {}
  virtual ~URG_Exception(void) throw () {}

  /*!
    \brief O̕Ԃ

    \todo Lq
  */
  virtual const char* what(void) const throw() {
    return error_message.c_str();
  }
};

#endif /* !URG_CTRL_H */
