#ifndef URG_INTERFACE_H
#define URG_INTERFACE_H

/*!
  \file
  \brief URG ̏z֐`

  \author Satofumi KAMIMURA

  $Id$
*/

#include <math.h>
#include "math_util.h"


/*!
  \brief URG ̖O
*/
namespace URG {
  enum {
    AutoCapture = true, ManualCapture = false,
    DefaultBaudrate = 115200,
  };
};

/*!
  \brief URG ̏z֐
*/
class URGInterface {
public:
  /*!
    \brief WZT̃XybN

    \todo Lq
  */
  typedef struct {
    int cycle_step_max;		/*!< ~̕ */
    int first_step;		/*!< ZVO̊Jnʒu */
    int sense_steps;		/*!< ZVO_̌ */
    int rotate_direction;	/*!< ZVỎ] */
    int cycle_msec;		/*!< ZVOPɂ鎞 */
    long length_min;		/*!< ŏLl */
    long length_max;		/*!< őLl */
    int ticks_begin_step; /*!< ZVOJnʒu̎̊ʒu */
  } urgParams_t;

public:
  virtual ~URGInterface(void) {}

  /*!
    \brief ZT̃p[^Ԃ

    \todo Lq
  */
  virtual urgParams_t& getParameters(void) = 0;

  /*!
    \brief f[^i[ꂽzւ̃|C^Ԃ

    \todo Lq
  */
  virtual long* getLengthData(void) = 0;

  /*!
    \brief G[ԂԂ

    \todo LqAe what ł̐𓝈

    \return ZTԂ

    gp
    \code
    URGCtrl urg;
    if (urg.connect(argc, argv, URG::AutoCapture) < 0) {
      // ڑɎsꍇAG[bZ[W\ďI
      printf("URGCtrl::connect: %s\n", urg.what());
      exit(1);
    }
    ...
    \endcode
  */
  virtual const char* what(void) = 0;

  /*!
    \brief foCXw肵ăZTڑs

    \todo Lq

    \param autoCapture [i] ڑ̍ۂ \ref urg_capture_mode_page w
    \param device [i] ڑfoCX
    \param baudrate [i] ڑ{[[g

    \retval 0 I
    \retval ߂l < 0 G[
  */
  virtual int connect(const char* device,
		      long baudrate = URG::DefaultBaudrate,
		      bool autoCapture = URG::AutoCapture) = 0;

  /*!
    \brief A b5conf.txt ̓e]ăZTւ̐ڑs

    ́Aargv[1] ]

    \todo Lq

    \param argc [i] ̌
    \param argv [i] i[z
    \param autoCapture [i] ڑ̍ۂ \ref urg_capture_mode_page w
  */
  virtual int connect(int argc, char *argv[],
		      bool autoCapture = URG::AutoCapture) = 0;


  /*!
    \brief ZTƂ̐ڑؒf

    \todo Lq
  */
  virtual void disconnect(void) = 0;

  /*!
    \brief ZTf[^̎擾

    URGCapture::capture ̐QƂ̂

    \param first_index [i] f[^̗vJnʒu
    \param last_index [i] f[^̗vIʒu
    \param group [i] O[sOsf[^

    \retval ߂l > 0 擾f[^z̓Y̍ől
    \retval ߂l < 0 G[
  */
  virtual int capture(int first_index, int last_index, int group = 1) = 0;

  /*!
    \overload

    \param group [i] O[sOsf[^
  */
  virtual int capture(int group = 1) = 0;

  /*!
    \brief ZTf[^̃CfbNXEpxϊ

    f[^̊pxAf[^z̓Y̒l radianPʌn̒lɕϊ

    \param index [i] f[^z̓Y

    \retval radian radianPʌnɂ̒l (-M_PI, +M_PI)

    \todo gpLq
  */
  virtual double index2rad(int index) {
    urgParams_t& params = getParameters();
    return (params.first_step + params.rotate_direction * index) *
      (2.0*M_PI) / params.cycle_step_max;
  }

  /*!
    \brief ZTf[^̊pxECfbNXϊ

    f[^̊pxAradianPʌn̒l瑪f[^z̓Y̒lɕϊ

    \param radian [i] f[^ radianPʌnł̌ (-M_PI, +M_PI)

    \retval index f[^z̓Y̒l

    \attention ߂l̒lK؂ǂ̔́AĂяoōs

    gp
    \code
    URGCtrl urg;
    urg.connect(URG::ManualCapture, "/dev/ttyACM0");
    int n = urg.capture();

    // wpx̒l̑f[^A擾f[^̔z𔻒肵Ă\
    int index = urg.rad2index(M_PI/2.0);
    if ((index >= 0) && (index < n)) {
      printf("length: %d\n", urg.length[index]);
    }
    \endcode

  */
  virtual int rad2index(double radian) {
    urgParams_t& params = getParameters();
    return static_cast<int>(radian / (2.0 * M_PI) * params.cycle_step_max
			    - params.first_step);
  }
};

#endif /* !URG_INTERFACE_H */
