/*
  L[[ht@Co
  Satofumi KAMIMURA
  $Id$

  NX private ƂĐ錾ꍇA
  ̃\[X荞ރNX錾̑OɁAȉ̐錾KvƂȂ
  
  #include <string.h>
  #include <stdlib.h>
  #include <ctype.h>

  \todo CŃRpCł悤ɂ
*/

#ifndef __cplusplus
#include "get_keyword.h"
#endif

int skipSpace(FILE *fd) {
  while (!feof(fd)) {
    int ch = fgetc(fd);
    if ((ch == '\r') || (ch == '\n')) {
      ungetc(ch, fd);
      return -1;
    }
    if (!isspace(ch)) {
      ungetc(ch, fd);
      return 0;
    }
  }
  return -1;
}


void skipToLF(FILE *fd) {
  while (!feof(fd)) {
    int ch = fgetc(fd);
    if ((ch == '\r') || (ch == '\n')) {
      return;
    }
  }
}


char *getString(FILE *fd) {
  enum { BUFFER_MAX = 255 };
  char buffer[BUFFER_MAX+1];
  int index = 0;

  while (!feof(fd)) {
    int ch = fgetc(fd);
    if (isgraph(ch) && (ch != '=')) {
      if (index < BUFFER_MAX) {
	buffer[index++] = ch;
      }
    } else {
      char *ret_str;
      ungetc(ch, fd);
      ret_str = (char *)malloc(index +1);
      strncpy(ret_str, buffer, index);
      ret_str[index] = '\0';
      return ret_str;
    }
  }
  return NULL;
}


char *get_keyword(const char *file, const char *key) {

  FILE *fd = fopen(file, "r");
  if (!fd) {
    return NULL;
  }

  while (!feof(fd)) {
    while (1) {
      char *keyword;
      char *value;

      if (skipSpace(fd) < 0) {		// 󔒂ǂݔ΂
	break;
      }

      // L[[ho
      keyword = getString(fd);
      if ((!keyword) || (keyword[0] == '#') || (strcmp(key, keyword))) {
	free(keyword);
	break;
      }
      free(keyword);
      if (skipSpace(fd) < 0) {		// 󔒂ǂݔ΂
	skipToLF(fd);
	value = (char *)malloc(sizeof(char));
	value[0] = '\0';
	return value;
      }

      // '=' o
      if (fgetc(fd) != '=') {
	break;
      }
      if (skipSpace(fd) < 0) {		// 󔒂ǂݔ΂
	break;
      }

      // L[[ho
      value = getString(fd);
      if (!value) {
	break;
      }
      return value;
    }
    skipToLF(fd);
  }
  return NULL;
}
