#ifndef SERIAL_DEVICE_C_H
#define SERIAL_DEVICE_C_H

/*
  VA
  Satofumi KAMIMURA
  $Id$
*/

#include "cpp_extern_macro.h"
BEGIN_C_DECLS;

extern int serial_open(const char *devName, long baudrate);
extern void serial_close(int id);
extern int serial_is_connected(int id);
extern int serial_recv(int id, char *data, int size, int timeout);
extern int serial_send(int id, const char *data, int length);
extern void serial_flush(int id);
extern int serial_set_baudrate(int id, long baudrate);

END_C_DECLS;
#endif /* !SERIAL_DEVICE_C_H */
