/*
  SDL ̏
  Satofumi KAMIMURA
  $Id$
*/

#include "sdlBase.h"
#include <stdlib.h>
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_CONFIG_H || HAVE_LIBSDL
#include <SDL.h>
#endif


bool SDL_Base::initialized = false;


SDL_Base::SDL_Base(void) {
  sdl_initialize();
}


SDL_Base::~SDL_Base(void) {
}


void SDL_Base::sdl_initialize(void) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL
  if (!initialized) {
    if (SDL_Init(0) < 0) {
      throw SDL_Exception();
    }
    initialized = true;
    atexit(SDL_Quit);
  }
#endif
}


const char* SDL_Exception::what(void) const throw() {
#if !HAVE_CONFIG_H || HAVE_LIBSDL
  return SDL_GetError();
#else
  return "SDL Library is not installed";
#endif
}
