#ifndef TICKS_POSITION_H
#define TICKS_POSITION_H

/*!
  \file
  \brief w莞̈ʒuԂĕԂ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ticksPositionInterface.h"
#include <list>
#include <functional>


/*!
  \brief w莞ĂȂꍇ͕ԂĕԂNX
*/
class TicksPosition : public VXV::TicksPositionInterface {
  typedef struct {
    VXV::Position3D pos;
    unsigned long ticks;
  } ticksPos_t;
  std::list<ticksPos_t> pos_list;

  class ticks_less :
    public std::binary_function<ticksPos_t, ticksPos_t, bool> {
  public:
    result_type operator()(const first_argument_type lhs,
			   const second_argument_type rhs) {
      return lhs.ticks < rhs.ticks;
    }
  };
  double calcAngle(const VXV::Direction& a,
		   const VXV::Direction& b, double k) const;

public:
  TicksPosition(void);
  ~TicksPosition(void);

  VXV::Position3D getPosition(unsigned long ticks) const;

  /*!
    \brief ʒu̒ǉ

    \param position [i] ʒu
    \param ticks [i] 
  */
  void add(const VXV::Position3D& position, unsigned long ticks);

  /*!
    \brief o^ꂽS̍폜
  */
  void clear(void);

  /*!
    \brief w莞ȑÖʒu폜

    \param ticks [i] 
  */
  void del_olderThan(unsigned long ticks);
};

#endif /* !TICKS_POSITION_H */
