/*
  edraw ̃f[^t@C env `ɕϊ
  Satofumi KAMIMURA
  $Id$
*/

#include <stdlib.h>
#include <math.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <vector>

using namespace std;


typedef struct {
  int x, y;
} point_t;


typedef struct {
  point_t p[2];
} rect_t;


typedef struct {
  vector<point_t> p;
} line_t;


typedef struct {
  int sx, sy;			// Jnn_
  double st;			// ̌

  vector<rect_t> rects;		// `
  vector<line_t> lines;		// 
} env_t;


static bool isLF(char ch) {
  return (ch == '\r' || ch == '\n') ? true : false;
}


static void chomp(std::string& line) {
  while (!line.empty()) {
    int index = line.size() -1;
    if (!isLF(line[index])) {
      break;
    }
    line.erase(index, 1);
  }    
}


static void printUsage(const char* progFile) {
  cout << "usage:\n\t" << progFile << " <edf file>\n";
}


static void errorExit(const char* message) {
  cout << message << endl;
  exit(1);
}


static void parsePoints(point_t p[], int n , string& line) {
  istringstream ist(line);

  char ch;
  for (int i = 0; i < n; ++i, ist >> ch) {
    ist >> p[i].x >> ch >> p[i].y;
  }
}


static int count(string& line, char ch) {
  int count = 0;
  int n = line.size();
  for (int i = 0; i < n; ++i) {
    if (line[i] == ch) {
      ++count;
    }
  }
  return count;
}


static void parse_edf(env_t& env, istream& fin) {
  env.sx = 0;
  env.sy = 0;
  env.st = 0.0;
  
  // f[^̓ǂݏo
  int n;
  fin >> n;

  // f[^̓ǂݏo
  enum {
    Line = 0, Rect = 3,
    Blue = 1, Red = 2, Green = 4,
  };
  string line;
  for (int i = 0; i < n; ++i) {
    char ch;
    int type, val2, val3, color, val5, val6, val7, val8, val9;
    fin >> type >> ch >> val2 >> ch >> val3 >> ch >> color >> ch
	>> val5 >> ch >> val6 >> ch >> val7 >> ch >> val8 >> ch >> val9;
    getline(fin, line);		// sǂݎ̂Ă
    getline(fin, line);		// f[^̂Qs

    if ((color == Blue) && (type == Line)) {
      // 
      point_t p[2];
      parsePoints(p, 2, line);
      env.sx = p[0].x;
      env.sy = p[0].y;
      env.st = atan2(static_cast<double>(p[1].y - p[0].y),
		     static_cast<double>(p[1].x - p[0].x));
      
    } else if (color == Red) {
      if (type == Rect) {
	// `
	point_t p[2];
	parsePoints(p, 2, line);
	rect_t rect;
	rect.p[0].x = p[0].x; rect.p[0].y = p[0].y;
	rect.p[1].x = p[1].x; rect.p[1].y = p[1].y;
	env.rects.push_back(rect);
	
      } else if (type == Line) {
	// 
	int points = (count(line, ',') +1) /2;
	line_t l;
	l.p.resize(points);
	parsePoints(&l.p[0], points, line);
	env.lines.push_back(l);
	
      }
    } else if ((color == Green) && (type == Line)) {
      // oH̏o
      // !!! 
    }
  }
}


static void rotate(int& x, int& y, double t) {
  int x_tmp = static_cast<int>(x * cos(t) - y * sin(t));
  int y_tmp = static_cast<int>(x * sin(t) + y * cos(t));
  x = x_tmp; y = y_tmp;
}


static void adjustPoint(point_t p[], int n, int sx, int sy, double st) {
  for (int i = 0; i < n; ++i) {
    p[i].x = +(p[i].x - sx) * 10;
    p[i].y = -(p[i].y - sy) * 10;
    rotate(p[i].x, p[i].y, st);
  }
}


static void output(ostream& out, env_t& env) {
  
  for (vector<rect_t>::iterator it = env.rects.begin();
       it != env.rects.end(); ++it) {
    adjustPoint(it->p, 2, env.sx, env.sy, env.st);
    out << "(polygon ("
	 << it->p[0].x << ',' << it->p[0].y << ") ("
	 << it->p[1].x << ',' << it->p[0].y << ") ("
	 << it->p[1].x << ',' << it->p[1].y << ") ("
	 << it->p[0].x << ',' << it->p[1].y << ") )" << endl;
  }

  for (vector<line_t>::iterator it = env.lines.begin();
       it != env.lines.end(); ++it) {
    int n = it->p.size();
    adjustPoint(&it->p[0], n, env.sx, env.sy, env.st);
    for (int i = 0; i < n-1; ++i) {
      out << "(polygon ("
	   << it->p[i].x << ',' << it->p[i].y << ") ("
	   << it->p[i+1].x << ',' << it->p[i+1].y << ") ) ";
    }
    out << endl;
  }
}


int main(int argc, char *argv[]) {
  if (argc < 2) {
    printUsage(argv[0]);
    exit(1);
  }

  // edf t@CJ
  ifstream fin(argv[1]);
  if (!fin.is_open()) {
    string error_message = argv[1];
    error_message += " is not found.";
    errorExit(error_message.c_str());
  }

  // wb_̊mF
  string line;
  getline(fin, line);
  chomp(line);
  if (line.compare("EPS-draw Output level 5")) {
    errorExit("syntax error.");
  }

  // f[^
  env_t env;
  parse_edf(env, fin);

  // o̓t@C̐
  string outFile = argv[1];
  int base_last = outFile.find_last_of('.');
  outFile = (base_last > 0) ?
    outFile.substr(0, base_last) + ".env" : outFile + ".env";
  ofstream fout(outFile.c_str());

  // o
  //output(cout, env); // Wo͂ł悢ꍇ
  output(fout, env);
  
  return 0;
}
