/*
  ⡼ľ
  Satofumi KAMIMURA
  $Id$
*/

#include <runCtrl.h>
#include <stdlib.h>


int main(int argc, char *argv[]) {
  try {
    RunCtrl run;
    if (run.connect(argc, argv) < 0) {
      printf("RunCtrl::connect: %s\n", run.getError());
      exit(1);
    }

    // Ϥ줿ͤ⡼Ϳ
    printf("input pwm: [-255, +255]\n");
    int ret_value;
    do {
      int pwm;
      ret_value = scanf("%d", &pwm);
      int mode = (pwm < 0) ? DIRECT_MODE_CCW : DIRECT_MODE_CW;
      unsigned char value = (abs(pwm) > 255) ? 255 : abs(pwm);

      for (int i = 0; i < 2; ++i) {
	run.setMotorMode(i, mode);
	run.setMotorPwm(i, value);
      }
      printf("set mode:%d, pwm:%3d\n", mode, value);
    } while (ret_value == 1);
    run.stop();

  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
