/*
  㳲ʪäư
  Satofumi KAMIMURA
  $Id$
*/

#include <runCtrl.h>
#include <urgCtrl2D.h>

enum {
  ROBOT_WIDTH = 330,
  STOP_TO_OBSTACLE = 500,
};


// ܥåˤ㳲ʪȤεΥ֤
static int senseFront(URGCtrl2D& urg) {
  int length = STOP_TO_OBSTACLE + 1;

  urg.convert2D(0, 0, deg(0));
  for (std::vector<VXV_Grid2D>::iterator it = urg.grid2D_vector.begin();
       it != urg.grid2D_vector.end(); ++it) {
    if ((it->x < -(ROBOT_WIDTH + 30)/2) || (it->x > +(ROBOT_WIDTH + 30)/2)) {
      continue;
    }
    if (it->y < length) {
      length = it->y;
    }
  }
  return length;
}


// ˾㳲ʪ¤ꡢ
static void waitObstacle(RC_Coordinate& crd, URGCtrl2D& urg) {
  VXV_Coordinate& local = crd.createCoordinate();
  local.stop();

  do {
    VXV::Delay(100);
    urg.capture();
  } while (senseFront(urg) < STOP_TO_OBSTACLE);
}


int main(int argc, char *argv[]) {
  try {
    RunCtrl run;
    if (run.connect(argc, argv) < 0) {
      printf("RunCtrl::connect: %s\n", run.getError());
      exit(1);
    }
    URGCtrl2D urg;
    if (urg.connect(argc, argv) < 0) {
      printf("URGCtrl::connect: %s\n", urg.getError());
      exit(1);
    }

    // ľ
    run.followLine(0, 0, deg(0));
    while (1) {
      urg.capture();
      if (senseFront(urg) < STOP_TO_OBSTACLE) {
	waitObstacle(run, urg);
	run.lastMoveCommand();
      }
      VXV::Delay(100);
    }
      
  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
}
  
