/*
  R}h
  Satofumi KAMIMURA
  $Id$
*/

#ifndef __cplusplus
#include "commandCtrl.h"
#else
#include "RC_Coordinate.h"
#endif
#include "packetHandleHost.h"


#ifndef __cplusplus
static runCtrl_t *run;
static nodeInfo_t *node;
static runCtrlParameter_t *runParam;
static int *unique_id;
static unsigned char *con;


void _initCommandCtrl(runCtrl_t *Run, nodeInfo_t *Node,
		     runCtrlParameter_t *RunParam, int *Unique_id) {
  run = Run;
  node = Node;
  runParam = RunParam;
  unique_id = Unique_id;
}
#endif


enum {
  SEND_PACKET_SIZE = 256,
  X = COORD_X, Y = COORD_Y,
};


#define WRITE_PACKET_INIT \
  packetInfo_t pa; \
  ++(*unique_id); \
  initPacketInfo(&pa, send_packet, \
		 (unsigned char *)run, PACKET_WRITE_REQUEST, \
		 getStructId(node, (unsigned char *)run), *unique_id);

#define READ_PACKET_INIT \
  int send_size; \
  packetInfo_t pa; \
  unsigned char send_packet[SEND_PACKET_SIZE]; \
  ++(*unique_id); \
  initPacketInfo(&pa, send_packet, \
		 (unsigned char *)run, PACKET_READ_REQUEST, \
		 getStructId(node, (unsigned char *)run), *unique_id);


#ifdef __cplusplus
int RC_Coordinate::recvVersion(long *version) {
#if 0
}
#endif
#else
int recvVersion(long *version) {
#endif
  int ret_value;
  READ_PACKET_INIT;
  ADD_PACKET_DATA(&pa, run->version);
  send_size = terminatePacketInfo(&pa);
  ret_value= waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
  *version = run->version;
  
  return ret_value;
}


#ifdef __cplusplus
int RC_Coordinate::recvGetPosition(int *x, int *y, long *div16) {
#if 0
}
#endif
#else
int recvGetPosition(int *x, int *y, long *div16) {
#endif
  int ret_value;
  int i;
  
  READ_PACKET_INIT;
  ADD_PACKET_DATA(&pa, run->msec);
  ADD_PACKET_DATA(&pa, run->sec);
  for (i = 0; i < 2; ++i) {
    ADD_PACKET_DATA(&pa, run->gl_crd.km[i]);
    ADD_PACKET_DATA(&pa, run->gl_crd.m[i]);
    ADD_PACKET_DATA(&pa, run->gl_crd.mm[i]);
  }
  ADD_PACKET_DATA(&pa, run->gl_crd.div16);
  send_size = terminatePacketInfo(&pa);
  ret_value = waitPacketResponse(*con, run, send_packet, send_size,
				 *unique_id);
  if (ret_value < 0) {
    return ret_value;
  }
  get_mmCoordinate(&run->gl_crd, x, y);
  *div16 = run->gl_crd.div16;

  return ret_value;
}


#ifdef __cplusplus
int RC_Coordinate::recvStraightVel(int *straight_vel) {
#if 0
}
#endif
#else
int recvStraightVel(int *straight_vel) {
#endif
  READ_PACKET_INIT;
  ADD_PACKET_DATA(&pa, run->velInfo.straight_mm_sec_vel);
  send_size = terminatePacketInfo(&pa);
  *straight_vel = run->velInfo.straight_mm_sec_vel;
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::recvRotateVel(int *rotate_vel) {
#if 0
}
#endif
#else
int recvRotateVel(int *rotate_vel) {
#endif
  READ_PACKET_INIT;
  ADD_PACKET_DATA(&pa, run->velInfo.rotate_div16_sec_vel);
  send_size = terminatePacketInfo(&pa);
  *rotate_vel = run->velInfo.rotate_div16_sec_vel;
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::recvStableValue(int *isStable) {
#if 0
}
#endif
#else
int recvStableValue(int *isStable) {
#endif
  READ_PACKET_INIT;
  ADD_PACKET_DATA(&pa, run->straight.stable);
  ADD_PACKET_DATA(&pa, run->rotate.stable);
  send_size = terminatePacketInfo(&pa);
  *isStable = run->straight.stable * run->rotate.stable;
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendPositionInit(void) {
#if 0
}
#endif
#else
int sendPositionInit(void) {
#endif
  unsigned char send_packet[SEND_PACKET_SIZE];
  int send_size;
  int i;
  
  WRITE_PACKET_INIT;
  for (i = 0; i < 2; ++i) {
    ADD_WRITE_PACKET_DATA(&pa, run->bodyPos.cnt_integer[i], 0);
    ADD_WRITE_PACKET_DATA(&pa, run->bodyPos.cnt_decimal[i], 0);
    ADD_WRITE_PACKET_DATA(&pa, run->bodyPos.body_crd.km[i], 0);
    ADD_WRITE_PACKET_DATA(&pa, run->bodyPos.body_crd.m[i], 0);
    ADD_WRITE_PACKET_DATA(&pa, run->bodyPos.body_crd.mm[i], 0);
    ADD_WRITE_PACKET_DATA(&pa, run->gl_crd_offset.km[i], 0);
    ADD_WRITE_PACKET_DATA(&pa, run->gl_crd_offset.m[i], 0);
    ADD_WRITE_PACKET_DATA(&pa, run->gl_crd_offset.mm[i], 0);
  }
  ADD_WRITE_PACKET_DATA(&pa, run->bodyPos.rotate_num, 0);
  ADD_WRITE_PACKET_DATA(&pa, run->bodyPos.div16_cnt, 0);
  send_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendServoCtrl(bool servo) {
#if 0
}
#endif
#else
int sendServoCtrl(int servo) {
#endif
  unsigned char send_packet[SEND_PACKET_SIZE];
  int send_size;
  
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, run->mode.ctrl,
			servo ? MODE_SERVO_CTRL : MODE_SERVO_FREE);
  send_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendFollowLine(int x, int y, int div16,
				  unsigned char *send_packet,
				  int *send_packet_size) {
#if 0
}
#endif
#else
int sendFollowLine(int x, int y, int div16,
				   unsigned char *send_packet,
				   int *send_packet_size) {
#endif
  int i;
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, run->mode.ctrl, MODE_SERVO_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.straight_ctrl,MODE_HOLD_VELOCITY_FIRST);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.ref_vel,runParam->straight_ref_vel);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.acc, runParam->straight_ref_acc);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.rotate_ctrl, MODE_FOLLOW_LINE_FIRST);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.ref_vel, runParam->rotate_ref_vel);
  ADD_WRITE_PACKET_DATA(&pa,run->rotate.acc, runParam->rotate_ref_acc);
  ADD_WRITE_PACKET_DATA(&pa,run->mode.follow_r, runParam->follow_r);
  initCoordinateInfo(&run->run_crd_offset);
  run->run_crd_offset.mm[X] = -x;
  run->run_crd_offset.mm[Y] = -y;
  run->run_crd_offset.div16 = -div16;
  adjustCoordinateRange(&run->run_crd_offset);
  for (i = 0; i < 2; ++i) {
    ADD_PACKET_DATA(&pa, run->run_crd_offset.km[i]);
    ADD_PACKET_DATA(&pa, run->run_crd_offset.m[i]);
    ADD_PACKET_DATA(&pa, run->run_crd_offset.mm[i]);
  }
  ADD_PACKET_DATA(&pa, run->run_crd_offset.div16);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.stable, 0);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.stable, 0);
  *send_packet_size = terminatePacketInfo(&pa);

  return waitPacketResponse(*con, run,
			    send_packet, *send_packet_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendFollowCircle(int x, int y, int radius,
				    unsigned char *send_packet,
				    int *send_packet_size) {
#if 0
}
#endif
#else
int sendFollowCircle(int x, int y, int radius,
			    unsigned char *send_packet,
			    int *send_packet_size) {
#endif
  int i;
  
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, run->mode.ctrl, MODE_SERVO_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.straight_ctrl,MODE_HOLD_VELOCITY_FIRST);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.ref_vel,runParam->straight_ref_vel);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.acc, runParam->straight_ref_acc);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.rotate_ctrl, MODE_FOLLOW_CIRCLE_FIRST);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.ref_vel, runParam->rotate_ref_vel);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.acc, runParam->rotate_ref_acc);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.circle_r, radius);
  ADD_WRITE_PACKET_DATA(&pa,run->mode.follow_r, runParam->follow_r);
  initCoordinateInfo(&run->run_crd_offset);
  run->run_crd_offset.mm[X] = -x;
  run->run_crd_offset.mm[Y] = -y;
  adjustCoordinateRange(&run->run_crd_offset);
  for (i = 0; i < 2; ++i) {
    ADD_PACKET_DATA(&pa, run->run_crd_offset.km[i]);
    ADD_PACKET_DATA(&pa, run->run_crd_offset.m[i]);
    ADD_PACKET_DATA(&pa, run->run_crd_offset.mm[i]);
  }
  ADD_WRITE_PACKET_DATA(&pa, run->run_crd_offset.div16, 0);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.stable, 0);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.stable, 0);
  *send_packet_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run,
			    send_packet, *send_packet_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendStopToLine(int x, int y, int div16,
				  unsigned char *send_packet,
				  int *send_packet_size) {
#if 0
}
#endif
#else
int sendStopToLine(int x, int y, int div16,
			  unsigned char *send_packet,
			  int *send_packet_size) {
#endif
  int i;
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, run->mode.ctrl, MODE_SERVO_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.straight_ctrl,MODE_HOLD_POSITION_FIRST);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.ref_vel,runParam->straight_ref_vel);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.acc, runParam->straight_ref_acc);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.rotate_ctrl, MODE_HOLD_ANGLE_FIRST);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.ref_vel, runParam->rotate_ref_vel);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.acc, runParam->rotate_ref_acc);
  initCoordinateInfo(&run->run_crd_offset);
  run->run_crd_offset.mm[X] = -x;
  run->run_crd_offset.mm[Y] = -y;
  run->run_crd_offset.div16 = -div16;
  adjustCoordinateRange(&run->run_crd_offset);
  for (i = 0; i < 2; ++i) {
    ADD_PACKET_DATA(&pa, run->run_crd_offset.km[i]);
    ADD_PACKET_DATA(&pa, run->run_crd_offset.m[i]);
    ADD_PACKET_DATA(&pa, run->run_crd_offset.mm[i]);
  }
  ADD_PACKET_DATA(&pa, run->run_crd_offset.div16);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.stable, 0);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.stable, 0);
  *send_packet_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run,
			    send_packet, *send_packet_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendStop(unsigned char *send_packet,
			    int *send_packet_size) {
#if 0
}
#endif
#else
int sendStop(unsigned char *send_packet, int *send_packet_size) {
#endif
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, run->mode.ctrl, MODE_SERVO_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.straight_ctrl,MODE_STOP_FIRST);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.acc, runParam->straight_ref_acc);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.rotate_ctrl, MODE_NO_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.stable, 0);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.stable, 0);
  *send_packet_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run,
			    send_packet, *send_packet_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendRotateAngle(int rotate_div16,
				   unsigned char *send_packet,
				   int *send_packet_size) {
#if 0
}
#endif
#else
int sendRotateAngle(int rotate_div16,
				    unsigned char *send_packet,
				    int *send_packet_size) {
#endif
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, run->mode.ctrl, MODE_SERVO_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.straight_ctrl,MODE_NO_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.rotate_ctrl, MODE_ROTATE_ANGLE_FIRST);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.ref_vel, runParam->rotate_ref_vel);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.acc, runParam->rotate_ref_acc);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.circle_r, rotate_div16);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.stable, 0);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.stable, 0);
  *send_packet_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run,
			    send_packet, *send_packet_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendTurnToAngle(int rotate_div16,
				   unsigned char *send_packet,
				   int *send_packet_size) {
#if 0
}
#endif
#else
int sendTurnToAngle(int rotate_div16,
			   unsigned char *send_packet, int *send_packet_size) {
#endif
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, run->mode.ctrl, MODE_SERVO_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.straight_ctrl,MODE_NO_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.rotate_ctrl, MODE_HOLD_ANGLE_FIRST);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.ref_vel, runParam->rotate_ref_vel);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.acc, runParam->rotate_ref_acc);
  ADD_WRITE_PACKET_DATA(&pa, run->run_crd_offset.div16, -rotate_div16);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.stable, 0);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.stable, 0);
  *send_packet_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run,
			    send_packet, *send_packet_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendSpin(int rotate_div16,
			    unsigned char *send_packet,
			    int *send_packet_size) {
#if 0
}
#endif
#else
int sendSpin(int rotate_div16,
	     unsigned char *send_packet, int *send_packet_size) {
#endif
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, run->mode.ctrl, MODE_SERVO_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.straight_ctrl,MODE_NO_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->mode.rotate_ctrl,
			MODE_HOLD_ROTATE_VELOCITY_FIRST);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.ref_vel, rotate_div16);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.acc, runParam->rotate_ref_acc);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.stable, 0);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.stable, 0);
  *send_packet_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run,
			    send_packet, *send_packet_size, *unique_id);
}




#ifdef __cplusplus
int RC_Coordinate::sendLastMoveCommand(int last_command_unique_id,
				       unsigned char *send_packet,
				       int send_packet_size) {
#if 0
}
#endif
#else
int sendLastMoveCommand(int last_command_unique_id,
			       unsigned char *send_packet,
			       int send_packet_size) {
#endif
  return waitPacketResponse(*con, run,
			    send_packet, send_packet_size,
			    last_command_unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendChangeCoordinateOffset(int x, int y, int div16) {
#if 0
}
#endif
#else
int sendChangeCoordinateOffset(int x, int y, int div16) {
#endif
  unsigned char send_packet[SEND_PACKET_SIZE];
  int send_size;
  int i;
  
  WRITE_PACKET_INIT;
  initCoordinateInfo(&run->run_crd_offset);
  run->run_crd_offset.mm[X] = -x;
  run->run_crd_offset.mm[Y] = -y;
  adjustCoordinateRange(&run->run_crd_offset);
  for (i = 0; i < 2; ++i) {
    ADD_PACKET_DATA(&pa, run->run_crd_offset.km[i]);
    ADD_PACKET_DATA(&pa, run->run_crd_offset.m[i]);
    ADD_PACKET_DATA(&pa, run->run_crd_offset.mm[i]);
  }
  ADD_WRITE_PACKET_DATA(&pa, run->run_crd_offset.div16, div16);
  send_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run,
			    send_packet, send_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendStraightRef(int straight_mm_vel, int straight_acc) {
#if 0
}
#endif
#else
int sendStraightRef(int straight_mm_vel, int straight_acc) {
#endif
  unsigned char send_packet[SEND_PACKET_SIZE];
  int send_size;
  
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, run->straight.ref_vel, straight_mm_vel);
  ADD_WRITE_PACKET_DATA(&pa, run->straight.acc, straight_acc);
  send_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendRotateRef(int rotate_div16_vel, int rotate_acc) {
#if 0
}
#endif
#else
int sendRotateRef(int rotate_div16_vel, int rotate_acc) {
#endif
  unsigned char send_packet[SEND_PACKET_SIZE];
  int send_size;
  
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.ref_vel, rotate_div16_vel);
  ADD_WRITE_PACKET_DATA(&pa, run->rotate.acc, rotate_acc);
  send_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendCurveRadius(int radius_mm) {
#if 0
}
#endif
#else
int sendCurveRadius(int radius_mm) {
#endif
  unsigned char send_packet[SEND_PACKET_SIZE];
  int send_size;
  
  WRITE_PACKET_INIT;
  ADD_WRITE_PACKET_DATA(&pa, run->mode.follow_r, radius_mm);
  send_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}



#ifdef __cplusplus
int RC_Coordinate::sendGLOffset(int x, int y, long div16) {
#if 0
}
#endif
#else
int sendGLOffset(int x, int y, long div16) {
#endif
  enum { X = COORD_X, Y = COORD_Y };
  unsigned char send_packet[SEND_PACKET_SIZE];
  int send_size;
  coordinateInfo_t crd;
  
  WRITE_PACKET_INIT;
  initCoordinateInfo(&crd);
  crd.mm[X] = -x;
  crd.mm[Y] = -y;
  adjustCoordinateRange(&crd);
  ADD_WRITE_PACKET_DATA(&pa, run->gl_crd_offset.km[X], crd.km[X]);
  ADD_WRITE_PACKET_DATA(&pa, run->gl_crd_offset.m[X], crd.m[X]);
  ADD_WRITE_PACKET_DATA(&pa, run->gl_crd_offset.mm[X], crd.mm[X]);
  ADD_WRITE_PACKET_DATA(&pa, run->gl_crd_offset.km[Y], crd.km[Y]);
  ADD_WRITE_PACKET_DATA(&pa, run->gl_crd_offset.m[Y], crd.m[Y]);
  ADD_WRITE_PACKET_DATA(&pa, run->gl_crd_offset.mm[Y], crd.mm[Y]);
  ADD_WRITE_PACKET_DATA(&pa, run->gl_crd_offset.div16, -div16);
  send_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::recvGLOffset(int *x, int *y, long *div16) {
#if 0
}
#endif
#else
int recvGLOffset(int *x, int *y, long *div16) {
#endif
  int ret_value;
  READ_PACKET_INIT;
  ADD_PACKET_DATA(&pa, run->gl_crd_offset.km[X]);
  ADD_PACKET_DATA(&pa, run->gl_crd_offset.m[X]);
  ADD_PACKET_DATA(&pa, run->gl_crd_offset.mm[X]);
  ADD_PACKET_DATA(&pa, run->gl_crd_offset.km[Y]);
  ADD_PACKET_DATA(&pa, run->gl_crd_offset.m[Y]);
  ADD_PACKET_DATA(&pa, run->gl_crd_offset.mm[Y]);
  ADD_PACKET_DATA(&pa, run->gl_crd_offset.div16);
  get_mmCoordinate(&run->gl_crd_offset, x, y);
  *div16 = run->gl_crd_offset.div16;

  send_size = terminatePacketInfo(&pa);
  ret_value= waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
  
  return ret_value;
}



// directCmdCtrl

#ifdef __cplusplus
int RC_Coordinate::recvEncoderDiff(int id, int *diff) {
#if 0
}
#endif
#else
int recvEncoderDiff(int id, int *diff) {
#endif
  int ret_value;
  READ_PACKET_INIT;
  if ((id < 0) || (id > 1)) {
    return -1;
  }
  ADD_PACKET_DATA(&pa, run->enc[id].diff);
  send_size = terminatePacketInfo(&pa);
  ret_value= waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
  *diff = run->enc[id].diff;
  
  return ret_value;
}


#ifdef __cplusplus
int RC_Coordinate::sendMotorMode(int id, unsigned char mode) {
#if 0
}
#endif
#else
int sendMotorMode(int id, unsigned char mode) {
#endif
  unsigned char send_packet[SEND_PACKET_SIZE];
  int send_size;
  
  WRITE_PACKET_INIT;
  if ((id < 0) || (id > 1)) {
    return -1;
  }
  ADD_WRITE_PACKET_DATA(&pa, run->mode.ctrl, MODE_DIRECT_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->direct[id].mode, mode);
  send_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendMotorDuty(int id, unsigned char duty) {
#if 0
}
#endif
#else
int sendMotorDuty(int id, unsigned char duty) {
#endif
  unsigned char send_packet[SEND_PACKET_SIZE];
  int send_size;
  
  WRITE_PACKET_INIT;
  if ((id < 0) || (id > 1)) {
    return -1;
  }
  ADD_WRITE_PACKET_DATA(&pa, run->mode.ctrl, MODE_DIRECT_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->direct[id].pwm, duty);
  send_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}


#ifdef __cplusplus
int RC_Coordinate::sendWheelVel(int id, int mm_vel) {
#if 0
}
#endif
#else
int sendWheelVel(int id, int mm_vel) {
#endif
  unsigned char send_packet[SEND_PACKET_SIZE];
  int send_size;
  
  WRITE_PACKET_INIT;
  if ((id < 0) || (id > 1)) {
    return -1;
  }
  ADD_WRITE_PACKET_DATA(&pa, run->mode.ctrl, MODE_DIRECT_WHEEL_CTRL);
  ADD_WRITE_PACKET_DATA(&pa, run->directWhl[id].ref_mm_sec_vel, mm_vel);
  send_size = terminatePacketInfo(&pa);
  
  return waitPacketResponse(*con, run, send_packet, send_size, *unique_id);
}
