/*
  WnR}h
  Satofumi KAMIMURA
  $Id$
*/

#include "coordinate_ctrl.h"
#include "commandCtrl.h"
#include "move_ctrl.h"

enum { NO_OFFSET_DATA = -1 };


#define CRD_EFFECT_CALL \
  if (crdEffectMode) { \
    int c_x, c_y, c_div16; \
    int crd_id, crd_x, crd_y, crd_div16; \
    getLastCommandPosition(&crd_id, &crd_x, &crd_y, &crd_div16); \
    getCoordinateOffset(&c_x,&c_y,&c_div16,GL,crd_id,crd_x,crd_y,crd_div16); \
    sendChangeCoordinateOffset(c_x, c_y, c_div16); \
  }


static offsetInfo_t *CrdInfo = NULL;
static int CrdInfoMax = 0;
static int CrdInfoNext = 0;
static int crdEffectMode = CRD_EFFECT_OFF;


static void initOffsetInfo(offsetInfo_t *offset) {
  offset->parent_id = GL;
  offset->x = 0;
  offset->y = 0;
  offset->div16 = 0;
}


/*!
  \brief Wn̏

  \param crdInfo [o] Wn
  \param num [i] Wn̐
  
  \attention [UĂԕKv͂Ȃ
*/
void _initCoordinateCtrl(offsetInfo_t *crdInfo, int num) {
  int i;
  
  CrdInfo = crdInfo;
  CrdInfoMax = num;

  for (i = 0; i < num; ++i) {
    CrdInfo[i].parent_id = NO_OFFSET_DATA;
  }

  // GL, FS ̏
  initOffsetInfo(&CrdInfo[GL]);
  initOffsetInfo(&CrdInfo[FS]);
  CrdInfo[FS].parent_id = GL;
  CrdInfoNext = 2;
}


//static int getGLBodyPos(int *x, int *y, int *div16) {
//return recvGetPosition(x, y, div16);
//}


/*!
  \brief 莩Ȉʒu̎擾

  \param dest_id [i] WnID
  \param *x [i] Xl
  \param *y [i] Yl
  \param *div16 [i] px
  \retval 0 I
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL getBodyPos(int dest_id, int *x, int *y, int *div16) {
  int gl_x, gl_y;
  long gl_div16;

  int ret_value = recvGetPosition(&gl_x, &gl_y, &gl_div16);
  if (ret_value < 0) {
    return ret_value;
  }
  if (dest_id == FS) {
    updateParentOffset(dest_id, gl_x, gl_y, gl_div16);
    *x = 0;
    *y = 0;
    *div16 = 0;

  } else if (dest_id != GL) { // LC
    // 擾 GL ̈ʒuAWnłǂ̈ʒuɂ邩Ԃ
    ret_value = getCoordinateOffset(x, y, div16, dest_id,
				    GL, gl_x, gl_y, gl_div16);
  }
  return ret_value;
}


/*!
  \brief VKWn̍쐬

  \retval ߂l > 0 WnID
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL createCoordinate(void) {
  int i;
  for (i = 0; i <= CrdInfoNext; ++i) {
    if (CrdInfo[i].parent_id == NO_OFFSET_DATA) {
      initOffsetInfo(&CrdInfo[i]);
      return i;
    }
  }
  return -1;
}


/*!
  \brief Wn̍폜

  \param crd_id [i] WnID
  \retval 0 I
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL deleteCoordinate(int crd_id) {
  CrdInfo[crd_id].parent_id = NO_OFFSET_DATA;
  return 0;
}


/*!
  \brief eWnID ̎擾

  nꂽWnID ̐eɂWnID Ԃ

  \param crd_id [i] WnID
  \retval ߂l > 0 eWnID
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL getParentId(int crd_id) {
  return CrdInfo[crd_id].parent_id;
}


int getGLCoordinateOffset(int *offset_x, int *offset_y,
			  int *offset_div16,
			  int dest_id, int x, int y, int div16) {
  offsetInfo_t diff;
  int id;
  
  diff.x = x;
  diff.y = y;
  diff.div16 = div16;
  
  id = dest_id;
  while (id != GL) {
    int x_tmp = diff.x;
    int y_tmp = diff.y;
    double radian = 2.0 * M_PI * CrdInfo[id].div16 / 0x10000;
    diff.x = (int)(x_tmp * cos(radian) - y_tmp * sin(radian)) + CrdInfo[id].x;
    diff.y = (int)(x_tmp * sin(radian) + y_tmp * cos(radian)) + CrdInfo[id].y;
    diff.div16 += CrdInfo[dest_id].div16;
    id = CrdInfo[id].parent_id;
  }
  
  *offset_x = diff.x;
  *offset_y = diff.y;
  *offset_div16 = diff.div16 & 0xffff;

  return 0;
}


/*!
  \brief wWn̓_AڕWWn̂ǂɂ邩Ԃ
  
*/
DECLSPEC int RCCALL getCoordinateOffset(int *offset_x, int *offset_y,
					int *offset_div16,
					int base_id,
					int target_id,
					int x, int y, int div16) {
  offsetInfo_t base_offset, this_offset;
  int x_diff, y_diff;
  double radian;
  
    // x GL 猩Wn擾AΓIȈʒuvZĕԂ
  if (base_id == GL) {
    return getGLCoordinateOffset(offset_x, offset_y, offset_div16,
				 target_id, x, y, div16);
  }
  getCoordinateOffset(&base_offset.x, &base_offset.y, &base_offset.div16,
		      GL, base_id, 0, 0, 0);
  getCoordinateOffset(&this_offset.x, &this_offset.y, &this_offset.div16,
		      GL, target_id, x, y, div16);
  
  x_diff = this_offset.x - base_offset.x;
  y_diff = this_offset.y - base_offset.y;
  *offset_div16 = (this_offset.div16 - base_offset.div16) & 0xffff;

  // ]
  radian = 2.0 * M_PI * *offset_div16 / 0x10000;
  *offset_x = (int)(x_diff * cos(radian) - y_diff * sin(radian));
  *offset_y = (int)(x_diff * sin(radian) + y_diff * cos(radian));

  return 0;
  
#if 0
  int diff_x = x;
  int diff_y = y;
  int diff_div16 = div16;
  int crd_id = target_id;

  while (crd_id == GL) {
    int x_tmp = diff_x;
    int y_tmp = diff_y;
    double radian = 2.0 * M_PI * CrdInfo[crd_id].div16 / 65536;

    diff_x = (int)(x_tmp * cos(radian) - y_tmp * sin(radian));
    diff_y = (int)(x_tmp * sin(radian) + y_tmp * cos(radian));
    diff_x += CrdInfo[crd_id].x;
    diff_y += CrdInfo[crd_id].y;
    diff_div16 += CrdInfo[crd_id].div16;

    crd_id = CrdInfo[crd_id].parent_id;
  }

  *offset_x = diff_x;
  *offset_y = diff_y;
  *offset_div16 = diff_div16 & 0xffff;
  return 0;
#endif
}


/*!
  \brief eWnƂ̑ΈʒuXV

  \param dest_id [i] WnID
  \param x [i] X Wl
  \param y [i] Y Wl
  \param div16 [i] px
  \retval *this
*/
int updateParentOffset(int dest_id, int x, int y, int div16) {
  int ret_value;

  if (dest_id == GL) {
    ret_value = sendGLOffset(x, y, div16);
    if (ret_value < 0) {
      return ret_value;
    }
  } else {
    CrdInfo[dest_id].x = x;
    CrdInfo[dest_id].y = y;
    CrdInfo[dest_id].div16 = div16;
  }
  
  CRD_EFFECT_CALL;
  
  return 0;
}



/*!
  \brief Wn̒t

  Wn(e)̎wʒuɁAWň_ݒ肷

  \param dest_id [o] Ώۂ̍WnID
  \param parent_id [i] eɐݒ肷WnID
  \param x [i] Xl
  \param y [i] Yl
  \param div16 [i] px
  \retval 0 I
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL setCoordinateParent(int dest_id, int parent_id,
					int x, int y, int div16) {
  int id;
  
  // GL, FS ͍Wn̒ւ֎~
  if ((dest_id == GL) || (dest_id == FS)) {
    return -1;
  }

  // g̍Wnł̒ւ
  if (dest_id == parent_id) {
    offsetInfo_t offset = CrdInfo[dest_id];
    double radian = 2.0 * M_PI * offset.div16 / 0x10000;
    offset.x += (int)(x * cos(radian) - y * sin(radian));
    offset.y += (int)(x * sin(radian) + y * cos(radian));
    offset.div16 += div16;
    /*
    int offset_x = CrdInfo[dest_id].x + x;
    int offset_y = CrdInfo[dest_id].y + y;
    int offset_div16 = CrdInfo[dest_id].div16 + div16;
    */
    return updateParentOffset(dest_id, offset.x, offset.y, offset.div16);
  }

  // eqɒt悤ƂAO𓊂
  for (id = dest_id; dest_id != GL; dest_id = CrdInfo[dest_id].parent_id) {
    if (dest_id == parent_id) {
      return -1;
    }
  }
  
  CrdInfo[dest_id].parent_id = parent_id;
  CrdInfo[dest_id].x = x;
  CrdInfo[dest_id].y = y;
  CrdInfo[dest_id].div16 = div16;

  CRD_EFFECT_CALL;
  
  return 0;
}


/*!
  \brief Wn̎wʒu➑̈ʒu悤ɍWnݒ肷

  \param dest_id [o] Ώۂ̍Wn
  \param x [i] Xl
  \param y [i] Yl
  \param div16 [i] px
  \retval 0 I
  \retval ߂l < 0 G[
*/
DECLSPEC int RCCALL setCoordinateBody(int dest_id, int x, int y, int div16) {
  int pos_x, pos_y, pos_div16;
  int ret_value;

  if ((dest_id == GL) || (dest_id == FS)) {
    return -1;
  }

  ret_value = getBodyPos(dest_id, &pos_x, &pos_y, &pos_div16);
  if (ret_value < 0) {
    return ret_value;
  }

  return setCoordinateParent(CrdInfo[dest_id].parent_id,
			     dest_id, pos_x, pos_y, pos_div16);
}


/*!
  \brief WnŜĐݒ肷

  GLWň_ GLWn̈ʒuɒւ

  \param x [i] Xl
  \param y [i] Yl
  \param div16 [i] px
  \retval 0 I
  \retval ߂l < 0 G[

  \todo 
*/  
DECLSPEC int RCCALL adjustBodyPos(int x, int y, int div16) {

  CRD_EFFECT_CALL

  return -1;
}


/*!
  \brief Wn̕ύXړoHɗ^邩ݒ肷

  \param mode [i] e^邩
  \retval 0 I
*/
DECLSPEC int RCCALL setCoordinateMode(int mode) {
  crdEffectMode = (mode == CRD_EFFECT_ON) ? CRD_EFFECT_ON : CRD_EFFECT_OFF;
  return 0;
}
