/*
  s̕⏕֐
  Satofumi KAMIMURA
  $Id$
*/

#include "run_utils.h"
#if defined _MBCS || defined WIN32
#define WINDOWS
#else
#define LINUX
#endif
#ifndef _MBCS
#include <unistd.h>
#endif
#include <math.h>
#include "math_util.h"

#ifdef WINDOWS
#include <windows.h>
#endif


/*!
  \brief div16 ւ̊pxϊ

  \param degree [i] px [degree]
  \retval div16
*/
DECLSPEC int RCCALL deg(int degree) {
  return (int)(65536 * degree / 360);
}


/*!
  \brief div16 ւ̊pxϊ

  \param radian [i] px [radian]
  \retval div16
*/
DECLSPEC int RCCALL rad(double radian) {
  return (int)(65536 * radian / (2.0 * M_PI));
}


/*!
  \brief div16 ̊pxϊ

  \param div16 [i] px [div16]
  \retval px [degree]
*/
DECLSPEC int RCCALL to_deg(int div16) {
  return (360 * div16 / 65536);
}


/*!
  \brief div16 ̊pxϊ

  \param div16 [i] px [div16]
  \retval px [radian]
*/
DECLSPEC double RCCALL to_rad(int div16) {
  return (2.0 * M_PI * div16 / 65536.0);
}


/*!
  \brief mWait()p̕ϊ֐

  \param second [i]  [sec]
  \retval  [msec]
*/
DECLSPEC int RCCALL sec(double second) {
  return (1000.0 * second);
}


/*!
  \brief w莞Ԃҋ@

  \param msec [i] ҋ@ [msec]
  \retval Ȃ
*/
DECLSPEC void RCCALL mWait(int msec) {
#ifdef __linux__
  usleep(1000 * msec);
#elif __WIN32__ || _MBCS
  Sleep(msec);
#endif
}
