/*
  Wn̑
  Satofumi KAMIMURA
  $Id$
*/

#include "RC_Coordinate.h"


VXV_Coordinate* RC_Coordinate::getGLObj(void) {
  return crd_gl;
}


VXV_Coordinate* RC_Coordinate::getParentObj(void) {
  return crd_parent;
}


std::list<RC_Coordinate*>* RC_Coordinate::getChildrenObj(void) {
  return &crd_children;
}


RC_Coordinate::RC_Coordinate(void)
  : crd_attribute(RC_LC), crd_gl(this), crd_parent(this),
    send_command_size(0) {
  crd_offset.x = 0;
  crd_offset.y = 0;
  crd_offset.t.div16 = 0;
  crd_children.clear();
}


/*!
  \brief WnIuWFNg̃Rs[RXgN^

  \param rhs [i] WnIuWFNg
*/
RC_Coordinate::RC_Coordinate(const RC_Coordinate& rhs)
  : crd_offset(rhs.crd_offset),
    crd_attribute(rhs.crd_attribute),
    crd_gl(rhs.crd_gl),
    crd_parent(rhs.crd_parent),
    con(rhs.con),
    run(rhs.run),
    node(rhs.node),
    unique_id(rhs.unique_id),
    runParam(rhs.runParam),
    send_command_size(rhs.send_command_size), 
    cmdPos(rhs.cmdPos),
    crdEffectMode(rhs.crdEffectMode) {
  crd_children.clear();
  for (int i = 0; i < send_command_size; ++i) {
    send_command[i] = rhs.send_command[i];
  }
}


/*!
  \brief WnIuWFNg̑RXgN^

  \param rhs [i] WnIuWFNg
*/
RC_Coordinate& RC_Coordinate::operator=(const RC_Coordinate& rhs) {
  if ((this == NULL) || (this == &rhs)) {
    return *this;
  }
  crd_offset = rhs.crd_offset;
  crd_attribute = rhs.crd_attribute;
  crd_gl = rhs.crd_gl;
  crd_parent = rhs.crd_parent;
  con = rhs.con;
  run = rhs.run;
  node = rhs.node;
  unique_id = rhs.unique_id;
  runParam = rhs.runParam;
  send_command_size = rhs.send_command_size;
  cmdPos = rhs.cmdPos;
  crdEffectMode = rhs.crdEffectMode;
  crd_children.clear();
  for (int i = 0; i < send_command_size; ++i) {
    send_command[i] = rhs.send_command[i];
  }

  return *this;
}


RC_Coordinate::~RC_Coordinate(void) {
  //fprintf(stderr, "%p, x: %d, %p", this, crd_offset.x, crd_parent);
  
  if (crd_attribute == RC_GL) {
    return;
  }

  // ŗĂ
  // !!! ۗ
  crd_parent->getChildrenObj()->remove(this);

  
  // Rei̗vf𑀍삷邽߁Aʏ for [vł܂킷
  unsigned int length = crd_children.size();
  std::list<RC_Coordinate*>::iterator it = crd_children.begin();
  for (unsigned int i = 0; i < length; ++i) {
    VXV_Position offset = (*it)->getParentOffset(0, 0, deg(0));
    (*it)->setCoordinate(*crd_parent, offset);
    ++it;
  }
  //fprintf(stderr, "\n");
}
