/*
  Wn̑
  Satofumi KAMIMURA
  $Id$
*/

#include "RC_Coordinate.h"


#define CRD_EFFECT_CALL(X) \
  if (*crdEffectMode && (send_command_size > 0)) { \
    VXV_Position c=getGLCoordinateOffset(cmdPos.x,cmdPos.y,cmdPos.t); \
    if (sendChangeCoordinateOffset(c.x, c.y, c.t.div16) < 0) { \
      throw ConnectionError(X); \
    } \
  }


VXV_Position RC_Coordinate::getPosition(void) {
  VXV_Position position;
  if (recvGetPosition(&position.x, &position.y, &position.t.div16) < 0) {
    throw ConnectionError("getPosition");
  }
  if (crd_attribute == RC_FS) {
    updateParentOffset(position.x, position.y, position.t);
    position.x = 0;
    position.y = 0;
    position.t.div16 = 0;
    
  } else if (crd_attribute != RC_GL) { // LC
    // 擾 GL ̈ʒuAWnłǂ̈ʒuɂ邩Ԃ
    position = this->getCoordinateOffset(position, *crd_gl);
  }
  return position;
}


VXV_Coordinate& RC_Coordinate::getParent(void) {
  return *crd_parent;
}


VXV_Position RC_Coordinate::getParentOffset(const VXV_Position& position) {
  return getParentOffset(position.x, position.y, position.t);
}


VXV_Position RC_Coordinate::getParentOffset(int x, int y,
					   const VXV_Direction& t) {
  return crd_offset;
}


VXV_Position RC_Coordinate::getCoordinateOffset(const VXV_Position& position,
						 const VXV_Coordinate& base) {
  return getCoordinateOffset(position.x, position.y, position.t, base);
}


VXV_Position RC_Coordinate::getGLCoordinateOffset(int x, int y,
						   const VXV_Direction& t) {
  // FSWn̏ꍇ
  if (crd_attribute == RC_FS) {
    VXV_Position gl_pos = crd_gl->getPosition();
    updateParentOffset(gl_pos.x, gl_pos.y, gl_pos.t);
  }
    
  VXV_Position diff;
  diff.x = x;
  diff.y = y;
  diff.t.div16 = t.div16;
  RC_Coordinate *p = this;
  while (p->crd_attribute != RC_GL) {
    int x_tmp = diff.x;
    int y_tmp = diff.y;
    double radian = p->crd_offset.rad();
    diff.x =
      (int)(x_tmp * cos(radian) - y_tmp * sin(radian)) + p->crd_offset.x;
    diff.y =
      (int)(x_tmp * sin(radian) + y_tmp * cos(radian)) + p->crd_offset.y;
    diff.t.div16 += p->crd_offset.t.div16;
    p = (RC_Coordinate*)p->crd_parent;
  }
  
  VXV_Position offset;
  offset.x = diff.x;
  offset.y = diff.y;
  offset.t.div16 = diff.t.div16 & 0xffff;
  return offset;
}


VXV_Position RC_Coordinate::getCoordinateOffset(int x, int y,
						const VXV_Direction& t,
						const VXV_Coordinate& base) {
  VXV_Coordinate* baseGLObj = const_cast<VXV_Coordinate&>(base).getGLObj();
  //if (this->crd_gl != base.crd_gl) {
  if (this->crd_gl != baseGLObj) {
    throw CoordinateError("getCoordinateOffset");
  }
  
  // x GL 猩Wn擾AΓIȈʒuvZĕԂ
  //if (&base == base.crd_gl) {
  if (this->crd_gl != baseGLObj) {
    return getGLCoordinateOffset(x, y, t);
  }
  VXV_Position base_offset =
    const_cast<VXV_Coordinate&>(base).getCoordinateOffset(0, 0, deg(0),
							  *baseGLObj);
  VXV_Position this_offset = getCoordinateOffset(x, y, t, *baseGLObj);
  
  VXV_Position offset;
  int x_diff = this_offset.x - base_offset.x;
  int y_diff = this_offset.y - base_offset.y;
  offset.t.div16 = (this_offset.t.div16 - base_offset.t.div16) & 0xffff;

  // ]
  double radian = offset.rad();
  offset.x = (int)(x_diff * cos(radian) - y_diff * sin(radian));
  offset.y = (int)(x_diff * sin(radian) + y_diff * cos(radian));
  
  return offset;
}


VXV_Coordinate& RC_Coordinate::clone(void) {
  if ((crd_attribute == RC_GL) || (crd_attribute == RC_FS)) {
    throw ConnectionError("clone");
  }
  return createCoordinate(0, 0, deg(0));
}


VXV_Coordinate& RC_Coordinate::createCoordinate(void) {
  return createCoordinate(0, 0, deg(0));
}


VXV_Coordinate& RC_Coordinate::createCoordinate(const VXV_Position& offset) {
  return createCoordinate(offset.x, offset.y, offset.t);
}


VXV_Coordinate& RC_Coordinate::createCoordinate(int x, int y,
						 const VXV_Direction& t) {

  RC_Coordinate crd = *this;
  crd.crd_attribute = RC_LC;
  crd.crd_parent = this;
  
  if (this->crd_attribute == RC_FS) {
    // FS ɒt悤w肳ꂽWńAGL ɒt
    VXV_Position gl_pos = crd_gl->getPosition();
    return crd.setCoordinate(*crd_gl, gl_pos);
    
  } else {
    crd.crd_parent = this;
    return crd.setCoordinate(*this, x, y, t);
  }
}


VXV_Coordinate& RC_Coordinate::setCoordinate(VXV_Coordinate& base,
					    const VXV_Position& offset) {
  return setCoordinate(base, offset.x, offset.y, offset.t);
}


VXV_Coordinate& RC_Coordinate::setCoordinate(VXV_Coordinate& base,
					    int x, int y,
					    const VXV_Direction& t) {

  // w肵Wn̂ǂɌ_zu邩w肷
  //  this  parent ύXƁA this.parent  children 폜
  // V crd ɂāAparent o^ children o^Kv

  // crd_gl قȂĂAO𓊂
  //if (crd_gl != base.crd_gl) {
  if (crd_gl != base.getGLObj()) {
    throw CoordinateError("setCoordinate");
  }
  
  // GL, FS ͍Wn̒ւ֎~
  if ((crd_attribute == RC_GL) || (crd_attribute == RC_FS)) {
    throw CoordinateError("setCoordinate");
  }

  // g̍Wnł̒ւ
  if (&base == this) {
    return updateParentOffset(*this, x, y, t);
  }

  // eqɒt悤ƂAO𓊂
  for (VXV_Coordinate* p = &base;
       p != const_cast<VXV_Coordinate&>(base).getGLObj();
       p = p->getParentObj()) {
    if (p == this) {
      throw CoordinateError("setCoordinate");
    }
  }

  //crd_parent->crd_children.remove(this);
  crd_parent->getChildrenObj()->remove(this);
  crd_parent = &base;
  crd_parent->getChildrenObj()->push_back(this);

  crd_offset.x = x;
  crd_offset.y = y;
  crd_offset.t.div16 = t.div16 & 0xffff;

  CRD_EFFECT_CALL("setCoordinate");
  
  return *this;
}


VXV_Coordinate& RC_Coordinate::updateParentOffset(const VXV_Position& offset) {
  return updateParentOffset(offset.x, offset.y, offset.t);
}


VXV_Coordinate& RC_Coordinate::updateParentOffset(int x, int y,
						 const VXV_Direction& t) {
  if (crd_attribute == RC_GL) {
    if (sendGLOffset(x, y, t.div16) < 0) {
      throw ConnectionError("updateParentOffset");
    }
  } else {
    crd_offset.x = x;
    crd_offset.y = y;
    crd_offset.t.div16 = t.div16 & 0xffff;
  }
  
  CRD_EFFECT_CALL("updateParentOffset");
  
  return *this;
}


VXV_Coordinate& RC_Coordinate::updateParentOffset(const VXV_Coordinate& base) {
  return updateParentOffset(base, 0, 0, deg(0));
}


VXV_Coordinate& RC_Coordinate::updateParentOffset(const VXV_Coordinate& base,
						 int x, int y,
						 const VXV_Direction& t) {
  // crd_gl قȂĂAO𓊂
  //if (crd_gl != base.crd_gl) {
  if (crd_gl != const_cast<VXV_Coordinate&>(base).getGLObj()) {
    throw CoordinateError("updateParentOffset");
  }

  // GL, FS ͍Wn̒ւ֎~
  if ((crd_attribute == RC_GL) || (crd_attribute == RC_FS)) {
    throw CoordinateError("updateParentOffset");
  }

  if (&base == this) {
    VXV_Position offset = crd_offset;
    double radian = offset.rad();
    offset.x += (int)(x * cos(radian) - y * sin(radian));
    offset.y += (int)(x * sin(radian) + y * cos(radian));
    offset.t.div16 += t.div16;
    return updateParentOffset(offset);
  }
  
  // eqɒt悤ƂAO𓊂
  for (const VXV_Coordinate* p = &base;
       p != const_cast<VXV_Coordinate&>(base).getGLObj();
       p = const_cast<VXV_Coordinate*>(p)->getParentObj()) {
    if (p == this) {
      throw CoordinateError("updateParentOffset");
    }
  }

  // base Ƃ̑Έʒu߂
  VXV_Position offset =
    const_cast<VXV_Coordinate&>(base).getCoordinateOffset(x, y, t, *this);

  return updateParentOffset(*this, offset);
}


VXV_Coordinate& RC_Coordinate::updateParentOffset(const VXV_Coordinate& base,
						 const VXV_Position& offset) {
  return updateParentOffset(base, offset.x, offset.y, offset.t);
}



VXV_Coordinate& RC_Coordinate::updateRobotPosition(const VXV_Position&
						   position) {
  return updateRobotPosition(position.x, position.y, position.t);
}


VXV_Coordinate& RC_Coordinate::updateRobotPosition(int x, int y,
						  const VXV_Direction& t) {
  // XV𑫂ŁA߂
  VXV_Position gl_offset;
  if (recvGLOffset(&gl_offset.x, &gl_offset.y, &gl_offset.t.div16) < 0) {
    throw ConnectionError("recvGLGl_Offset");
  }

  VXV_Position position = getPosition();
  int x_diff = position.x - x, y_diff = position.y - y;
  double rad_diff = position.rad() - t.rad();

  VXV_Position offset = getGLCoordinateOffset(x_diff, y_diff, rad(rad_diff));
  
  double radian = gl_offset.rad();
  gl_offset.x += (int)(offset.x * cos(radian) - offset.y * sin(radian));
  gl_offset.y += (int)(offset.x * sin(radian) + offset.y * cos(radian));
  gl_offset.t.div16 += offset.t.div16;

  crd_gl->updateParentOffset(gl_offset);
  CRD_EFFECT_CALL("updateRobotPosition");
  
  return *this;
}
