/*
  ֌W
  Satofumi KAMIMURA
  $Id$
*/

#include "RC_Coordinate.h"
#include <math.h>


int RC_Coordinate::getLengthToBody(int x, int y) {
  
  VXV_Position position = getPosition();
  int x_diff = position.x - x;
  int y_diff = position.y - y;
  
  return (int)sqrt((float)((x_diff * x_diff) + (y_diff * y_diff)));
}


int RC_Coordinate::getLengthToLine(int x, int y, const VXV_Direction& t) {

  VXV_Position position = getPosition();
  int diff_x = position.x - x;
  int diff_y = position.y - y;
  double radian = 2.0 * M_PI * t.div16 / 65536.0;

  return (int)rint(diff_x * cos(radian) + diff_y * sin(radian));
}


int RC_Coordinate::getLengthToLine(const VXV_Position& position) {
  return getLengthToLine(position.x, position.y, position.t);
}


VXV_Direction RC_Coordinate::getAngleToDirection(const VXV_Direction& t) {
  
  VXV_Position position = getPosition();
  VXV_Direction diff;
  diff.div16 = getSignedDiv16((position.t.div16 - t.div16) & 0xffff);
  
  return diff;
}


int RC_Coordinate::getStraightVelDiff(int ref_vel) {
  int straight_vel;
  if (recvStraightVel(&straight_vel)) {
    throw ConnectionError("getStraightVelDiff");
  }
  return (straight_vel - ref_vel);
}


VXV_Direction RC_Coordinate::getRotateVelDiff(const VXV_Direction& ref_vel) {

  int rotate_vel;
  if (recvRotateVel(&rotate_vel)) {
    throw ConnectionError("getRotateVelDiff");
  }
  VXV_Direction direction;
  direction.div16 = rotate_vel - ref_vel.div16;
  
  return direction;
}


bool RC_Coordinate::isStable(void) {
  int isStable;
  if (recvStableValue(&isStable)) {
    throw ConnectionError("isStable");
  }
  
  return (isStable) ? true : false;
}
