/*
  ړ
  Satofumi KAMIMURA
  $Id$
*/

#include "RC_Coordinate.h"
#include "packetHandleHost.h"


// LC {bgʒu_ƂWnŏ
/*
#define LC_SET \
  VXV_Position lc_pos = getPosition(); \
  VXV_Coordinate lc = createCoordinate(lc_pos);

#define LC_SET_LAST_MOVE \
  for (int i = 0; i < send_command_size; ++i) { \
    lc.send_command[i] = send_command[i]; \
  }
*/


void RC_Coordinate::followLine(const VXV_Position& position) {
  return followLine(position.x, position.y, position.t);
}


void RC_Coordinate::followLine(int x, int y, const VXV_Direction& t) {

  //LC_SET;
  VXV_Position gl_pos = getGLCoordinateOffset(x, y, t);
  if (sendFollowLine(gl_pos.x, gl_pos.y, gl_pos.t.div16,
		     send_command, &send_command_size) < 0) {
    send_command_size = 0;
    throw ConnectionError("follwLine", x, y, t.deg());
  }
  cmdPos.x = x;
  cmdPos.y = y;
  cmdPos.t.div16 = t.div16;
  //LC_SET_LAST_MOVE;
  
  //return lc;
}


void RC_Coordinate::followCircle(const VXV_Position& position, int radius) {
  return followCircle(position.x, position.y, radius);
}


void RC_Coordinate::followCircle(int x, int y, int radius) {

  //LC_SET;
  int set_radius = (radius != 0) ? radius : 1;
  int run_x = x, run_y = y;
  if (sendFollowCircle(run_x, run_y, set_radius,
		       send_command, &send_command_size) < 0) {
    send_command_size = 0;
    throw ConnectionError("follwCircle", x, y, set_radius);
  }
  cmdPos.x = x;
  cmdPos.y = y;
  //LC_SET_LAST_MOVE;

  //return lc;
}


void RC_Coordinate::followCircleOnTangent(const VXV_Position& position,
					   int radius) {
  return followCircleOnTangent(position.x, position.y, position.t, radius);
}


void RC_Coordinate::followCircleOnTangent(int x, int y,
					  const VXV_Direction& t,
					  int radius) {
  
  int t_add = (radius > 0) ? +(0x10000 >> 2) : -(0x10000 >> 2);
  double radian = (2.0 * M_PI * (t.div16 + t_add) / 65536.0) + M_PI;
  int run_x = x + (int)(abs(radius) * cos(radian));
  int run_y = y + (int)(abs(radius) * sin(radian));
  
  return followCircle(run_x, run_y, radius);
}

void RC_Coordinate::stopToLine(const VXV_Position& position) {
  return stopToLine(position.x, position.y, position.t);
}


void RC_Coordinate::stopToLine(int x, int y, const VXV_Direction& t) {

  //LC_SET;
  VXV_Position gl_pos = getGLCoordinateOffset(x, y, t);
  if (sendStopToLine(gl_pos.x, gl_pos.y, gl_pos.t.div16,
		     send_command, &send_command_size) < 0) {
    send_command_size = 0;
    throw ConnectionError("stopToLine", x, y, t.deg());
  }
  cmdPos.x = x;
  cmdPos.y = y;
  cmdPos.t.div16 = t.div16;
  //LC_SET_LAST_MOVE;
  //return lc;
}


void RC_Coordinate::turnToAngle(const VXV_Direction& t) {

  //LC_SET;
  VXV_Position gl_pos = getGLCoordinateOffset(0, 0, t);
  if (sendTurnToAngle(gl_pos.t.div16, send_command, &send_command_size) < 0) {
    send_command_size = 0;
    throw ConnectionError("turnToAngle", t.deg());
  }
  cmdPos.t.div16 = t.div16;
  //LC_SET_LAST_MOVE;
  //  return lc;
}


void RC_Coordinate::rotateAngle(const VXV_Direction& t) {

  //LC_SET;
  if (sendRotateAngle(t.div16, send_command, &send_command_size) < 0) {
    send_command_size = 0;
    throw ConnectionError("rotateAngle", t.deg());
  }
  //LC_SET_LAST_MOVE;
  //return lc;
}


void RC_Coordinate::spin(const VXV_Direction& v) {

  //LC_SET;
  if (sendSpin(v.div16, send_command, &send_command_size) < 0) {
    send_command_size = 0;
    throw ConnectionError("spin", v.deg());
  }
  //LC_SET_LAST_MOVE;
  //return lc;
}


void RC_Coordinate::stop(void) {
  
  //LC_SET;
  if (sendStop(send_command, &send_command_size) < 0) {
    send_command_size = 0;
    throw ConnectionError("stop");
  }
  //LC_SET_LAST_MOVE;
  //return lc;
}


void RC_Coordinate::lastMoveCommand(void) {

  //LC_SET;
  long last_command_unique_id = getPacketUniqueId(send_command);
  if (sendLastMoveCommand(last_command_unique_id,
			  send_command, send_command_size) < 0) {
    send_command_size = 0;
    throw ConnectionError("stop");
  }
  //LC_SET_LAST_MOVE;
  //return lc;
}
