/*
  s䃉Cu C++ 
  Satofumi KAMIMURA
  $Id$
*/

#include "runCtrl.h"
#include "serialDevice.h"
#include "tcpipDevice.h"
#include "tRunCtrl.h"
#include "packetHandleHost.h"


#if defined _MBCS || defined WIN32
#define WINDOWS
#else
#define LINUX
#endif

/*!
  \brief ڑfoCX̐ݒt@C

  ڑfoCX̖IȎw肪ȂꍇARUN_CONFIG_FILE ݒǂݍ
*/
#ifndef RUN_CONFIG_FILE
#define RUN_CONFIG_FILE "b5conf.txt"
#endif


/*!
  \brief sڑfoCX
*/
#ifndef RUN_AUTO_PORT
# ifdef LINUX
#  define RUN_AUTO_PORT "/dev/ttyS"
# else
#  define RUN_AUTO_PORT "COM"
# endif
#endif


enum { NO_FILE_ERROR = -2 };


/*!
  \brief IuWFNg̐

  ݑ̃IuWFNg𐶐
*/
RunCtrl::RunCtrl(void)
  : error_message("connection device is not specified"),
    error_device(""), error_baudrate(0),
    active_con(NULL), GL(*this) {
  con = &active_con;
  run = new runCtrl_t;
  run->version = 0;
  node = new nodeInfo_t;
  initNodeInfo(node);
  runParam = new runCtrlParameter_t;
  initRunParam(runParam);
  registerStructInfo(node, (unsigned char *)run, RUN_CTRL_TARGET_ID);
  unique_id = new long;
  *unique_id = 0;
  crdEffectMode = new bool;
  *crdEffectMode = false;
  cmdPos.x = 0;
  cmdPos.y = 0;
  cmdPos.t.div16 = 0;

  crd_attribute = RC_GL;
  FS = *this;
  FS.crd_attribute = RC_FS;
  FS.crd_parent = this;
}


RunCtrl::~RunCtrl(void) {
  if (con) {
    delete active_con;
    active_con = NULL;
  }
}


/*!
  \brief G[bZ[WԂ

  \return error_message G[bZ[Wւ̃|C^

  gp
  \code
  // RUN ̏
  RunCtrl robot = RunCtrl();
  if (robot.connect(argc, argv) < 0) {
    printf("RunCtrl: %s\n", robot.getError());
    exit(1);
  }
  \endcode
*/
const char *RunCtrl::what(void) const throw() {
  int message_length = 11 + strlen(error_device) + strlen(error_message) + 5;
  if ((message_length > ERROR_MESSAGE_BUFFER_SIZE) ||
      (error_device[0] == '\0')) {
    return error_message;
  }
  sprintf((char *)error_message_buffer, "%s, %ld : %s",
	  error_device, error_baudrate, error_message);
  return (const char *)error_message_buffer;
}


/*!
  \brief G[bZ[WԂ

  \return error_message G[bZ[Wւ̃|C^
  \attention Ȃׂ what() gĉ
*/
const char *RunCtrl::getError(void) const throw() {
  return what();
}


// sp̃p[^
void RunCtrl::initRunParam(runCtrlParameter_t *runParam) {
  runParam->straight_ref_vel = RUN::STRAIGHT_MM_VEL;
  runParam->straight_ref_acc = RUN::STRAIGHT_MM_ACC;
  runParam->rotate_ref_vel = RUN::ROTATE_DIV16_VEL;
  runParam->rotate_ref_acc = RUN::ROTATE_DIV16_ACC;
  runParam->follow_r = RUN::FOLLOW_RADIUS_MM;
}


// o[W`FbNsAT[{
long RunCtrl::checkVersion(void) {
  long target_version;
  if (recvVersion(&target_version) < 0) {
    error_message = "Connection fail: recvVersion";
    return -1;
  }
  
  if (target_version != VXV_NUM_VERSION) {
    fprintf(stderr,
	    "warnning: RunCtrl version mismatch between PC(%d) and SH2(%ld)\n",
	    VXV_NUM_VERSION, target_version);
    error_message = "RunCtrl version mismatch between host and target";
  }
  if (sendPositionInit() < 0) {
    error_message = "Connection fail: sendPositionInit";
  }
  stop();
  
  return 0;
}


/*!
  \brief ZTւ̐ڑs

  \param deviceName [i] foCXւ̃|C^
  \param baudrate [i] {[[g
  \retval 0 I
  \retval ߂l < 0 G[
*/
int RunCtrl::connect(const char *deviceName, long baudrate) {
  if (*con) {
    delete *con;
  }
  *con = new SerialDevice();
  int ret_value = (*con)->connect(deviceName, baudrate);
  
  int error_device_buffer_size = strlen(deviceName);
  if (error_device_buffer_size > ERROR_MESSAGE_BUFFER_SIZE-1) {
    error_device_buffer_size = ERROR_MESSAGE_BUFFER_SIZE-1;
  }
  strncpy(error_device_buffer, deviceName, error_device_buffer_size);
  error_device_buffer[error_device_buffer_size] = '\0';
  error_device = error_device_buffer;
  error_baudrate = baudrate;

  if (ret_value < 0) {
    if (ret_value == SCI::DEVICE_OPEN_ERROR) {
      error_message = "specified device is invalid";
      
    } else if (ret_value == SCI::BAUDRATE_ADJUST_ERROR) {
      error_message = "adjust baudrate is fail.";
      
    } else {
      error_message = "unknown error";
    }
  } else {
    error_message = "success";
    ret_value = checkVersion();
  }
  return ret_value;
}


/*!
  \brief R}hCw̐ڑfoCXɐڑ
  
  vOs̈Ŏw肳ꂽfoCXւ̐ڑ݂BڑɎsꍇA RunCtrl(void) ̕]s

  Ŏwł鍀ڂ͈ȉ̒ʂ
  \li --run_port=<foCX>
  \li --run_baudrate=<{[[g>

  --run_port ɂfoCX "auto" ̏ꍇARUN_AUTO_PORT ̒TfoCXԍ 20  0 Ɍčs

  \param argc [i] main() argc
  \param argv [i] main() argv
  \retval 0 I
  \retval ߂l < 0 G[
*/
int RunCtrl::connect(int argc, char *argv[]) {
  long baudrate = RUN::BAUDRATE;
  char *deviceName = NULL;

  // -s, --simulator ΁ADIɏ
  for (int i = 0; i < argc; ++i) {
    if (!strncmp("--run_port=", argv[i], 11) && (strlen(argv[i]) > 11)) {
      deviceName = &argv[i][11];
      
    } else if (!strncmp("--run_baudrate=", argv[i], 15) &&
	       (strlen(argv[i]) > 15)) {
      baudrate = atoi(&argv[i][15]);
      
    } else if (!strcmp("-s", argv[i]) || !strcmp("--simulator", argv[i])) {
      return connectSimulator();
    }
  }

  if (deviceName &&
      (!strcmp("auto", deviceName) || !strcmp("AUTO", deviceName))) {
    int ret_value;
#ifdef _MBCS
    // COM ̈ꗗ擾Aڑ
    int id[20];
    int ids = SerialDevice::getComId(id, 20);
    for (int i = 0; i < ids; ++i) {
      char checkDevice[16] = { '\0','\0','\0','\0','\0','\0','\0','\0',
			       '\0','\0','\0','\0','\0','\0','\0','\0' };
      sprintf(checkDevice, RUN_AUTO_PORT "%d", id[i]);
      ret_value = connect(checkDevice, baudrate);
      if (ret_value >= 0) {
	break;
      }
    }
#else
    for (int id = 20; id >= 0; --id) {
      char checkDevice[16] = { '\0','\0','\0','\0','\0','\0','\0','\0',
			       '\0','\0','\0','\0','\0','\0','\0','\0' };
      sprintf(checkDevice, RUN_AUTO_PORT "%d", id);
      ret_value = connect(checkDevice, baudrate);
      if (ret_value >= 0) {
	break;
      }
    }
#endif
    if (ret_value < 0) {
      error_device = RUN_AUTO_PORT;
      error_baudrate = baudrate;
      error_message = "auto dvice detection is fail";
    } else {
      error_message = "success";
    }
    return ret_value;
  }

  if (!deviceName) {
    return connect();
  }
  return connect(deviceName, baudrate);
}



/*!
  \brief ZTւ̐ڑs

  ڑfoCXA
  \li vOsĂfBNg RUN_CONFIG_FILE t@C
  \li $HOME fBNg RUN__CONFIG_FILE t@C
  \li ϐ RUN_PORT
  
  ̏ɒTAŏɌfoCXɐڑ݂BڑɎsꍇATŒfăG[Ԃ

  \retval 0 I
  \retval < 0 G[
*/
int RunCtrl::connect(void) {

  int ret_value = searchConfigFile(".");
  if ((ret_value >= 0) || (ret_value != NO_FILE_ERROR)) {
    return ret_value;
  }

  char *home = getenv("HOME");
  if (home) {
    ret_value = searchConfigFile(home);
    // !!! free Kv͂̂H
    if ((ret_value >= 0) || (ret_value != NO_FILE_ERROR)) {
      return ret_value;
    }
  }

  long baudrate = RUN::BAUDRATE;
  char *deviceName = NULL;
  char *baudrate_str = NULL;
  if ((baudrate_str = getenv("RUN_BAUDRATE"))) {
    baudrate = atoi(baudrate_str);
  }
  
  deviceName = getenv("RUN_PORT");
  if (deviceName) {
    return connect(deviceName, baudrate);
  }
  return -1;
}


int RunCtrl::searchConfigFile(const char *path) {
  int path_length = strlen(path);
  int file_length = strlen(RUN_CONFIG_FILE);
  char *file_path = new char[path_length + 1 + file_length + 1];
  strcpy(file_path, path);
  strcpy(&file_path[path_length], "/");
  strcpy(&file_path[path_length +1], RUN_CONFIG_FILE);
  file_path[path_length + 1 + file_length] = '\0';

  long baudrate = RUN::BAUDRATE;
  char *baudrate_str;
  char *deviceName;
  if ((baudrate_str = get_keyword(file_path, "run_baudrate"))) {
    baudrate = atoi(baudrate_str);
    free(baudrate_str);
  }
  deviceName = get_keyword(file_path, "run_port");
  delete file_path;
  if (deviceName) {
    int ret_value = connect(deviceName, baudrate);
    free(deviceName);
    return ret_value;
  }
  return NO_FILE_ERROR;
}



int RunCtrl::connectSimulator(void) {
  if (*con) {
    (*con)->disconnect();
  }
  *con = new TcpipDevice();
  int ret_value = (*con)->connect("localhost", SIMULATOR_T_RUN_CTRL_PORT);
  if (ret_value < 0) {
    error_device = "TCP/IP";
    error_baudrate = SIMULATOR_T_RUN_CTRL_PORT;
    error_message = "connection fail to simulator";
  } else {
    error_message = "success";
    ret_value = checkVersion();
  }
  return ret_value;
}


/*!
  \brief ڑؒf

  \retval Ȃ
*/
void RunCtrl::disconnect(void) {
  (*con)->disconnect();
}


/*!
  \brief ڑĂ邩Ԃ

  \retval ڑĂ邩
*/
bool RunCtrl::is_connect(void) {
  return *con && (*con)->is_connect();
}


/*!
  \brief T[{

  \param on [i] T[{邩
  \retval *this;
*/
RunCtrl& RunCtrl::servoCtrl(bool on) {
  
  if (sendServoCtrl(on) < 0) {
    throw ConnectionError("sendServoCtrl", on);
  }
  
  return *this;
}
