#ifndef VELOCITY_CTRL_H
#define VELOCITY_CTRL_H

/*
  x
  Satofumi KAMIMURA
  $Id$
*/

#include "velocityInfo.h"


enum {
  // 䂪ԂɂȂǂ
  CONTROL_UNSTABLE = 0,
  CONTROL_STABLE = 1,
};


typedef struct {
  int ref_vel;
  int current_vel;
  int acc;
  int current_pos;
  int circle_r;
  int stable;
} velocityCtrlInfo_t;


#include "cpp_extern_macro.h"
BEGIN_C_DECLS;

extern void getFirstHoldVelocity(velocityCtrlInfo_t *velCtrl, int vel);
extern int holdVelocityCtrl(velocityCtrlInfo_t *velCtrl);
extern int holdPositionCtrl(velocityCtrlInfo_t *velCtrl);
extern int followLineCtrl(velocityCtrlInfo_t *velCtrl, int follow_r,
			  velocityInfo_t *velInfo, int run_crd_div16);
extern int followCircleCtrl(velocityCtrlInfo_t *velCtrl, int follow_r,
			    int x, int y, velocityInfo_t *velInfo,
			    int run_crd_div16);

END_C_DECLS;
#endif /* !VELOCITY_CTRL_H */
