/*
  pPbg̃^[Qbg
  Satofumi KAMIMURA
  $Id$
*/

#include "packetHandleTarget.h"
#include "transferCtrl.h"
#include "nodeAccess.h"
#include "tRunCtrl.h"

#define CON_RECV(X, Y, Z) trans_recv(X, Y, Z)
#define CON_RECV2(X, Y) trans_recv(X, Y)
#define CON_SEND(X, Y) trans_send(X, Y)
#define CON_COPY(X, Y) trans_copy(X, Y)
#define CON_SIZE() trans_size()


enum { RECV_PACKET_SIZE = 512 };

int packetRecvHandler(runCtrl_t *run)
{
  enum { WAIT_PACKET_HEADER, HEADER_RECEIVED, PACKET_RECEIVED };
  static int state = WAIT_PACKET_HEADER;
  static unsigned char recv_buffer[RECV_PACKET_SIZE];
  static int packet_length = -1;
  int ret_value = 0;
  int left_length;
  long packet_unique_id = -1;
  int type;

  switch (state) {
    
  case WAIT_PACKET_HEADER:
    // ɁAMQȏ゠ƂA"V" ǂ̊mFs
    if (CON_SIZE() >= 2) {
      unsigned char command[2];
      CON_COPY(command, 2);
      if ((command[0] == 'V') &&
	  ((command[1] == '\n') || (command[1] == '\r'))) {
	// o[WԂ
	CON_RECV2(command, 2);
	CON_SEND((unsigned char *)V_COMMAND_REPLY, sizeof(V_COMMAND_REPLY));
      }
    }
    if (trans_size() >= NODE_ACCESS_PACKET_HEADER_SIZE) {
      CON_RECV2(recv_buffer, NODE_ACCESS_PACKET_HEADER_SIZE);
      if (checkHeaderFormat(recv_buffer) < 0) {
	// pPbg̐擪TAȑO̎Mf[^j
	// !!! 
      }
      packet_length = getPacketLength((unsigned char *)recv_buffer);
      if (packet_length < 0) {
	// wb_T
	// !!! 
      }
      packet_unique_id = getPacketUniqueId((unsigned char *)recv_buffer);
      state = HEADER_RECEIVED;
    } else {
      break;
    }
    
  case HEADER_RECEIVED:
    left_length = packet_length - NODE_ACCESS_PACKET_HEADER_SIZE;
    if (CON_SIZE() < left_length) {
      break;
    }
    CON_RECV2(&recv_buffer[NODE_ACCESS_PACKET_HEADER_SIZE], left_length);
    if (checkPacketFormat(recv_buffer, packet_length) < 0) {
      // pPbgG[̏ᖡׂ
      // !!!
      state = WAIT_PACKET_HEADER;
      return ret_value;
    }
    state = PACKET_RECEIVED;
    
  case PACKET_RECEIVED:
    type = getPacketType((unsigned char *)recv_buffer);
    switch (type) {
	
    case PACKET_WRITE_REQUEST:
      // Mf[^ŁAԂ
      writeFromPacketData((unsigned char *)recv_buffer, (unsigned char *)run);
      packet_length = createWriteResponsePacket((unsigned char *)recv_buffer,
						(unsigned char *)run);
      CON_SEND(recv_buffer, packet_length);
      ret_value = 1;
      break;
	
    case PACKET_READ_REQUEST:
      // MpPbg݃pPbgɕύXA𑗂Ԃ
      packet_length =
	createReadResponsePacket((unsigned char *)recv_buffer,
				 (unsigned char *)run);
      CON_SEND(recv_buffer, packet_length);
      ret_value = 1;
      break;
    }
    state = WAIT_PACKET_HEADER;
    break;
  }

  return ret_value;
}
