#ifndef SERIAL_DEVICE_C_H
#define SERIAL_DEVICE_C_H

/*
  VA
  Satofumi KAMIMURA
  $Id$
*/

enum {
  SCI_TIMEOUT = 105,		/*!< M̃^CAEg */
  DEVICE_OPEN_ERROR = -2,	/*!< foCXoG[ */
  BAUDRATE_ADJUST_ERROR = -3,	/*!< {[[gݒG[ */
  NO_CONNECT = -4,		/*!< ڑG[ */
};


#include "cpp_extern_macro.h"
BEGIN_C_DECLS;

extern int serial_open(const char *devName, long baudrate);
extern void serial_close(void);
extern int serial_is_connect(void);
extern int serial_recv(unsigned char *data, int size, int timeout);
extern int serial_send(const unsigned char *data, int length);
extern void serial_flush(void);
extern int serial_set_baudrate(long baudrate);

END_C_DECLS;
#endif /* !SERIAL_DEVICE_C_H */
