/*
  kzd@ ZT URG-X002S ̃f[^擾NX
  Satofumi KAMIMURA
  $Id$
*/

#include "config.h"
#include "urgAutoCapture.h"
#include <stdlib.h>
#ifdef HAVE_LIBSDL
#include <SDL.h>
#include <SDL_thread.h>
#endif


#ifdef HAVE_LIBSDL
int capture_thread(void *data) {
  URGAutoCapture::uac_captureData_t *q
    = (URGAutoCapture::uac_captureData_t *)data;
  URGAutoCapture *p = (URGAutoCapture *)q->funcs;
  URGAutoCapture::uac_autoCapture_t *auto_capture = q->auto_capture;

  while (1) {
    SDL_mutexP((SDL_mutex*)auto_capture->mut);
    auto_capture->receiving_index = ++(auto_capture->receiving_index) & 0x1;
    int index = auto_capture->receiving_index;
    ++(p->capture_times);
    SDL_mutexV((SDL_mutex*)auto_capture->mut);

    // L R}hƂ̔rۏ
    SDL_SemWait((SDL_sem*)auto_capture->stop_sem);

    auto_capture->buffer[index].ret =
      p->URGManualCapture::capture(auto_capture->buffer[index].data,
				   auto_capture->order_from,
				   auto_capture->order_to,
				   auto_capture->order_group);
    
    auto_capture->buffer[index].attribute =
      (auto_capture->buffer[index].ret > 0) ?
      URGAutoCapture::RECEIVED : URGAutoCapture::NO_DATA;
    auto_capture->buffer[index].from = auto_capture->order_from;
    auto_capture->buffer[index].to = auto_capture->order_to;
    auto_capture->buffer[index].group = auto_capture->order_group;

    auto_capture->buffer[1-index].attribute = URGAutoCapture::RECEIVING;
    SDL_SemPost((SDL_sem*)auto_capture->stop_sem);
    
    // Xbh̏IǗ
    if (SDL_SemTryWait((SDL_sem*)auto_capture->quit_sem) != 0) {
      break;
    }
    SDL_SemPost((SDL_sem*)auto_capture->quit_sem);
  }
  return 0;
}


void URGAutoCapture::initCaptureData(void) {
  auto_capture.stop_sem = SDL_CreateSemaphore(1);
  auto_capture.quit_sem = SDL_CreateSemaphore(1);
  auto_capture.mut = SDL_CreateMutex();
  auto_capture.receiving_index = 0;

  for (int i = 0; i < 2; ++i) {
    auto_capture.buffer[i].attribute = URGAutoCapture::NO_DATA;
  }
}


void URGAutoCapture::destroyCaptureData(void) {
  SDL_SemWait((SDL_sem*)auto_capture.quit_sem);
  SDL_WaitThread((SDL_Thread*)thread, NULL);

  SDL_DestroyMutex((SDL_mutex*)auto_capture.mut);
  SDL_DestroySemaphore((SDL_sem*)auto_capture.quit_sem);
  SDL_DestroySemaphore((SDL_sem*)auto_capture.stop_sem);
}
#endif


int URGAutoCapture::get_captureTimes(void) {
#ifdef HAVE_LIBSDL
  int ret_value;
  SDL_mutexP((SDL_mutex*)auto_capture.mut);
  ret_value = capture_times;
  SDL_mutexV((SDL_mutex*)auto_capture.mut);

  return ret_value;
#else
  return 0;
#endif
}


URGAutoCapture::URGAutoCapture(void)
#ifdef HAVE_LIBSDL
  : thread(NULL), capture_times(0)
#endif
{
#ifdef HAVE_LIBSDL
  initCaptureData();
#endif
}


URGAutoCapture::~URGAutoCapture(void) {
#ifdef HAVE_LIBSDL
  if (thread) {
    destroyCaptureData();
  }
#endif
}


int URGAutoCapture::capture(long *data, int from, int to, int group) {
#ifdef HAVE_LIBSDL
  if (thread == NULL) {
    for (int i = 0; i < 2; ++i) {
      auto_capture.order_from = from;
      auto_capture.order_to = to;
      auto_capture.order_group = group;
    }

    uac_captureData_t thread_args;
    thread_args.funcs = this;
    thread_args.auto_capture = &auto_capture;
    thread = SDL_CreateThread(capture_thread, &thread_args);
  }

  while (1) {
    SDL_mutexP((SDL_mutex*)auto_capture.mut);
    int index = 1 - auto_capture.receiving_index;
    auto_capture.order_from = from;
    auto_capture.order_to = to;
    auto_capture.order_group = group;
    SDL_mutexV((SDL_mutex*)auto_capture.mut);
    
    int ret;
    if ((auto_capture.buffer[index].from == from) &&
	(auto_capture.buffer[index].to == to) &&
	(auto_capture.buffer[index].group == group) &&
	(auto_capture.buffer[index].attribute == URGAutoCapture::RECEIVED)) {
      for (int i = 0; i < URG::DATA_SIZE; ++i) {
	data[i] = auto_capture.buffer[index].data[i];
      }
      ret = auto_capture.buffer[index].ret;
      return ret;
    }
  }
#else
  return -1;
#endif
}


int URGAutoCapture::capture(long *data, int group) {
  return capture(data, 0, URG::DATA_SIZE, group);

}

void URGAutoCapture::laser(bool on) {
#ifdef HAVE_LIBSDL
  SDL_SemTryWait((SDL_sem*)auto_capture.stop_sem);
  URGManualCapture::laser(on);
  SDL_SemPost((SDL_sem*)auto_capture.stop_sem);
#endif
}


void URGAutoCapture::setHandstand(bool on) {
  URGManualCapture::setHandstand(on);
}
