/*
  kzd@ ZT URG-X002S ̂RcNX
  Satofumi KAMIMURA
  $Id$
*/

#include "urgCtrl3D.h"


void URGCtrl3D::clearDirection(VXV_Direction& direction) {
  direction.div16 = 0;
}


URGCtrl3D::URGCtrl3D(void) {
  clearDirection(base_rx);
  clearDirection(base_ry);
  clearDirection(base_rz);

  clearDirection(sensor_offset_rx);
  clearDirection(sensor_offset_ry);
  clearDirection(sensor_offset_rz);
}


URGCtrl3D::~URGCtrl3D(void) {
  disconnect();
}


/*!
  \brief ZT[➑̂̑Έʒu

  ➑̒S̑ΈʒuApxݒ肷

  \param x [i] Έʒu X [mm]
  \param y [i] Έʒu Y [mm]
  \param z [i] Έʒu Z [mm]
  \param dx [i] Ίpx X ܂ [VXV_Direction]
  \param dy [i] Ίpx Y ܂ [VXV_Direction]
  \param dz [i] Ίpx Z ܂ [VXV_Direction]
*/
URGCtrl3D& URGCtrl3D::setURGOffset(int x, int y, int z,
				   VXV_Direction dx,
				   VXV_Direction dy,
				   VXV_Direction dz) {
  sensor_offset.x = x;
  sensor_offset.y = y;
  sensor_offset.z = z;

  sensor_offset_rx.div16 = dx.div16;
  sensor_offset_ry.div16 = dy.div16;
  sensor_offset_rz.div16 = dz.div16;

  return *this;
}


/*!
  \brief ZTf[^擾

  URGCtrl::capture() QƂ̂ƁB

  \param from [i] Jnindex
  \param to [i] Iindex
  \param group [i] O[sOsf[^
  \retval *this
*/
URGCtrl3D& URGCtrl3D::capture(int from, int to, int group) {
  URGCtrl::capture(from, to, group);
  return *this;
}


/*!
  \brief ZTf[^擾

  URGCtrl::capture() QƂ̂ƁB
  
  \param group [i] O[sOsf[^
  \retval *this
*/
URGCtrl3D& URGCtrl3D::capture(int group) {
  return capture(0, URG::DATA_SIZE-1, group);
}


/*!
  \brief ZT̎OWʒuݒ

  URGCtrl3D::convert() ł́AŐݒ肵WnɊÂđ_̍WvZB

  \param x [i] XWl [mm]
  \param y [i] YWl [mm]
  \param z [i] ZWl [mm]
  \param dx [i] X܂̊px [VXV_Direction]
  \param dy [i] Y܂̊px [VXV_Direction]
  \param dz [i] Z܂̊px [VXV_Direction]
  \retval *this
*/
URGCtrl3D& URGCtrl3D::setPosition(int x, int y, int z,
				  VXV_Direction dx,
				  VXV_Direction dy,
				  VXV_Direction dz) {
  base.x = x;
  base.y = y;
  base_z = z;
  
  dx.div16 = 0;
  dy.div16 = 0;
  dz.div16 = 0;
  
  return *this;
}


/*!
  \brief ZT̎OWʒuݒ

  URGCtrl3D::convert() ł́AŐݒ肵WnɊÂđ_̍WvZB

  \param x [i] XWl [mm]
  \param y [i] YWl [mm]
  \param t [i] Z܂̊px [VXV_Direction]
  \retval *this
*/
URGCtrl3D& URGCtrl3D::setPosition(int x, int y, VXV_Direction t) {

  base.x = x;
  base.y = y;

  base_rz.div16 = t.div16;
  
  return *this;
}


void URGCtrl3D::setPointVector(VXV_Grid3D *point, int x, int y) {
  point->x = x;
  point->y = y;
  point->z = 0;
}


void URGCtrl3D::createConvertVector4D(int x, int y, int z,
				      int rx, int ry, int rz) {
  double dx = 2.0 * M_PI * rx / 360.0;
  double dy = 2.0 * M_PI * ry / 360.0;
  double dz = 2.0 * M_PI * rz / 360.0;
  
  conv.a11 = cos(dy) * cos(dz);
  conv.a21 = -cos(dx)*sin(dz) + sin(dx)*sin(dy)*cos(dz);
  conv.a31 = cos(dx)*sin(dy)*cos(dz) + sin(dx)*sin(dz);
  conv.a41 = x;

  conv.a12 = cos(dy)*sin(dz);
  conv.a22 = cos(dx)*cos(dz) + sin(dx)*sin(dy)*sin(dz);
  conv.a32 = cos(dx)*sin(dy)*sin(dz) - sin(dx)*cos(dz);
  conv.a42 = y;

  conv.a13 = -sin(dy);
  conv.a23 = sin(dx)*cos(dy);
  conv.a33 = cos(dx)*cos(dy);
  conv.a43 = z;
}


void URGCtrl3D::converGrid3D(VXV_Grid3D *a, VXV_Grid3D *b) {
  a->x = (int)(b->x * conv.a11 + b->y * conv.a21 + b->z * conv.a31) + conv.a41;
  a->y = (int)(b->x * conv.a12 + b->y * conv.a22 + b->z * conv.a32) + conv.a42;
  a->z = (int)(b->x * conv.a13 + b->y * conv.a23 + b->z * conv.a33) + conv.a43;
}


/*!
  \brief 擾f[^_̈ʒuOWɕϊ

  URGCtrl3D::length[] ̃f[^Ή URGCtrl3d::grid3d[] ɕϊقALȃf[^ URGCtrl3D::grid3d_vector Ɋi[B

  \param Ȃ
  \retval *this
*/
URGCtrl3D& URGCtrl3D::convert3D(void) {
  grid3D_vector.clear();

  if (!is_captured) {
    for (int i = 0; i < URG::DATA_SIZE; ++i) {
      grid3D[i].x = -1;
      grid3D[i].y = -1;
      grid3D[i].z = -1;
    }
    return *this;
  }

  // ZTf[^ZT𒆐SƂ X, Y WnɓWJ
  VXV_Position stored_sensor_offset = URGCtrl2D::sensor_offset;
  VXV_Position stored_base = URGCtrl2D::base;
  URGCtrl2D::setURGOffset(0, 0, deg(0));
  URGCtrl2D::convert2D(0, 0, deg(0));
  URGCtrl2D::sensor_offset = stored_sensor_offset;
  URGCtrl2D::base = stored_base;

  // ZT̈ʒuvZ
  VXV_Grid3D sensor_position;
  createConvertVector4D(URGCtrl3D::base.x, URGCtrl3D::base.y, base_z,
			base_rx.deg(), base_ry.deg(), base_rz.deg());
  converGrid3D(&sensor_position, &sensor_offset);
  
  // ʒu̕ϊxNgvZ
  VXV_Grid3D point, position;
  createConvertVector4D(sensor_position.x,
			sensor_position.y,
			sensor_position.z,
			base_rx.deg() + sensor_offset_rx.deg(),
			base_ry.deg() + sensor_offset_ry.deg(),
			base_rz.deg() + sensor_offset_rz.deg());
  for (int i = 0; i < URG::DATA_SIZE; ++i) {
    if ((length[i] < 20) ||
	(mode && !mode->isLongRangeMode() &&
	 (length[i] >= URGCtrl::mesurable_max))) {
      grid3D[i].x = -1;
      grid3D[i].y = -1;
      grid3D[i].z = -1;
      continue;
    }

    // ]Asړ̌vZ
    setPointVector(&point, grid2D[i].x, grid2D[i].y);
    converGrid3D(&position, &point);

    grid3D[i].x = position.x;
    grid3D[i].y = position.y;
    grid3D[i].z = position.z;
    
    grid3D_vector.push_back(position);
  }
  URGCtrl2D::convert2D();
  
  return *this;
}


/*!
  \brief 擾f[^_̈ʒuOWɕϊ

  URGCtrl3D::length[] ̃f[^Ή URGCtrl3d::grid3d[] ɕϊقALȃf[^ URGCtrl3D::grid3d_vector Ɋi[Bϊ̍ۂɁÃ݂ZTʒuXVB

  \param x [i] XWl [mm]
  \param y [i] YWl [mm]
  \param z [i] ZWl [mm]
  \param dx [i] X܂̊px [VXV_Direction]
  \param dy [i] Y܂̊px [VXV_Direction]
  \param dz [i] Z܂̊px [VXV_Direction]
  \retval *this
*/
URGCtrl3D& URGCtrl3D::convert3D(int x, int y, int z,
				VXV_Direction dx,
				VXV_Direction dy,
				VXV_Direction dz) {
  return setPosition(x, y, z, dx, dy, dz).convert3D();
}


/*!
  \brief 擾f[^_̈ʒuOWɕϊ

  URGCtrl3D::length[] ̃f[^Ή URGCtrl3d::grid3d[] ɕϊقALȃf[^ URGCtrl3D::grid3d_vector Ɋi[Bϊ̍ۂɁÃ݂ZTʒuXVB

  \param x [i] XWl [mm]
  \param y [i] YWl [mm]
  \param t [i] Z܂̊px [VXV_Direction]
  \retval *this;
*/
URGCtrl3D& URGCtrl3D::convert3D(int x, int y, VXV_Direction t) {
  return setPosition(x, y, t).convert3D();
}


/*!
  \brief 擾f[^_̈ʒuOWɕϊ

  URGCtrl3D::length[] ̃f[^Ή URGCtrl3d::grid3d[] ɕϊقALȃf[^ URGCtrl3D::grid3d_vector Ɋi[Bϊ̍ۂɁÃ݂ZTʒuXVB

  \param position [i] ʒu [VXV_Position]
  \retval *this
*/
URGCtrl3D& URGCtrl3D::convert3D(VXV_Position& position) {
  return setPosition(position.x, position.y, rad(position.rad())).convert3D();
}
