/*
  kzd@ ZT URG-X002S ̃f[^擾NX
  Satofumi KAMIMURA
  $Id$
*/

#include "urgManualCapture.h"
#include "serialDevice.h"
#include "tcpipDevice.h"
#include <stdio.h>
#include <string.h>


URGManualCapture::URGManualCapture(void)
  : capture_times(0),
    product_version(URG_TYPE_UNKNOWN), protocol_version(URG_TYPE_UNKNOWN),
    data_byte_size(2), isHandstand(false), serialId("unknown") {
  con = new SerialDevice();
}


URGManualCapture::~URGManualCapture(void) {
  delete con;
}



int URGManualCapture::checkProtocolVersion(ConnectionDevice* con) {
  char expected_message[] = "PROT:00003,(SCIP";
  char message_buffer[sizeof(expected_message)-1];
  int type = URG_TYPE_UNKNOWN;
  if (con->recv(message_buffer, sizeof(expected_message)-1,
		SCI::TIMEOUT) >= (int)sizeof(expected_message)-1) {
    int j;
    for (j = 0; j < (int)sizeof(expected_message)-1; ++j) {
      if (expected_message[j] != message_buffer[j]) {
	break;
      }
    }
    if (j < (int)sizeof(expected_message)-1) {
      return type;
    }
    int filled = 0;
    for (int i = 0; i < 4; ++i) {
      char ch;
      con->recv(&ch, 1, SCI::TIMEOUT);
      if (ch != ' ') {
	message_buffer[filled++] = ch;
      }
    }
    // 1.0, 1.0z ̎ʂs
    if (!strncmp("1.0z", message_buffer, 4)) {
      type = URG_PROT_1_0Z;
    } else if (!strncmp("1.0)", message_buffer, 4)) {
      type = URG_PROT_1_0;
    }
  }

  return type;
}


void URGManualCapture::skipToLF(ConnectionDevice* con) {
  char ch;
  while (con->recv(&ch, 1, SCI::TIMEOUT) > 0) {
    if (isLF(ch)) {
      break;
    }
  }
}


int URGManualCapture::connect(const char *deviceName, long baudrate) {
  long expected_baudrate[] = { 19200, 115200, 57600 };

  if (con->connect(deviceName, baudrate) < 0) {
    return URG::DEVICE_OPEN_ERROR;
  }
  
  char message[15];
  sprintf(message, "S%06ldXXXXXXX\r", baudrate);
  for (int i = 0; i < 3; ++i) {
    char recv_buffer[18];
    con->setBaudrate(expected_baudrate[i]);
    con->flush();

    // 'V' R}hɂo[W̊mF
    con->send("V\r", 2);
    con->send(message, 15);

    // ^CAEgĎPMAs 3 ǂݔ΂
    int lf_count = 0;
    char ch;
    int ret;
    while ((ret = con->recv(&ch, 1, SCI::TIMEOUT)) > 0) {
      if (isLF(ch)) {
	if (++lf_count >= 3) {
	  break;
	}
      }
    }
    bool was_timeout = (ret == 0) ? true : false;
    bool product_check = false;
    char version_ch;
    if (lf_count >= 3) {
      // PRODs̃bZ[Wǂݍ ("PROD:SOKUIKI Sensor URG-X00" 2, 3)
      char expected_message[] = "PROD:SOKUIKI Sensor URG-X00";
      char message_buffer[sizeof(expected_message)-1];
      if (con->recv(message_buffer, sizeof(expected_message)-1,
		    SCI::TIMEOUT) >= (int)sizeof(expected_message)-1) {
	int j;
	for (j = 0; j < (int)sizeof(expected_message)-1; ++j) {
	  if (expected_message[j] != message_buffer[j]) {
	    break;
	  }
	}
	if (j >= (int)sizeof(expected_message)-1) {
	  if ((con->recv(&version_ch, 1) > 0) && (con->recv(&ch, 1) > 0) &&
	      isLF(ch)) {
	    product_check = true;
	  }
	  if (version_ch == '2') {
	    product_version = URG_PROD_X_002;
	  } else if (version_ch == '3') {
	    product_version = URG_PROD_X_003;
	    skipToLF(con);
	    protocol_version = checkProtocolVersion(con);
	    data_byte_size = (protocol_version == URG_PROT_1_0Z) ? 3 : 2;
	  }
	}
      }
    }

    // SERIs̔o
    // !!! ̋@\̃RgAEgOƁAZTFȂȂ
    
    con->recv(serialId_buffer, 1, SCI::TIMEOUT);
    char pre_ch = '\0';
    for (int k = 0; k < URG_SERI_BUFMAX; ++k) {
      if (con->recv(&pre_ch, 1, SCI::TIMEOUT) > 0) {
	serialId_buffer[k] = pre_ch;
	if (isLF(serialId_buffer[k]) &&
	    (!strncmp(serialId_buffer, "SERI:", 5))) {
	  serialId_buffer[k] = '\0';
	  serialId = &serialId_buffer[5];
	  break;
	}
	if (isLF(pre_ch)) {
	// !!! AR[hI
	break;
	}
      } else {
	// !!! ȁI
	break;
      }
    }

    while ((!was_timeout) && (con->recv(&ch, 1, SCI::TIMEOUT)) > 0) {
      if (isLF(ch) && isLF(pre_ch)) {
	break;
      }
      pre_ch = ch;
    }
     
    if (product_check == false) {
      continue;
    }
    
    if (con->recv(recv_buffer, 18, SCI::TIMEOUT) >= 15) {
      if (recv_buffer[15] == '0') {
	con->setBaudrate(baudrate);
	con->flush();
	if (!product_check) {
	  return URG::PRODUCT_MISMATCH_ERROR;
	}
	return 0;
      }
    }
  }

  con->disconnect();
  return URG::BAUDRATE_ADJUST_ERROR;
}


int URGManualCapture::connectSimulator(const char *host, int port) {
  delete con;
  con = new TcpipDevice();
  return con->connect(host, port);
}


void URGManualCapture::disconnect(void) {
  con->disconnect();
}


bool URGManualCapture::is_connect(void) {
  return con->is_connect();
}


int URGManualCapture::get_captureTimes(void) {
  return capture_times;
}


void URGManualCapture::swap(int *a, int *b) {
  int tmp = *a;
  *a = *b;
  *b = tmp;
}


bool URGManualCapture::isLF(char ch) {
  if ((ch == '\r') || (ch == '\n')) {
    return true;
  }
  return false;
}


unsigned char URGManualCapture::encode6bit(char ch) {
  return 0x3f & (ch - 0x30);
}


int URGManualCapture::adjustIndex(int index, int add) {
  int a = (index - (index >> 6) + ((index >= 64) ? 1 : 0)) % 64;
  int b =
    (index - ((index + add) >> 6) + ((index + add>= 64) ? 1 : 0) + add) % 64;
  if (a > b) {
    return index + add + 1;
  } else {
    return index + add;
  }
}


int URGManualCapture::capture(long *data, int from, int to, int group) {
  int range[2] = { from, to };

  for (int i = 0; i < 2; ++i) {
    if (range[i] < 0) {
      range[i] = 0;
    } else if (range[i] >= URG::DATA_SIZE) {
      range[i] = URG::DATA_SIZE -1;
    }
  }
  if (range[0] > range[1]) {
    swap(&range[0], &range[1]);
  }
  if (group <= 0) {
    group = 1;
  } else if (group > 99) {
    group = 99;
  }

  // f[^v̑M
  char message[10];
  sprintf(message, "G%03d%03d%02d\r", range[0], range[1], group);
  con->flush();
  con->send(message, 10);

  // f[^̎M
  char reply[10];
  char ret;
  char recv_buffer[(URG::DATA_SIZE * 3) + ((URG::DATA_SIZE * 3) >> 6)];
  char lf[2];
  
  con->recv(reply, 9, SCI::TIMEOUT);
  if (strncmp(message, reply, 9)) {
    return -1;
  }
  
  con->recv(lf, 1, SCI::TIMEOUT);
  if (!isLF(lf[0])) {
    return -1;
  }
  con->recv(&ret, 1, SCI::TIMEOUT);
  if (ret != '0') {
    return -1;
  }
  con->recv(lf, 1, SCI::TIMEOUT);
  if (!isLF(lf[0])) {
    return -1;
  }
  
  int numdata = range[1] - range[0] +1;
  numdata = (numdata / group) + ((numdata % group == 0) ? 0 : 1);
  int base_num = numdata * data_byte_size;
  int total = base_num + (base_num >> 6);

  if (total != con->recv(recv_buffer, total, SCI::TIMEOUT)) {
    return -1;
  }
  if ((2 != con->recv(lf, 2, SCI::TIMEOUT)) || !isLF(lf[0]) || !isLF(lf[1])) {
    return -1;
  }

  // f[^zɊi[
  for (int i = 0; i < range[0]; ++i) {
    data[i] = -1;
  }
  int index = range[0];
  for (int i = 0; (index <= range[1]) && (i < numdata); ++i) {
    int num = i * data_byte_size;
    int actual_index = num + (num >> 6);
    if ((i > 0) && ((i & 0x3f) == 0) &&
	!isLF(recv_buffer[actual_index -1])) {
      return -1;
    }
    for (int j = 0; (index <= range[1]) && (j < group); ++j) {
      data[index] =
	(encode6bit(recv_buffer[adjustIndex(actual_index, 0)]) << 6)
	| encode6bit(recv_buffer[adjustIndex(actual_index, 1)]);
      if (data_byte_size == 3) {
	data[index] = (data[index] << 6)
	  | encode6bit(recv_buffer[adjustIndex(actual_index, 2)]);
      }
      ++index;
    }
  }
  for (int i = range[1] +1; i < URG::DATA_SIZE; ++i) {
    data[i] = -1;
  }

  if (!isHandstand) {
    long forSwap;
    for (int i = (URG::DATA_SIZE >> 1) + 1; i >= 0; --i) {
      int swapIndex = URG::DATA_SIZE - i - 1;
      forSwap = data[i];
      data[i] = data[swapIndex];
      data[swapIndex] = forSwap;
    }
  }

  ++capture_times;
  return URG::DATA_SIZE;
}


int URGManualCapture::capture(long *data, int group) {
  return capture(data, 0, URG::DATA_SIZE-1, group);
}


void URGManualCapture::laser(bool on) {
  if (!is_connect()) {
    return;
  }
  char message[3];
  sprintf(message, "L%c\r", (on == true) ? '1' : '0');
  con->send(message, 3);

  char recv_buffer[6];
  con->recv(recv_buffer, 6, SCI::TIMEOUT);
}


bool URGManualCapture::setLongRangeMode(bool on) {
  if (!is_connect()) {
    return false;
  }

  if (product_version != URG_PROD_X_003) {
    return !on;
  }

  char message[3];
  sprintf(message, "E%c\r", (on == true) ? '1' : '0');
  con->send(message, 3);
  
  char recv_buffer[6 + 1] = { '\0', '\0', '\0', '\0', '\0', '\0', '\0' };
  con->recv(recv_buffer, 6, SCI::TIMEOUT);

  bool ret = (recv_buffer[3] == '0') ? true : false;
  if (ret) {
    protocol_version = (on) ? URG_PROT_1_0Z : URG_PROT_1_0;
  }
  
  return ret;
}


const char* URGManualCapture::getURGSerialName(void) {
  return serialId;
}

const char* URGManualCapture::getURGProductName(void) {
  if (!is_connect()) {
    return "Not connected.";
  }
  if (product_version == URG_PROD_X_002) {
    return "SOKUIKI Sensor URG-X002";
  }
  if (product_version == URG_PROD_X_003) {
    return "SOKUIKI Sensor URG-X003";
  }
  
  return "Unknown Product type";
}


const char* URGManualCapture::getURGProtocolName(void) {
  if (!is_connect()) {
    return "Not connected.";
  }
  
  if (product_version == URG_PROD_X_002) {
    return "00003,(SCIP 1.0)";
  }
  if (product_version == URG_PROD_X_003) {
    if (protocol_version == URG_PROT_1_0Z) {
      return "00003,(SCIP1.0z[Data Encoded by 3char for over 4095m])";
    }
    if ((protocol_version == URG_PROT_1_0) ||
	(product_version == 2)) {
      return "00003,(SCIP 1.0)";
    }
  }
  
  return "Unknown Protocol type";
}


void URGManualCapture::setHandstand(bool on) {
  isHandstand = on;
}


bool URGManualCapture::isLongRangeMode(void) {
  return (protocol_version == URG_PROT_1_0Z) ? true : false;
}


int URGManualCapture::getMesurableMax(void) {
  return (protocol_version == URG_PROT_1_0Z) ? 65534 : 4094;
}
