#ifndef URG_AUTO_CAPTURE_H
#define URG_AUTO_CAPTURE_H

/*!
  \file
  \brief kzd@ ZT URG-X002, URG-X003 ̃f[^擾NX

  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "urgManualCapture.h"


/*!
  \brief ZT̋@\(f[^̎XVA_uobt@O)

  ZT̃f[^擾ʃXbhɂďA[U capture() vɑ΂Ď擾ς݂̃f[^zɊi[ĕԂB
  
  擾ς݂̃f[^擾w(from, to, group ̒l) capture() Ŏw肳ꂽ擾ƓłȂ΁Acapture() ̓f[^̎擾܂ŃubNB capture() sƃf[^̎擾悢B
  f[^̎擾ɂ́AŌɌĂяoꂽ capture() ̈pB

  \attention SDL CXg[ĂȂ΁AURGAutoCapture ͗płȂ
*/
class DECLSPEC URGAutoCapture : public URGManualCapture {
  friend int capture_thread(void *data);

  typedef struct {
    int from, to, group;
    int ret;
    long data[URG::DATA_SIZE];
    int attribute;
  } uac_buffer_data_t;


  typedef struct {
    void *stop_sem;
    void *quit_sem;
    void *mut;
    int order_from, order_to, order_group;
    int receiving_index;
    uac_buffer_data_t buffer[2];
  } uac_autoCapture_t;


  typedef struct {
    void *funcs;
    uac_autoCapture_t *auto_capture;
  } uac_captureData_t;

  void *thread;
  uac_autoCapture_t auto_capture;
  int capture_times;
  
  void initCaptureData(void);
  void destroyCaptureData(void);

public:
  enum { NO_DATA, RECEIVING, RECEIVED, };
  URGAutoCapture(void);
  ~URGAutoCapture(void);
  int get_captureTimes(void);
  int capture(long *data, int from, int to, int group);
  int capture(long *data, int group);
  void laser(bool on);
  void setHandstand(bool on);
};

#endif /* !URG_AUTO_CAPTURE_H */
