#ifndef URG_CAPTURE_H
#define URG_CAPTURE_H

/*!
  \file
  \brief kzd@ ZT URG-X002, URG-X003 ̑C^[tF[X
  
  f[^擾̂߂̃C^[tF[XƁAf[^ϊ̂߂ statico֐񋟂
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "dll_macro.h"


/*!
  \brief ZT̒萔
*/
namespace URG {
  enum {
    BAUDRATE = 115200,		/*!< W̐ڑ{[[g */
    DEFAULT_BAUDRATE = BAUDRATE, /*!< W̐ڑ{[[g */
    
    DATA_SIZE = 769,   /*!< Mf[^̍ő (1024.0*270/360)+1 */
    ON = true,	      /*!< URGCapture::laser() p̒萔Bw */
    OFF = false,      /*!< URGCapture::laser() p̒萔Bw */
    
    DEVICE_OPEN_ERROR = -2,	/*!< foCXƂ̐ڑɎs */
    BAUDRATE_ADJUST_ERROR = -3,	/*!< ʐMx̒Ɏs */
    PRODUCT_MISMATCH_ERROR = -4, /*!< hCoΉ̐iɐڑ */
  };


  /*!
    \addtogroup angle_convert CfbNXEpxϊ
    \{
  */
  
  /*!
    \brief degreepxf[^zindexlɕϊ
    
    pxURGCapture::capture() ̃f[^zCfbNXƂ̕ϊs
    
    \param degree [i] px[degree]
    \retval index zindexl
    
    \par gp
    \code
    URGCapture *urg = new URGManualCapture();
    urg->connect("/dev/ttyS0");
    
    urg->capture(deg2index(-45), deg2index(45));
    // O -45[deg]  45[deg] ͈̔͂̃f[^擾
    \endcode
  */
  extern int deg2index(const int degree);


  /*!
    \brief f[^zindexldegreepxɕϊ
    
    pxURGCapture::capture() ̃f[^zƂ̕ϊs
    
    \param index [i] zindexl  
    \retval degree px[degree]
    
    \par gp
    \code
    URGCapture *urg = new URGManualCapture();
    urg->connect("/dev/ttyS0");
    
    // O -45[deg]  45[deg] ͈̔͂̃f[^擾A\
    urg->capture(deg2index(-45), deg2index(45));
    int to = deg2index(45);
    for (int i = deg2index(-45); i < to; ++i) {
    printf("%d[deg]: %d[mm]\n", index2deg(i), data[i]);
    }
    \endcode
  */
  extern int index2deg(const int index);


  /*!
    \brief f[^zindexlradianpxɕϊ
    
    pxURGCapture::capture() ̃f[^zƂ̕ϊs
    
    \param index [i] zindexl  
    \retval radian px[radian]
    
    \par gp
    \code
    URGCapture *urg = new URGManualCapture();
    urg->connect("/dev/ttyS0");
    
    // O -45[deg]  45[deg] ͈̔͂̃f[^擾A\
    urg->capture(deg2index(-45), deg2index(45));
    int to = deg2index(45);
    for (int i = deg2index(-45); i < to; ++i) {
    printf("%.2f[rad]: %d[mm]\n", index2rad(i), data[i]);
    }
    \endcode
  */
  extern double index2rad(const int index);



  /*!
    \brief radianpxdegreepxɕϊ
    
    \param radian px[radian]  
    \retval degree [i] px[degree]
    
    \par gp
    \code
    URGCapture *urg = new URGManualCapture();
    urg->connect("/dev/ttyS0");
    
    // O -45[deg]  45[deg] ͈̔͂̃f[^擾A\
    urg->capture(deg2index(rad2deg(-M_PI/4)), deg2index(rad2deg(M_PI/4)));
    int to = deg2index(rad2deg(M_PI/4));
    for (int i = deg2index(rad2deg(-M_PI/4)); i < to; ++i) {
    printf("%.2f[rad]: %d[mm]\n", index2rad(i), data[i]);
    }
    \endcode
  */
  extern int rad2deg(const double radian);


  /*!
    \brief degreepxradianpxɕϊ
    
    \param degree [i] px[degree]
    \return radian px[radian]
  */
  extern double deg2rad(const int degree);
  /*! \} */
};


/*!
  \brief ZT̋@\`
*/
class DECLSPEC URGCapture {
public:

  /*!
    \brief ZT̃f[^̎擾ꂽ񐔂Ԃ

    ̃\bh́AURGAutoCapture Ŏ擾f[^̎ʂ邽߂ɗpB擾񐔂̓IuWFNg 0 ɏB

    \param Ȃ
    \retval ZTf[^nꂽ

    \par gp
    \code
    long data[URG::DATA_SIZE];
    URGCapture *urg = new URGAutoCapture();
    for (int i = 0; i < 20; ++i) {
      // times ̒lقȂ΁AقȂ^C~ÕZVOf[^
      printf("times: %d\n", urg->capture(data).get_captureTimes());
    }
    \endcode
  */
  virtual int get_captureTimes(void) = 0;

  
  /*!
    \brief ZTւ̐ڑs

    ZTւ̐ڑƎw{[[gւ̕ύXsB
    URGZT͓d𓊓AN܂łɐb̎Ԃ邽߁Ad connect() ͎s邱ƂB
    
    \param deviceName [i] foCX
    \param baudrate [i] {[[g
    \retval 0 I
    \retval ߂l < 0 ڑG[

    \par gp
    \code
    URGCapture *urg = new URGManualCapture();
    if (urg->connect("/dev/ttyS0") < 0) {
      printf("connection fail.\n");
      exit(1);
    }
    \endcode
  */
  virtual int connect(const char *deviceName,
		      long baudrate = URG::BAUDRATE) = 0;


  /*!
    \brief V~[^ւ̐ڑs

    V~[^ւ̐ڑsBSDL_net ̃CXg[K{B

    \param host [i] zXg
    \param port [i] |[gԍ
    \retval 0 I
    \retval ߂l < ڑG[
  */
  virtual int connectSimulator(const char *host, int port) = 0;


  /*!
    \brief ZTƂ̐ڑ

    connect(), connectSimulator() ɂڑB

    \param Ȃ
    \retval Ȃ

    \par gp
    \code
    URGCapture *urg = new URGManualCapture();
    if (urg->connect("/dev/ttyS0") < 0) {
      printf("connection fail.\n");
      exit(1);
    }
    ...
    urg->disconnect();
    \endcode
  */
  virtual void disconnect(void) = 0;


  /*!
    \brief ZTƐڑĂ邩Ԃ

    foCXɑ΂ڑLǂԂBAconnect()  disconnect() Ăяo܂ŏ true ԂB]āAڑP[uǂ̌oɂ͗płȂB

    \param Ȃ
    \retval true ڑĂ
    \retval false ڑĂȂ

    \par gp
    \code
    URGCapture *urg = new URGManualCapture();

    printf("is_connect: %d\n", urg->is_connect());
    // o: false (0)
    
    urg->connect("/dev/ttyS0");

    printf("is_connect: %d\n", urg->is_connect());
    // o: 1 (true)

    ...
    
    urg->disconnect();

    printf("is_connect: %d\n", urg->is_connect());
    // o: 0 (false)
    \endcode
  */
  virtual bool is_connect(void) = 0;


  /*!
    \brief ZT̎tԂ̐ݒ

    ꍇɂẮAZTVntɎtĎgpĂꍇB̃\bhŎtԂݒ肷ƁA擾ꂽf[^̔zutŊi[B

    \param on [i] VntŎtĂꍇ true
  */
  virtual void setHandstand(bool on) = 0;


  /*!
    \brief ZTf[^擾

    f[^i[zɂ́AZTSʂ 0[degree]Ƃꍇ -135[degree] index  0 ɁA135[degree] index  768 ɑΉB
    \image html "urgIndex.png" zɊi[f[^Ɗpx̊֌W(ZT^ォ̐})
    zɊi[f[^l̈Ӗ͈ȉ̒ʂ
    \li -1 : 
    \li < 20 : G[
    \li [20, 4095] : Ώۂ܂ł[mm]
    \li > 4095 : 4095[mm]ȏ̋

    AʐMvgR skip 1.0z ̏ꍇɂ́A10[m] ܂ł̃f[^\ƂȂB

    f[^̃O[sOQȏɎw肷邱ƂŁAZT̃f[^擾ԂZk邱ƂłBURGCapture::capture() ł̓O[sOňkꂽMf[^WJĔzɊi[BO[sǑʂȉɎB

    \code
    // Sf[^AĂƉ肷
    
    long data[URG::DATA_SIZE];
    urg.capture(data, 0, URG::DATA_SIZE, 1);
    // i[f[^: { 21, 22, 24, 23, 25, 26,...};

    urg.capture(data, 0, URG::DATA_SIZE, 2);
    // i[f[^: { 21, 21, 23, 23, 25, 26,...}, MTCY 1/2 

    urg.capture(data, 0, URG::DATA_SIZE, 3);
    // i[f[^: { 21, 21, 21, 24, 24, 24,...}, MTCY 1/3 
    \endcode

    ܂A擾f[^̎QƗ͈ȉ̒ʂ
    \code
    long data[URG::DATA_SIZE];
    int n = urg.capture(data, deg2index(-45), deg2index(45));

    for (int i = 0; i < n; ++i) {
      printf("%d[deg]: %ld[mm]\n", index2deg(i), data[i]);
    }
    \endcode

    \param data [o] f[^i[z
    \param from [i] Jnindex
    \param to [i] Iindex
    \param group [i] O[sOsf[^

    \retval URG::DATA_MAX z̃f[^
    \retval ߂l < 0 G[
  */
  virtual int capture(long *data, int from, int to, int group = 1) = 0;


  /*!
    \brief ZTf[^擾
    
    URGCapture::capture() QƂ̂

    擾f[^̎QƗ͈ȉ̒ʂ
    \code
    long data[URG::DATA_SIZE];
    int n = urg.capture();

    for (int i = 0; i < n; ++i) {
      printf("%d[deg]: %ld[mm]\n", index2deg(i), data[i]);
    }
    \endcode

    \param data [o] f[^i[z
    \param group [i] O[sOsf[^
    \retval URG::DATA_MAX z̃f[^
    \retval ߂l < 0 G[
  */
  virtual int capture(long *data, int group = 1) = 0;


  /*!
    \brief ԊO[U[̓_𐧌

    \param on [i] URG::ON _w / URG::OFF w

    \par gp
    \code
    URGCapture *urg = new URGManualCapture();
    urg->connect("/dev/ttyS0");
    urg->laser(URG::OFF); // 
    ...
    urg->laser(URG::ON); // _
    \endcode
  */
  virtual void laser(bool on) = 0;


  /*!
    \brief 胂[h(4[m],10[m]) ̕ύXs

    ΏۃZT URG-X003 ̏ꍇAő 10[m] ܂őł郂[hɕύXłBAMf[^̃TCY 4[m] ܂ł̏ꍇɔׂđ邽߁Af[^̎Mɂ鎞Ԃ͑B

    \param on [i] URG::ON 10[m]胂[h / URG::OFF 4[m]胂[h
    \retval true I
    \retval false ύXɎs

    \par gp
    \code
    URGCapture *urg = new URGManualCapture();
    urg->connect("/dev/ttyS0");
    urg->setLongRangeMode(URG::ON);
    ...
    urg->setLongRangeMode(URG::OFF);
    \endcode
  */
  virtual bool setLongRangeMode(bool on) = 0;


  /*!
    \brief ݂̑胂[h擾

    \param Ȃ
    \retval true 10[m]胂[h
    \retval false 4[m]胂[h
  */
  virtual bool isLongRangeMode(void) = 0;


  /*!
    \brief ZT̃VAԂ

ZTɑ΂ skip  V R}h𑗂ƂɕԂ SERI:(VA)ԂBZTfoCXɐڑĂȂꍇ "Not connected." ԂB
    
    URGCapture::getURGSerialName QƂ̂
    
    \param Ȃ
    \retval ւ̃|C^
  */
  virtual const char* getURGSerialName(void) = 0;


  /*!
    \brief ZŤ^Ԃ

    ZTɑ΂ skip  V R}h𑗂ƂɕԂ PROD:(i)琄鐻iԂBZTłȂƂ́A"Unknown Product type" ԂB܂ZTfoCXɐڑĂȂꍇ "Not connected." ԂB

    \param Ȃ
    \retval ZT^ւ̃|C^
    \retval "Not connected." ڑ
    \retval "Unknown Product type" Ɏs
    \retval "SOKUIKI Sensor URG-X002" URG-X002 4[m] o[W
    \retval "SOKUIKI Sensor URG-X003" URG-X003 4[m], 10[m] o[W

    \par gp
    \code
    URGCapture *urg = new URGManualCapture();
    urg->connect("/dev/ttyS0");
    printf("Product: %s\n", urg->getURGProductName());
    \endcode
  */
  virtual const char* getURGProductName(void) = 0;

  
  /*!
    \brief ZT̃vgRԂ

    ZTɑ΂ skip  V R}h𑗂ƂɕԂ PROT:(vgR)琄vgRԂBvgR𐄒łȂƂ́A"Unknown Product type" ԂB܂ZTfoCXɐڑĂȂꍇ "Not connected." ԂB

    \param Ȃ
    \retval ZT^ւ̃|C^
    \retval "Not connected." ڑ
    \retval "Unknown Protocol type" Ɏs
    \retval "00003,(SCIP 1.0)" skip 1.0 4[m][h
    \retval "00003,(SCIP1.0z[Data Encoded by 3char for over 4095m])" skip 1.0z 10[m][h

    \par gp
    \code
    URGCapture *urg = new URGManualCapture();
    urg->connect("/dev/ttyS0");
    printf("Product: %s\n", urg->getURGProtocolName());
    \endcode
  */
  virtual const char* getURGProtocolName(void) = 0;

  
  /*!
    \brief f[^ƂėLȋ̍őlԂ

    \param Ȃ
    \retval mesurable_max f[^ƂėLȋ̍ől [mm]
  */
  virtual int getMesurableMax(void) = 0;
    

  virtual ~URGCapture(void) {}
};

#endif /* !URG_BASE_H */
