#ifndef URG_CTRL_H
#define URG_CTRL_H

/*!
  \file
  \brief kzd@ ZT URG-X002, URG-X003 ̊{NX

  URG-X002, URG-X003 ̊{̃\bh񋟂
  
  \author Satofumi KAMIMURA

  $Id$
*/

#include "urgAutoCapture.h"
#include "VXV_URGCtrl.h"
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>


#if defined _MBCS || defined WIN32
#define WINDOWS			/*!< Windows OS }N */
#else
#define LINUX			/*!< Linux OS }N */
#endif


/*!
  \brief ڑfoCX̐ݒt@C

  ڑfoCX̖IȎw肪ȂꍇAURG_CONFIG_FILE ݒǂݍ
*/
#ifndef URG_CONFIG_FILE
#define URG_CONFIG_FILE "b5conf.txt"
#endif


/*!
  \brief sڑfoCX
*/
#ifndef URG_AUTO_PORT
# ifdef LINUX
#  define URG_AUTO_PORT "/dev/ttyS"
# else
#  define URG_AUTO_PORT "COM"
# endif
#endif


/*!
  \brief f[^̎擾[h

  f[^擾ɗp擾[hw
*/
namespace URG_CAPTURE {
  /*!
    \brief f[^擾ɗpNXw
  */
  enum MODE {
    AUTO = true,		/*!< URGAutoCapture p */
    MANUAL = false,		/*!< URGManualCapture p */
  };
};


/*!
  \brief URGZT̑NX

  \par RpC
  \code
  // sample.cpp RpCꍇ
  % cc `vxv-config --cflags` sample.cpp -o sample `vxv-config --libs`
  \endcode
*/
class DECLSPEC URGCtrl : public VXV_URGCtrl {
  enum { ERROR_MESSAGE_BUFFER_SIZE = 255 };
  
protected:
  URGCapture *mode;		/*!< f[^̎擾[h */

private:
  const char *error_message;
  const char *error_device;
  char error_device_buffer[ERROR_MESSAGE_BUFFER_SIZE];
  long error_baudrate;
  char error_message_buffer[ERROR_MESSAGE_BUFFER_SIZE];
  bool isHandstand;
  std::vector<VXV_Grid2D> dummy2D;
  std::vector<VXV_Grid3D> dummy3D;

  void initLength(void);
  int connectSimulator(void);
  
#include "get_keyword.c"
  int searchConfigFile(const char *path, bool autoCapture);

protected:
  /*!
    \brief convert2D p̃_~[
  */
  std::vector<VXV_Grid2D>& getGrid2DObj(void) { return dummy2D; }

  /*!
    \brief convert3D p̃_~[
  */
  std::vector<VXV_Grid3D>& getGrid3DObj(void) { return dummy3D; }
  
public:
  /*!
    \addtogroup urgCtrl_system VXe()
    \{
  */
  enum MODE {
    AUTO = true,		/*!< URGAutoCapture p */
    MANUAL = false,		/*!< URGManualCapture p */
  };

  bool is_captured;		/*!< ߋ̃f[^擾ǂ */
  long mesurable_max;		/*!< \ȃf[^̍ől */

  URGCtrl(void);
  URGCtrl(URGCapture *captureMode);
  ~URGCtrl(void);
  const char *getError(void);
  int connect(const char *deviceName,long  baudrate = URG::BAUDRATE,
	      bool autoCapture = true);
  int connect(bool autoCapture = true);
  int connect(int argc, char *argv[], bool autoCapture = true);
  void disconnect(void);
  bool is_connect(void);
  int get_captureTimes(void);
  void laser(bool on);
  const char* getURGSerialName(void);
  const char* getURGProductName(void);
  const char* getURGProtocolName(void);
  bool setLongRangeMode(bool on);
  URGCtrl& setHandstand(bool on);
  long get_mesurableMax(void);
  /*! \} */


  /*!
    \addtogroup urgCtrl_capture URGCtrl
    \{
  */
  long length[URG::DATA_SIZE];	/*!< 擾f[^i[z */
  URGCtrl& capture(int from, int to, int group = 1);
  URGCtrl& capture(int group = 1);
  /*! \} */

  virtual VXV_URGCtrl& setURGOffset(int x, int y, VXV_Direction t) {
    return *this;
  }
    virtual VXV_URGCtrl& setPosition(int x, int y, VXV_Direction t) {
    return *this;
  }
  virtual VXV_URGCtrl& setPosition(VXV_Position& position) {
    return *this;
  }

  virtual VXV_URGCtrl& convert2D(void) {
    return *this;
  }
  virtual VXV_URGCtrl& convert2D(int x, int y, VXV_Direction t) {
    return *this;
  }
  virtual VXV_URGCtrl& convert2D(VXV_Position& position) {
    return *this;
  }

  virtual VXV_URGCtrl& setURGOffset(int x, int y, int z,
				    VXV_Direction dx,
				    VXV_Direction dy,
				    VXV_Direction dz) { return *this; }
  virtual VXV_URGCtrl& setPosition(int x, int y, int z,
				   VXV_Direction dx,
				   VXV_Direction dy,
				   VXV_Direction dz) { return *this; }
  virtual VXV_URGCtrl& convert3D(void) { return *this; }
  virtual VXV_URGCtrl& convert3D(int x, int y, int z,
				 VXV_Direction dx,
				 VXV_Direction dy,
				 VXV_Direction dz) { return *this; }
};

#endif /* !URG_CTRL_H */
