#ifndef URG_CTRL_2D_H
#define URG_CTRL_2D_H

/*!
  \file
  \brief kzd@ ZT URG-X002, URG-X003 ̂QcNX

  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "urgCtrl.h"
#include "vxvUtils.h"


/*!
  \brief 񎟌̍WʒuӎURGZT̑NX

  \par RpC
  \code
  // sample.cpp RpCꍇ
  % cc `vxv-config --cflags` sample.cpp -o sample `vxv-config --libs`
  \endcode
*/
class DECLSPEC URGCtrl2D : public URGCtrl {
protected:
  /*!
    \brief ➑̈ʒu
  */
  VXV_Position base;

  /*!
    \brief ZT[➑̂̑Έʒu
  */
  VXV_Position sensor_offset;

  std::vector<VXV_Grid2D>& getGrid2DObj(void) {
    return grid2D_vector;
  }
  
public:
  /*!
    \addtogroup urgCtrl2D_capture URGCtrl2D
    \{
  */

  std::vector<VXV_Grid2D> grid2D_vector; /*!< 񎟌ϊꂽf[^ */
  VXV_Grid2D grid2D[URG::DATA_SIZE]; /*!< 񎟌ϊf[^i[z */

  URGCtrl2D(void);
  ~URGCtrl2D(void);
  URGCtrl2D& setURGOffset(int x, int y, VXV_Direction t);
  URGCtrl2D& setURGOffset(int x, int y, int degree);
  URGCtrl2D& capture(int from, int to, int group = 1);
  URGCtrl2D& capture(int group = 1);
  URGCtrl2D& setPosition(int x, int y, VXV_Direction t);
  URGCtrl2D& setPosition(VXV_Position& position);
  URGCtrl2D& setPosition(int x, int y, int degree);
  URGCtrl2D& convert2D(void);
  URGCtrl2D& convert2D(int x, int y, VXV_Direction t);
  URGCtrl2D& convert2D(VXV_Position& position);
  URGCtrl2D& convert2D(int x, int y, int degree);
  /*! \} */


  virtual VXV_URGCtrl& setURGOffset(int x, int y, int z,
				    VXV_Direction dx,
				    VXV_Direction dy,
				    VXV_Direction dz) {
    return setURGOffset(x, y, dx);
  }
  virtual VXV_URGCtrl& setPosition(int x, int y, int z,
				   VXV_Direction dx,
				   VXV_Direction dy,
				   VXV_Direction dz) {
    return setPosition(x, y, dz);
  }
  virtual VXV_URGCtrl& convert3D(void) {
    return convert2D();
  }
  virtual VXV_URGCtrl& convert3D(int x, int y, int z,
				 VXV_Direction dx,
				 VXV_Direction dy,
				 VXV_Direction dz) {
    return convert2D(x, y, dz);
  }
};

#endif /* !URG_CTRL_2D_H */
