#ifndef URG_CTRL_3D_H
#define URG_CTRL_3D_H

/*!
  \file
  \brief kzd@ ZT URG-X002, URG-X003 ̂RcNX

  \attention 

  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "urgCtrl.h"
#include "urgCtrl2D.h"
#include "VXV_Direction.h"


/*!
  \brief O̍WʒuӎURGZT̑NX
*/
class DECLSPEC URGCtrl3D : public URGCtrl2D {
  /*!
    \addtogroup urgCtrl3D_capture URGCtrl3D
    \{
  */

  /*!
    \brief O̍Wʒu
  */
  typedef struct {
    double a11, a21, a31, a12, a22, a32, a13, a23, a33;
    int a41, a42, a43, a44;
  } convertVector4D_t;
  /*! \} */
  
  int base_z;
  VXV_Grid3D sensor_offset;
  VXV_Direction base_rx, base_ry, base_rz;
  VXV_Direction sensor_offset_rx, sensor_offset_ry, sensor_offset_rz;
  convertVector4D_t conv;

  void clearDirection(VXV_Direction& direction);
  void setPointVector(VXV_Grid3D *point, int x, int y);
  void createConvertVector4D(int x, int y, int z, int rx, int ry, int rz);
  void converGrid3D(VXV_Grid3D *a, VXV_Grid3D *b);

protected:
  std::vector<VXV_Grid3D>& URGCtrl3D::getGrid3DObj(void) {
    return grid3D_vector;
  }
  
public:
  /*!
    \addtogroup urgCtrl3D_capture URGCtrl3D
    \{
  */

  std::vector<VXV_Grid3D> grid3D_vector; /*!< Oϊꂽf[^ */
  VXV_Grid3D grid3D[URG::DATA_SIZE]; /*!< Oϊ̃f[^i[p̔z */

  URGCtrl3D(void);
  ~URGCtrl3D(void);
  URGCtrl3D& setURGOffset(int x, int y, int z,
			  VXV_Direction dx,
			  VXV_Direction dy,
			  VXV_Direction dz);
  URGCtrl3D& capture(int from, int to, int group = 1);
  URGCtrl3D& capture(int group = 1);
  URGCtrl3D& setPosition(int x, int y, int z,
			 VXV_Direction dx, VXV_Direction dy, VXV_Direction dz);
  URGCtrl3D& setPosition(int x, int y, VXV_Direction t);
  URGCtrl3D& convert3D(void);
  URGCtrl3D& convert3D(int x, int y, int z,
		       VXV_Direction dx, VXV_Direction dy, VXV_Direction dz);
  URGCtrl3D& convert3D(int x, int y, VXV_Direction t);
  URGCtrl3D& convert3D(VXV_Position& position);
  /*! \} */
};

#endif /* !URG_CTRL_3D_H */
