/*
  VAfoCX
  Satofumi KAMIMURA
  $Id$
*/

#include "stdafx.h"
#include "serialDevice.h"
#ifndef _MBCS
# include <unistd.h>
#endif
#include <stdio.h>
#include <fcntl.h>
#ifdef _MBCS
#using <mscorlib.dll>
using namespace System;
using namespace Microsoft::Win32;
#endif


/*!
  \brief IuWFNg̐
  
  ڑȃIuWFNg𐶐
*/
#ifdef LINUX
SerialDevice::SerialDevice(void) : fd(-1)
#else
SerialDevice::SerialDevice(void) : hComm(INVALID_HANDLE_VALUE)
#endif
{
  recv_buffer = new RingBuffer<char>(BUFSIZ-1);
}


/*!
  \brief wfoCXɐڑ

  \param devName [i] ڑVAfoCX
  \param baudrate [i] ڑ{[[g

  \retval 0 I
  \retval SCI::DEVICE_OPEN_ERROR G[
*/
int SerialDevice::connect(const char *devName, int baudrate) {

  if (is_connect()) {
    disconnect();
  }

#ifdef LINUX
  fd = open(devName, O_RDWR | O_SYNC | O_NOCTTY);
  if (fd < 0) {
    perror(devName);
    return SCI::DEVICE_OPEN_ERROR;
  }

  /*
  sio.c_iflag = IGNPAR;
  sio.c_oflag = 0;
  sio.c_cflag = CS8 | CREAD | CLOCAL;
  sio.c_lflag = 0;
  */
  /*
  sio.c_cflag = (sio.c_cflag & ~CSIZE) | CS8;
  sio.c_iflag &= ~( BRKINT | ICRNL | ISTRIP );
  sio.c_iflag &= ~IXON;
  sio.c_cflag &= ~PARENB;
  sio.c_cflag &= ~CRTSCTS;
  sio.c_cflag &= ~CSTOPB;
  sio.c_lflag &= ~( ISIG | ICANON | ECHO );
  */

  sio.c_iflag = IGNPAR;
  sio.c_oflag = 0;
  sio.c_cflag = CS8 | CREAD | CLOCAL;
  sio.c_lflag = 0;
  
  sio.c_cc[VMIN] = 0;
  sio.c_cc[VTIME] = 0;

  tcsetattr(fd, TCSANOW, &sio);

  /* ^CAEgݒ */
  nfds.fd = fd;
  nfds.events = POLLIN | POLLPRI | POLLERR | POLLHUP | POLLNVAL;
  nfds.revents = 0;
  
#else
  char comPort[16];
  if (strlen(devName) >= 16) {
    return SCI::DEVICE_OPEN_ERROR;
  }
  sprintf(comPort, "\\\\.\\%s", devName);
  hComm = CreateFile(comPort, GENERIC_READ | GENERIC_WRITE, 0, NULL,
		     OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if (hComm == INVALID_HANDLE_VALUE) {
    LPVOID lpMsg;
    FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
		  FORMAT_MESSAGE_FROM_SYSTEM |
		  FORMAT_MESSAGE_IGNORE_INSERTS,
		  NULL, GetLastError(),
		  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		  (LPTSTR)&lpMsg, 0, NULL);
    printf("port(%s) open failed: %s\n", devName, (char *)lpMsg);
    LocalFree(lpMsg);
    return SCI::DEVICE_OPEN_ERROR;
  }
#endif

  /* {[[g̐ݒ */
  int ret_value = setBaudrate(baudrate);
  if (ret_value < 0) {
    return ret_value;
  }

  flush();

  return 0;
}


void SerialDevice::disconnect(void) {
#ifdef LINUX
  if (fd > 0) {
    close(fd);
    fd = -1;
  }
#else
  if (hComm != INVALID_HANDLE_VALUE) {
    CloseHandle(hComm);
  }
#endif
}


bool SerialDevice::is_connect(void) {
#ifdef LINUX
  return (fd > 0) ? true : false;
#else
  return (hComm != INVALID_HANDLE_VALUE) ? true : false;
#endif
}


int SerialDevice::setBaudrate(long baudrate) {
  if (!is_connect()) {
    return SCI::NO_CONNECT;
  }

#ifdef LINUX  
  // {[[g̕ύX
  long baudrate_value;
  switch (baudrate) {

  case 9600:
    baudrate_value = B9600;
    break;
    
  case 19200:
    baudrate_value = B19200;
    break;

  case 38400:
    baudrate_value = B38400;
    break;
    
  case 57600:
    baudrate_value = B57600;
    break;
    
  case 115200:
    baudrate_value = B115200;
    break;

  case B230400:
    baudrate_value = B230400;
    break;
    
  default:
    return SCI::BAUDRATE_ADJUST_ERROR;
    break;
  }

  cfsetispeed(&sio, baudrate_value);
  cfsetospeed(&sio, baudrate_value);
  tcsetattr(fd, TCSANOW, &sio);
#else

  DCB dcb;
  GetCommState(hComm, &dcb);
  dcb.BaudRate = baudrate;
  dcb.ByteSize = 8;
  dcb.Parity = NOPARITY;
  dcb.fParity = FALSE;
  dcb.StopBits = ONESTOPBIT;
  SetCommState(hComm, &dcb);
#endif
  
  return 0;
}


void SerialDevice::check(int size, int timeout) {
  if (!is_connect()) {
    return;
  }

  int require_size = (size < 0) ? recv_buffer->free_size() : size;
  require_size = (require_size > BUFSIZ) ? BUFSIZ : require_size;
  int filled = recv_buffer->size();
#ifdef LINUX
  while (filled < require_size) {
    if (poll(&nfds, 1, timeout) == 0) {
      break;                    // timeout
    }
    char buffer[BUFSIZ];
    int n = read(fd, buffer, require_size);
    if (n < 0) {
      return;
    }
    recv_buffer->put(buffer, n);
    filled += n;
  }
#else
  if (filled >= require_size) {
    return;
  }

  int read_size = require_size;
  if (timeout > 0) {
    COMMTIMEOUTS pcto;
    GetCommTimeouts(hComm, &pcto);
    pcto.ReadIntervalTimeout = timeout;
    pcto.ReadTotalTimeoutConstant = SCI::TIMEOUT;
    pcto.ReadTotalTimeoutMultiplier = read_size;
    SetCommTimeouts(hComm, &pcto);
    
  } else {
    DWORD dwErrors;
    COMSTAT ComStat;
    ClearCommError(hComm, &dwErrors, &ComStat);
    read_size = ((int)ComStat.cbInQue > require_size)
      ? require_size : ComStat.cbInQue;
  }
  char buffer[BUFSIZ];
  DWORD n;
  ReadFile(hComm, buffer, read_size, &n, NULL);
  recv_buffer->put(buffer, n);
#endif
}


int SerialDevice::recv(void *area, unsigned long maxlen, int timeout) {
  if (!is_connect()) {
    return SCI::NO_CONNECT;
  }
  
  check(maxlen, timeout);
  int len = (recv_buffer->size() > maxlen) ? maxlen : recv_buffer->size();
  if (len == 0) {
    return 0;
  }
  recv_buffer->get((char *)area, len);
  
  return len;
}


int SerialDevice::send(const void *area, unsigned long len) {
  if (!is_connect()) {
    return SCI::NO_CONNECT;
  }
#ifdef LINUX
  return write(fd, area, len);
#else
  DWORD n;
  WriteFile(hComm, area, len, &n, NULL);
  return n;
#endif
}
 
int SerialDevice::copy(void *area, unsigned long len) {
  return recv_buffer->copy((char *)area, len);
}


void SerialDevice::flush(void) {
#ifdef LINUX
  if (is_connect()) {
    tcflush(fd, TCIOFLUSH);
    recv_buffer->clear();
  }
#endif
}


long SerialDevice::size(void) {
  check(-1);
  if (!is_connect()) {
    return SCI::NO_CONNECT;
  }
  
  return recv_buffer->size();
}


SerialDevice::~SerialDevice(void) {
  disconnect();
  delete recv_buffer;
}


#ifdef _MBCS 
int SerialDevice::getComId(int id[], int max) {
  RegistryKey *reg =
    Registry::LocalMachine->CreateSubKey("HARDWARE\\DEVICEMAP\\SERIALCOMM");
  if (!reg) {
    return 0;
  }
  String* keys[] = reg->GetValueNames();
  for (int i = 0; (i < max) && (i < keys->Length); ++i) {
    String *value = reg->GetValue(keys[i])->ToString();
    id[i] = Convert::ToInt32(value->Substring(3));
  }
  return keys->Length;
}
#endif
 
