#ifndef VXV_Position_H
#define VXV_Position_H

/*!
  \file
  \brief ʒu̍\
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "VXV_Direction.h"
#include <math.h>
#include "dll_macro.h"


/*!
  \brief ʒu̍\
*/
class DECLSPEC VXV_Position {

  VXV_Position(const VXV_Position* rhs) : x(rhs->x), y(rhs->y), t(rhs->t) {}

public:
  int x;			/*!< X Wl */
  int y;			/*!< Y Wl */
  VXV_Direction t;		/*!< px */

  VXV_Position(void) : x(0), y(0) {}
  ~VXV_Position(void) {}


  /*!
    \brief lw̃IuWFNg

    \param x [i] XWl [mm]
    \param y [i] YWl [mm]
    \param t [i] px [VXV_Direction]
  */
  VXV_Position(int x, int y, const VXV_Direction& t) : x(x), y(y), t(t) {}

  
  /*!
    \brief ZqI[o[[h
  */
  VXV_Position& VXV_Position::operator+=(const VXV_Position& rhs) {
    x += rhs.x;
    y += rhs.y;
    t += rhs.t;
    return *this;
  }


  /*!
    \brief ZqI[o[[h
  */
  VXV_Position& VXV_Position::operator-=(const VXV_Position& rhs) {
    x -= rhs.x;
    y -= rhs.y;
    t -= rhs.t;
    return *this;
  }

  
  /*!
    \brief ZqI[o[[h
  */
  VXV_Position operator+(const VXV_Position& rhs) const {
    return VXV_Position(this) += rhs;
  }


  /*!
    \brief ZqI[o[[h
  */
  VXV_Position operator-(const VXV_Position& rhs) const {
    return VXV_Position(this) -= rhs;
  }


  /*!
    \brief degree Pʂ̌Ԃ
    \retval px [degree]
  */
  int deg(void) const {
    return t.deg();
  }


  /*!
    \brief radian Pʂ̌Ԃ
    \retval px [radian]
  */
  double rad(void) const {
    return t.rad();
  }

};

#endif /* !VXV_Position_H */
