#ifndef SERIAL_DEVICE_H
#define SERIAL_DEVICE_H

/*!
  \file
  \brief VAfoCX

  connectionDevice.h ̎

  \author Satofumi KAMIMURA
  \author Tomoaki YOSHIDA

  \todo Windows(Cygwin, MBCS) ɂēmFs
  
  $Id$
*/

#include "detect_os.h"
#include "connectionDevice.h"
#include "ringBuffer_template.h"
#ifndef WINDOWS
#include <sys/poll.h>
#include <termios.h>
#else
#include <windows.h>
#endif
#include "dll_macro.h"


/*!
  \brief VAfoCX̃ftHgݒ
*/
namespace SCI {
  enum {
    TIMEOUT = 105,		/*!< M̃^CAEg */
    BAUDRATE = 115200,		/*!< ڑ{[[g */
    
    DEVICE_OPEN_ERROR = -2,	/*!< foCXoG[ */
    BAUDRATE_ADJUST_ERROR = -3,	/*!< {[[gݒG[ */
    NO_CONNECT = -4,		/*!< ڑG[ */
  };
};


/*!
  \brief connectionDevice.h ̃VAfoCX
*/
class DECLSPEC SerialDevice : public ConnectionDevice {
#ifdef LINUX
  int fd;			/*!< ڑ */
  struct termios sio;           /*!< ʐM */
  struct pollfd nfds;           /*!< ^CAEg */
#else
  HANDLE hComm;
#endif

  void check(int size, int timeout = 0);
  RingBuffer<char> *recv_buffer;
  
public:
  SerialDevice(void);
  ~SerialDevice(void);
  int connect(const char *devName, int baudrate = SCI::BAUDRATE);
  void disconnect(void);
  bool is_connect(void);
  int setBaudrate(long baudrate);
  int recv(void *area, unsigned long maxlen, int timeout = 0);
  int send(const void *area, unsigned long len);
  int copy(void *area, unsigned long len);
  void flush(void);
  long size(void);
#ifdef _MBCS
  static int getComId(int id[], int max);
#endif
};

#endif /* !SERIAL_DEVICE_H */
