#ifndef CONNECTION_DEVICE_H
#define CONNECTION_DEVICE_H

/*!
  \file
  \brief ڑfoCX̃C^[tF[X

  ZTfoCXƂ̐ڑNX̃C^[tF[X`BVAATCP/IP ꂤB
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "dll_macro.h"


/*!
  \brief ڑfoCXp̃C^[tF[X
*/
class DECLSPEC ConnectionDevice {
public:

  /*!
    \brief foCXւ̐ڑs

    foCXƃ{[[gw肵ĒʐMfoCXɑ΂ĐڑsB TCP/IP ̏ꍇAbaudrate ̓|[gԍ

    \param devName [i] foCX
    \param baudrate [i] {[[g/|[gԍ
    \retval 0 I
    \retval ߂l < 0 G[
  */
  virtual int connect(const char *devName, int baudrate) = 0;


  /*!
    \brief foCXƂ̐ڑ
  */
  virtual void disconnect(void) = 0;


  /*!
    \brief ڑĂ邩Ԃ

    foCXɑ΂ڑLǂԂ
    
    \retval true ڑĂ
    \retval false ڑĂȂ
  */
  virtual bool is_connect(void) = 0;


  /*!
    \brief {[[g̕ύX
    
    {[[gw肳ꂽlɐݒ肷

    \param baudrate [i] {[[g
    
    \retval 0 I
    \retval ߂l < 0 G[
  */
  virtual int setBaudrate(long baudrate) = 0;


  /*!
    \brief f[^M

    ڑĂfoCX̃f[^Ms
    
    \param area [o] M̈ւ̃|C^
    \param maxlen [i] M̈̍őoCg
    \param timeout [i] M̃^CAEg[msec]
    
    \retval ߂l >= 0 MoCg
    \retval ߂l < 0 G[
  */
  virtual int recv(void *area, unsigned long maxlen, int timeout = 0) = 0;


  /*!
    \brief f[^M
    
    ڑĂfoCXւ̃f[^Ms

    \param area [i] Mf[^ւ̃|C^
    \param len [i] Mf[^̃oCg

    \retval ߂l >= 0 MoCg
    \retval ߂l < 0 G[
  */
  virtual int send(const void *area, unsigned long len) = 0;

  virtual int copy(void *area, unsigned long len) = 0;

  /*!
    \brief Mf[^̔j

    MǂłȂf[^AMĂȂf[^j
  */
  virtual void flush(void) = 0;


  /*!
    \brief ǂ݂Ƃ\ȎMf[^Ԃ

    recv() ɂēǂ݂Ƃ\ȃf[^̃oCgԂ

    \retval ߂l >= 0 ǂ݂Ƃ\ȃf[^̃oCg
    \retval ߂l < 0 G[
  */
  virtual long size(void) = 0;

  virtual ~ConnectionDevice(void) {}
};

#endif /* !CONNECTION_DEVICE_H */
