/*
  ^[~i\tg
  Satofumi KAMIMURA
  $Id$
*/

#include "standardInput.h"
#include "serialDevice.h"
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


static void printHelp(char *progName) {
  printf("using:\n"
	 "\t%s [--tty=ttyUSB0] [-b=38400]\n\n", progName);
  exit(1);
}


int main(int argc, char *argv[]) {
  char *device = "/dev/ttyUSB0";
  long baudrate = 38400;

  // nꂽ̕]
  for (int i = 1; i < argc; ++i) {
    if (!strncmp("--tty ", argv[i], 6) || !strncmp("--tty=", argv[i], 6)) {
      device = argv[i] + 6;
      continue;
    }
    if (!strncmp("-b ", argv[i], 3) || !strncmp("-b=", argv[i], 3)) {
      baudrate = atoi(argv[i] + 3);
      continue;
    }
    printHelp(argv[0]);
  }

  // VAڑJ
  SerialDevice con;
  int ret_value = con.connect(device, baudrate);
  if (ret_value < 0) {
    printf("serial device: connection fail.");
    exit(1);
  }
  

  // W͂ւ̐ڑJ
  StandardInput sto;

  // ʐM
  char buf[BUFSIZ];
  while (1) {
    int n = con.recv(buf, BUFSIZ, 0);
    if (n > 0) {
      write(1, buf, n);
    }
    n = sto.recv(buf, BUFSIZ, 100);
    if (n > 0) {
      con.send(buf, n);
    }
  }

  return 0;
}
