/*
  W͂ZXNX
  Satofumi KAMIMURA
  $Id$
*/

#include "standardInput.h"
#include <unistd.h>
#include <stdio.h>


StandardInput::StandardInput(void) {
  nfds.fd = 0;
  nfds.events = POLLIN | POLLPRI | POLLERR | POLLHUP | POLLNVAL;
  nfds.revents = 0;
}


StandardInput::~StandardInput(void) {
}


int StandardInput::recv(char *buffer, int maxlen, int timeout) {
  int filled = 0;
  
  while (filled < maxlen) {
    if (poll(&nfds, 1, timeout) == 0) {
      break;                    // timeout
    }

    int n = read(0, &buffer[filled], maxlen - filled);
    if (n < 0) {
      return filled;
    }
    filled += n;
  }
  return filled;
}
