<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$wacko_translation = [

	// language
	'lang_scheme'	=> [
		'name'		=> 'German',
		'code'		=> 'de',
		'dir'		=> 'ltr',
		'locale'	=> 'de_DE.UTF-8',
	],

	// common
	'AddButton'					=> 'Hinzufügen',
	'ArchiveButton'				=> 'Archivieren',
	'CancelButton'				=> 'Abbrechen',
	'ContinueButton'			=> 'Fortfahren',
	'ConvertButton'				=> 'Konvertieren',
	'CreateButton'				=> 'Erstellen',
	'DeleteButton'				=> 'Löschen',
	'RemoveButton'				=> 'Entfernen',
	'RenameButton'				=> 'Umbenennen',
	'ResetButton'				=> 'Zurücksetzen',
	'RestoreButton'				=> 'Wiederherstellen',
	'SaveButton'				=> 'Speichern',
	'SearchButton'				=> 'Suche',
	'SendButton'				=> 'Senden',
	'SetButton'					=> 'Setzen',
	'SubmitButton'				=> 'Speichern',
	'UpdateButton'				=> 'Aktualisieren',

	'FormInvalid'				=> 'Das übermittelte Formular war ungültig. Versuche erneut, das Formular abzusenden.',
	'UnitPixel'					=> 'px',
	'Number'					=> 'Anzahl',

	// logged in panel
	'AccountText'				=> 'Konto',
	'AccountTip'				=> 'Konto-Einstellungen',
	'AdminText'					=> 'Verwaltung',
	'AdminTip'					=> 'Systemverwaltung',
	'LogoutLink'				=> 'Abmelden',
	'LogoutButton'				=> 'Abmelden',
	'LogoutAreYouSure'			=> 'Willst du dich wirklich abmelden?',

	// registration panel
	'RegistrationWelcome'		=> 'Registrierung eines neuen Benutzers:',
	'RegistrationButton'		=> 'Benutzer registrieren',
	'UserNameOwned'				=> 'Dieser Name ist bereits vergeben. Bitte wähle einen anderen Namen.',
	'SiteRegistered'			=> 'Du hast dich erfolgreich auf der Website %1 registriert.',
	'RegistrationEmailInfo'		=> 'Eine gültige E-Mail-Adresse. Alle E-Mails der Website werden an diese Adresse gesendet werden. Die E-Mail-Adresse wird nicht veröffentlicht und wird nur verwendet, wenn ein neues Passwort angefordert wird oder wenn eingestellt wird, bestimmte Informationen oder Benachrichtigungen per E-Mail zu erhalten.',
	'EmailConfirmHint'			=> 'Bitte bestätige deine E-Mail-Adresse gemäß der dir zugesanden Anleitung.<br> Beachte, bei unbestätigter E-Mail-Adresse kann das vergessene Passwort nicht zurückgesetzt werden.',
	'EmailConfirmRequired'		=> 'Ohne bestätigte E-Mail Adresse kannst du dich nicht anmelden.',
	'NameTooShort'				=> 'Der Benutzername ist zu kurz, es sind mindestens %2 Zeichen erforderlich.',
	'NameTooLong'				=> 'Der Benutzername ist zu lang, es sind maximal %2 Zeichen zulässig.',
	'NameAlphanumOnly'			=> 'Der Benutzername muss zwischen %1 und %2 Zeichen lang sein und darf nur aus alphanumerischen Zeichen bestehen.',
	'NameCamelCaseOnly'			=> 'Der Benutzername muss zwischen %1 und %2 Zeichen lang sein und als WikiWort formatiert.',
	'NewUserAccount'			=> 'neues Benutzerkonto',

	'NewAccountSubject'			=> 'Konto Registrierung',
	'NewAccountAdminCreated'	=> 'Der Benutzer %1 hat für dich ein Konto mit dem Benutzernamen "%2" angelegt. Um die Registrierung abzuschließen, besuche die folgende URL (stelle sicher, dass sie in einer einzigen Zeile eingegeben wurde) und setze dein eigenes Zugangskennwort:',
	'NewAccountUsername'		=> 'Benutzername:',
	'AccountLanguage'			=> 'Sprache:',
	'NewAccountEmail'			=> 'E-Mail:',
	'NewAccountIP'				=> 'Von IP-Adresse:',
	'NewAccountSignupInfo'		=> 'Das folgende Konto wurde angelegt:',

	'UserWaitingApproval'		=> 'Eine E-Mail wurde an den Administrator gesendet. Der Administrator wird die angegebenen Informationen überprüfen, und die Anfrage für ein neues Konto zulassen oder ablehnen.',
	'UserRequiresApproval'		=> 'Um den Benutzer für %1 zuzulassen oder abzulehnen gehe ins Admin-Panel.',
	'UserApprovalInfo'			=> 'Nachdem du dich registriert hast, wird deine Registrierung zur Freischaltung an den Administrator der Seite geschickt. Du erhältst dann eine E-Mail mit weiteren Anweisungen.',
	'UserApprovalHint'			=> 'Die erfolgreiche Freischaltung deines Kontos wird dir in einer gesonderten E-Mail mitgeteilt. Bis dahin ist eine Anmeldung nicht möglich.',

	'UserApprovalPending'		=> 'Dein Konto ist noch nicht freigeschaltet.',
	'UserApprovalDenied'		=> 'Dein Konto wurde der Zugriff auf diese Seite verweigert.',

	'RegistrationApproved'		=> 'Registrierung wurde freigeschalten',
	'RegistrationDenied'		=> 'Registrierung abgelehnt',
	'PendingApproval'			=> 'Ausstehende Freischaltung',

	'UserApprovedInfo'			=> 'Dir wurde der Zugang zu %1 freigeschaltet.',
	'UserDeniedInfo'			=> 'Der Zugang zu %1 wurde abgelehnt.',

	'RegistrationThreshold'		=> 'Die Zeit zum Ausfüllen des Formulars sollte nicht %1 Sekunden unterschreiten.',
	'Language'					=> 'Sprache',

	// login panel
	'LoginWelcome'				=> 'Anmeldung',
	'CreateAccount'				=> 'Benutzerkonto anlegen',
	'RegistrationLink'			=> 'Registrierung',
	'LoginName'					=> 'Benutzer',
	'Password'					=> 'Passwort',
	'LoginButton'				=> 'Anmelden',
	'LoginLink'					=> 'Anmeldung',
	'PersistentCookie'			=> 'Angemeldet bleiben',
	'Session'					=> 'Sitzung',
	'SessionTip'				=> 'Parameter der aktuellen Sitzung',
	'SessionDuration'			=> 'Sitzungsdauer',
	'SessionDurationSession'	=> 'Browser-Sitzung',
	'SessionDurationDay'		=> '1 Tag',
	'SessionDurationWeek'		=> '1 Woche',
	'SessionDurationMonth'		=> '1 Monat',
	'LoggedInAs'				=> 'Du bist angemeldet als',

	'ClearCookies'				=> 'Alle Cookies löschen',
	'BindSessionIp'				=> 'Sitzung an die IP-Adresse binden',
	'BindSessionIpOn'			=> 'aktiviert (aktuelle IP %1)',
	'TrafficProtection'			=> 'Verbindungssicherheit',
	'SessionEnds'				=> 'Die aktuelle Sitzung endet',
	'LastVisit'					=> 'Dein letzter Besuch',

	'LoginIncorrect'			=> 'Der Benutzername oder das eingegebene Passwort ist ungültig.',
	'WelcomeBack'				=> 'Willkommen zurück, %1',
	'LoginAttemptsExceeded'		=> 'Du hast die maximal zulässige Zahl von Anmeldeversuchen überschritten.<br>Du musst nun deinen Benutzernamen und dein Passwort erneut eingeben sowie eine Sicherheitsabfrage beantworten.',

	// session notice
	'IPAddressChanged'			=> 'IP-Adresse hat sich geändert zu %1 (war %2)',

	'SessionReplay'				=> 'Die Sitzung wurde aufgrund von Wiederholung beendet.',
	'SessionObsolete'			=> 'Die Sitzung ist veraltet.',
	'SessionExpired'			=> 'Die Sitzung ist abgelaufen.',
	'SessionTimeout'			=> 'Die Sitzung wurde aufgrund von Zeitüberschreitung beendet.',
	'SessionInactivity'			=> 'Die Sitzung wurde wegen Inaktivität beendet.',
	'SessionUaChange'			=> 'Die Sitzung wurde aufgrund einer Änderung des Benutzeragenten beendet.',
	'SessionTLSChange'			=> 'Die Sitzung wurde aufgrund einer TLS-Änderung beendet.',
	'SessionIPChange'			=> 'Die Sitzung wurde aufgrund eines IP-Wechsels beendet.',

	// other
	'Guest'						=> 'Gast',
	'Everybody'					=> 'Alle',
	'Help'						=> 'Hilfe',
	'TopicSearchText'			=> 'Nur in Seitentiteln suchen',
	'WordprocessorVersion'		=> 'Textverarbeitungsversion',

	// notifications
	'EmailHello'				=> 'Hallo ',
	'EmailModerator'			=> 'Moderator',
	'WatchedPageChanged'		=> 'Seite wurde geändert ',
	'SomeoneChangedThisPage'	=> ' änderte eine von dir beobachtete Seite: ',
	'NewPageCreatedSubj'		=> 'Eine neue Seite',
	'NewPageCreatedBody'		=> 'Nutzer %1 hat eine neue Seite erstellt: ',
	'FileUploadedSubj'			=> 'Ein neuer Anhang',
	'FileUploadedBody'			=> 'Nutzer %1 hat eine neue Datei hochgeladen: ',
	'FileReplacedBody'			=> 'Nutzer %1 hat folgende Datei ersetzt: ',

	'ActionDenied'				=> 'Diese Aktion ist hier nicht erlaubt.',
	'TocTitle'					=> 'Inhalt ',
	'OuterLink2'				=> 'externer Verweis',
	'FileLink'					=> '',
	'PDFLink'					=> 'PDF Dokument',
	'RDFLink'					=> 'RDF Dokument',
	'EmailLink'					=> 'Schreibe E-Mail' . "\n" . '(E-Mailprogramm wird gestartet)',
	'JabberLink'				=> 'Chatte über XMPP (Jabber client  wird gestartet)',
	'PermaLink'					=> 'Permalink',
	'PermaLinkTip'				=> 'Permalink zu dieser Seitenversion',
	'PermaLink0Tip'				=> 'Permalink zu dieser Seite',

	'ShowTip'					=> 'In Ansichtsmodus zurückzukehren',
	'ShowText'					=> 'Ansicht',
	'WikieditAutocomplete'		=> 'Vervollständige Wikilinks mit Strg+Leertaste',
	'WikiEditInactiveJs'		=> 'Um WikiEdit nutzen zu können, aktiviere bitte JavaScript in deinem Browser.',
	'NumerateLinks'				=> 'Links in der Druckansicht extra ausweisen',
	'Comment'					=> 'Kommentar',
	'Comments0'					=> 'Kommentieren',
	'Comments1'					=> 'Kommentare lesen (1 Beitrag)',
	'CommentsN'					=> 'Kommentare lesen (%1 Beiträge)',
	'Comments'					=> 'Kommentare',
	'CommentHint'				=> '<a href="%1">Melde dich an</a> oder <a href="%2">erstelle ein Konto</a>, um einen Kommentar abzugeben.',
	'CommentEdited'				=> 'bearbeitet',
	'Links'						=> 'Links',
	'Version'					=> 'Version',

	// details formatter
	'ShowHideDetails'			=> 'Details',

	'PrivacyPolicy'				=> 'Datenschutz',
	'TermsOfUse'				=> 'Nutzungsbedingungen',
	'AcceptTermsOfUse'			=> 'Ich akzeptiere',

	'ShowComments'				=> 'Zeige Kommentare',
	'HideComments'				=> 'Verberge Kommentare',
	'AddComment'				=> 'Dieser Seite einen Kommentar hinzufügen:',
	'AddCommentTitle'			=> 'Titel des Kommentars:',
	'CommentTitleRe'			=> 'Re:',
	'AddCommentButton'			=> 'Kommentar hinzufügen',
	'HereLink'					=> 'hier',
	'PageHandlerMoreTip'		=> 'weitere',

	'ThemeCorrupt'				=> 'Layout ist beschädigt',
	'InvalidNamespace'			=> 'Es wurde ein ungültiger Namensraum angegeben.',
	'DoesNotExists'				=> 'Diese Seite existiert nicht.',
	'PromptCreate'				=> 'Möchtest du sie <strong><a href="%1">erstellen</a></strong>?',
	'RevisionHint'				=> 'Das ist eine alte Version von <a href="%1">%2</a> vom %3 bearbeitet durch %4.',
	'ReadAccessDenied'			=> 'Du bist nicht berechtigt, diese Seite zu lesen.',
	'ReadAccessDeniedHintGuest'	=> 'Um diese Seite zu lesen, solltest du dich anmelden.',
	'PageDeletedInfo'			=> 'Diese Seite wurde gelöscht.',
	'RevisionDeletedInfo'		=> 'Diese Revision wurde gelöscht.',
	'CommentDeletedInfo'		=> 'Dieser Kommentar wurde gelöscht.',

	'LastEditedBy'				=> 'Zuletzt bearbeitet von',
	'YouAreOwner'				=> 'Diese Seite gehört dir.',
	'Owner'						=> 'Besitzer:',
	'Nobody'					=> 'Niemand',
	'TakeOwnership'				=> 'Seite übernehmen',
	'FilesTip'					=> 'Dateianhänge verwalten',
	'FilesText'					=> 'Anhänge',
	'DeleteTip'					=> 'Seite löschen.',
	'DeleteCommentTip'			=> 'Kommentar löschen.',
	'DeleteText'				=> 'Löschen',
	'AclText'					=> 'Berechtigungen',
	'AclTip'					=> 'Berechtigungen bearbeiten',

	'PropertiesText'			=> 'Eigenschaften',
	'PropertiesTip'				=> 'Seiteneigenschaften bearbeiten',
	'EditTip'					=> 'Seite bearbeiten',
	'EditText'					=> 'Bearbeiten',
	'EditSection'				=> 'Abschnitt %1 bearbeiten',
	'EditSectionHint'			=> 'Abschnitt %1 von %2',
	'SectionHeadline'			=> 'Abschnitt',
	'EditCommentTip'			=> 'Kommentar bearbeiten.',
	'EditComment'				=> 'Kommentar bearbeiten',
	'ReplyComment'				=> 'Antworten',
	'ReplyCommentTip'			=> 'Antworte auf diesen Kommentar',
	'RevisionTip'				=> 'Seitenversionen anzeigen',
	'RevisionText'				=> 'Versionen',
	'ReferrersTip'				=> 'Liste von URLs, die auf diese Seite verweisen.',
	'ReferrersText'				=> 'Verweise',
	'ModerateTip'				=> 'Moderation von Themen und Forenbeiträgen',
	'ModerateText'				=> 'Moderieren',
	'SearchText'				=> 'Suchen: ',

	'AclUpdated'				=> 'Berechtigungen aktualisiert',
	'AclGaveOwnership'			=> ' und Besitzer geändert zu %1.',
	'AclNoNewOwner'				=> 'Der Besitz der Seite wurde nicht übertragen, da der Nutzer %1 nicht exsistiert.',
	'NewPageOwnership'			=> 'Seiten-Besitz übertragen',
	'YouAreNewOwner'			=> 'der frühere Besitzer %1 hat die folgende Seite ' . "\n" . ' auf dich übertragen',
	'PageOwnershipInfo'			=> '',
	'AclRead'					=> 'Lesen:',
	'AclWrite'					=> 'Schreiben:',
	'AclComment'				=> 'Kommentare:',
	'AclCreate'					=> 'Erstellen:',
	'AclUpload'					=> 'Hochladen:',
	'AclFor'					=> 'Berechtigungen für %1',
	'SetOwner'					=> 'Besitzer:',
	'OwnerDontChange'			=> 'keine Änderung',
	'AclAccessDenied'			=> 'Du bist nicht der Besitzer dieser Seite.',
	'AclSyntaxError'			=> 'Syntaxfehler in der Zugriffssteuerungsliste',
	'AclHelp'					=> '<code>*</code> - jeder hat das Recht<br>' .
									'<code>$</code> - nur registrierte Benutzer<br>' .
									'<code>!</code> - ein vorangestelltes Ausrufezeichen verweigert das jeweilige Recht <br>' .
									'<code>[BenutzerName]</code> - Namen des erlaubten Benutzer<br>' .
									'<code>[BenutzerGruppe]</code> - Namen der erlaubten Benutzergruppen (alias)<br>' .
									'<code>(eine leere Liste)</code> - nur der Seitenbesitzer hat das Recht',

	'AccessMode'				=> 'Sichtbarkeit',
	'AccessDenied'				=> 'verweigert',
	'AccessPublic'				=> 'öffentlich',
	'AccessRegistered'			=> 'registriert',
	'AccessPrivate'				=> 'privat',
	'AccessCustom'				=> 'benutzerdefiniert',

	// purge handler
	'PurgePage'					=> 'Seite bereinigen',
	'NotOwnerAndCantPurge'		=> 'Du bist nicht der Besitzer dieser Seite und du kannst diese nicht bereinigen.',
	'ReallyPurge'				=> 'ACHTUNG: Das Bereinigen der Seite kann nicht rückgängig gemacht werden!',
	'SelectPurgeOptions'		=> 'Wähle die benötigten Lösch-Optionen:',
	'PurgeComments'				=> 'Lösche alle Kommentare dieser Seite',
	'CommentsPurged'			=> 'Alle Kommentare wurden gelöscht.',
	'PurgeFiles'				=> 'Lösche alle Dateianhänge',
	'FilesPurged'				=> 'Alle Dateianhänge wurden gelöscht.',
	'PurgeRevisions'			=> 'Lösche alle Revisionen dieser Seite',
	'RevisionsPurged'			=> 'Revisionen wurden gelöscht.',
	'PurgeButton'				=> 'Löschen',

	// categories handler
	'Categories'				=> 'Kategorien',
	'CategoriesAssign'			=> 'zuweisen',
	'CategoriesEdit'			=> 'bearbeiten',
	'Category'					=> 'Kategorie',
	'CategoriesFor'				=> 'Kategorien für',
	'CategoriesTip'				=> 'Kategorien bearbeiten',
	'CategoriesText'			=> 'Kategorien',
	'CategoriesUpdated'			=> 'Kategorien aktualisiert',
	'CategoriesAlreadyExists'	=> 'Die Kategorie %1 gibt es bereits.',
	'CategoriesAdded'			=> 'Kategorie %1 erfolgreich hinzugefügt.',
	'CategoriesRenamed'			=> 'Kategorie erfolgreich umbenannt.',
	'CategoriesUngrouped'		=> 'Kategorie erfolgreich degruppiert.',
	'CategoriesGrouped'			=> 'Die Kategorie wurde der neuen Guppe hinzugefügt.',
	'NoMultilevelGrouping'		=> 'Mehrstufiges gruppieren von Kategorien ist nicht möglich.',
	'CategoriesDeleted'			=> 'Die Kategorie wurde aus der Datenbank und allen Seiten gelöscht.',
	'CategoriesAdd'				=> 'Neue Kategorie hinzufügen',
	'CategoryDescription'		=> 'Beschreibung',
	'CategoriesAddGrouped'		=> 'Kategorie gruppieren mit',
	'CategoriesAddGroupedNo'	=> 'Nicht gruppieren.',
	'CategoriesRename'			=> 'Kategorie %1 umbenennen zu',
	'CategoriesRenameInfo'		=> '* Hinweis: Änderung betrifft alle Seiten, die dieser Kategorie zugeordnet sind.',
	'CategoriesGroup'			=> 'Gruppiere Kategorien %1 mit',
	'CategoriesGroupInfo'		=> '* Wähle [keine Gruppe], um die Kategorie zu degruppieren.',
	'CategoriesNoGroup'			=> '[keine Gruppe]',
	'CategoriesDelete'			=> 'Willst du die Kategorie %1 wirklich entfernen?',
	'CategoriesDeleteInfo'		=> '* Hinweis: Die Änderung betrifft alle Seiten, die dieser Kategorie zugeordnet sind. Wenn das Wort eine Unterkategorie hat, wird diese nicht gelöscht, sondern nur entbündelt.',
	'CategoriesStoreInfo'		=> 'Um Kategorien zu einer Seite zuordnen, wähle die jeweiligen Kontrollkästchen.',
	'CategoriesStoreButton'		=> 'Speichere Kategorien',
	'CategoriesGroupButton'		=> 'Gruppieren',
	'CategoriesEditInfo'		=> 'Um die Kategorie-Liste zu bearbeiten, wähle das Optionsfeld.',
	'NoCategoriesForThisLang'	=> 'Für diese Sprache wurden noch keine Kategorien definiert.',
	'PagesCategory'				=> 'Seiten der Kategorie',
	'CategoryNotExists'			=> 'Kategorie gibt es nicht.',
	'CategoryEmpty'				=> 'Kategorie leer.',
	'NoCategorySelected'		=> 'Es wurden keine Kategorie ausgewählt.',
	'NoCategoriesAssigned'		=> 'Keine zugewiesenen Kategorien für diese Sprache.',
	'TagCloud'					=> 'Wortwolke',
	'PagesTaggedWith'			=> '%1 Seiten getaggt mit %2',
	'CategoriesOfCluster'		=> 'des Clusters',
	'TaggedWithTip'				=> 'Zeige mit %1 gekennzeichnet Seiten.',

	// source handler
	'SourceText'				=> 'Quelltext',
	'SourceTip'					=> 'Zeige den Wiki-Quelltext',
	'SourceCopyToClipboard'		=> 'In die Zwischenablage speichern',
	'SourceFor'					=> 'Quelltext der Seite %1',

	// Groups action
	'GroupsSearch'				=> 'Suche Gruppe',
	'GroupsNoMatching'			=> 'Keine passenden Gruppen gefunden. Versuche es mit weniger strengen Suchkriterien.',
	'GroupsOpenProfile'			=> 'Profil anzeigen',
	'GroupsName'				=> 'Gruppe',
	'GroupsMembers'				=> 'Mitglieder',
	'GroupsDescription'			=> 'Beschreibung',
	'GroupsCreated'				=> 'Erstellt',
	'GroupsNotFound'			=> 'Gruppe %2 nicht gefunden. Klicke <a href="%1">hier</a>, um zur Hauptliste zu gehen.',
	'GroupsProfile'				=> 'Profil',
	'GroupsList'				=> 'Zeige gesamte Liste der Gruppen',
	'GroupSpace'				=> 'Gruppenseite',

	'MetaUpdated'				=> 'Metadaten aktualisiert',

	'PreviewButton'				=> 'Vorschau',
	'Preview'					=> 'Vorschau',
	'Chars'						=> 'Zeichen',
	'PageBody'					=> 'Seiteninhalt',
	'EditNote'					=> 'Kommentar',
	'EditNoteMissing'			=> 'Zusammenfassung fehlt',
	'EditMinor'					=> 'Kleine Änderung',
	'MinorEditHide'				=> 'Kleine Änderungen ausblenden',
	'MinorEditShow'				=> 'Kleine Änderungen zeigen',
	'PostAnonymously'			=> 'Speichere anonym, ohne Angabe deines Benutzernamens',
	'NotifyMe'					=> 'Benachrichtige mich bei neuen Kommentaren und Änderungen auf der Seite',
	'OverwriteAlert'			=> 'ACHTUNG: Diese Seite wurde von jemandem geändert während du Sie selbst geändert hast.<br>Bitte kopiere deine Änderungen und ändere diese Seite erneut.',
	'TextDbOversize'			=> 'Achtung: Der Text überschreitet die Längenbegrenzung um %1 Zeichen. Bitte kürze den Text auf eine akzeptable Anzahl von Zeichen. Tipp: Den restlichen Text kann man auf einer separaten Seite unterbringen.',
	'EditingRevisionWarning'	=> 'Du bearbeitest nicht die aktuelle, sondern eine ältere Version dieser Seite. Wenn du speicherst, wird diese als aktuelle Version neu gespeichert. Eventuell später hinzugekommene Änderungen werden damit gelöscht.',
	'WriteAccessDenied'			=> 'Du hast kein Schreibrecht auf diese Seite.',
	'EmptyPage'					=> 'Die Seite ist leer - nicht gespeichert!',
	'EmptyComment'				=> 'Der Kommentar ist leer - nicht gespeichert!',
	'CommentAccessDenied'		=> 'Du hast keine Berechtigung diese Seite zu kommentieren.',
	'CommentFlooded'			=> 'Der Abstand zwischen der Veröffentlichung der Beiträge darf nicht weniger als %1 Sekunden betragen.',
	'CommentAdded'				=> 'Kommentar hinzugefügt.',
	'YouAreNowTheOwner'			=> 'Du bist jetzt der Besitzer dieser Seite.',
	'PageSaved'					=> 'Version %1 der Seite gespeichert.',
	'CommentSaved'				=> 'Kommentar gespeichert.',

	'RevisionsFor'				=> 'Versionsgeschichte von %1',
	'DefaultDiffMode'			=> 'Standard Diff-Modus',
	'DiffMode'		=> [
		'0'		=> 'vollständiger Vergleich',
		'1'		=> 'einfacher Vergleich',
		'2'		=> 'Quelltext',
		'3'		=> 'Nebeneinander',
		'4'		=> 'Inline',
		'5'		=> 'Zusammengeführt',
		'6'		=> 'Vereint',
		'7'		=> 'Kontext',
	],

	'PreviousEdit'				=> 'Vorherige Änderung',
	'NextEdit'					=> 'Nächste Änderung',

	'Diff'						=> 'Unterschied',
	'PreviousVersion'			=> 'Vorherige Version',
	'LatestVersion'				=> 'Aktuelle Version',
	'NextVersion'				=> 'Nächste Version',

	'ShowDifferencesButton'		=> 'Zeige Unterschiede',
	'CancelReturnButton'		=> 'Abbrechen und zurück zur Seite',
	'Comparison'				=> 'Versionsunterschiede von %1',
	'RevisionAsOf'				=> 'Version %1 vom',
	'SimpleDiffAdditions'		=> 'hinzugefügt:',
	'SimpleDiffDeletions'		=> 'entfernt:',
	'NoDifferences'				=> 'Keine Unterschiede.',
	'ReEditOldRevision'			=> 'Editiere diese alte Version erneut',

	'ExternalPages'				=> 'externe Seiten verlinkt zu %1 (%2) (<a href="%3">zeige Domänen</a>):',
	'ExternalPagesGlobal'		=> 'Sites, die auf dieses WackoWiki verlinkt haben (%2) (<a href="%1">zeige Domänen</a>):',
	'Last24Hours'				=> 'letzte 24 Stunden',
	'LastDays'					=> 'letzte %1 Tage',
	'DomainsSitesPages'			=> 'Domänen/Seiten verlinkt zu  %1 (%2)  (<a href="%3">zeige URLs</a>):',
	'DomainsSitesPagesGlobal'	=> 'Domänen/Seiten, die auf dieses WackoWiki verlinkt haben (<a href="%1">zeige URLs</a>):',
	'ViewReferrersPage'			=> 'zur Seite',
	'ViewReferrersPerPage'		=> 'nach Seite',
	'ViewReferrersByTime'		=> 'nach Zeit',
	'ViewReferrersGlobal'		=> 'global',
	'NoneReferrers'				=> 'keine Verweise',
	'NotOwnerCantDelete'		=> 'Du bist nicht der Besitzer dieser Seite und kannst sie deshalb nicht löschen.',

	// remove
	'RemovePage'				=> 'Seite löschen',
	'RemoveRevision'			=> 'Revision löschen',
	'RemoveComment'				=> 'Kommentar löschen',
	'RemoveCluster'				=> 'Lösche alle Seiten des Clusters',
	'RemoveDontKeep'			=> 'Speichere keine Sicherungs-Kopie der entfernten Seiten und Kommentare',
	'RemoveDontKeepRevision'	=> 'Speichere keine Sicherungs-Kopie der entfernten Revision',
	'RemoveDontKeepComment'		=> 'Speichere keine Sicherungs-Kopie des entfernten Kommentars',
	'RemoveDontKeepFile'		=> 'Speichere keine Sicherungs-Kopie der entfernten Datei',
	'ReferrersRemoved'			=> 'Referenzen gelöscht.',
	'LinksRemoved'				=> 'Links gelöscht.',
	'CategoriesRemoved'			=> 'Kategorien gelöscht.',
	'AclsRemoved'				=> 'Berechtigungen gelöscht.',
	'BookmarksRemoved'			=> 'Lesezeichen gelöscht.',
	'WatchesRemoved'			=> 'Beobachter gelöscht.',
	'CommentsRemoved'			=> 'Kommentare gelöscht.',
	'FilesRemoved'				=> 'Dateien der Seite gelöscht.',
	'PageRemoved'				=> 'Seite gelöscht.',
	'PageCachePurged'			=> 'Cache bereinigt.',
	'ClusterRemoved'			=> 'Alle Seiten des Cluster gelöscht.',
	'RevisionRemoved'			=> 'Revision %1 entfernt.',
	'RevisionsRemoved'			=> 'Revisionen gelöscht.',
	'ActionHaveNoUndo'			=> 'Diese Aktion kann nicht rückgängig gemacht werden.',

	// restore
	'PageRestored'				=> 'Seite wiederhergestellt.',
	'RevisionRestored'			=> 'Revision wiederhergestellt.',
	'LocalFilesRestored'		=> 'Angehängte Dateien wiederhergestellt.',

	'PrintVersion'				=> 'Druckversion',
	'PrintText'					=> 'Drucken',
	'LinkedPages'				=> 'Verlinkte Seiten:',
	'NoLinkedPages'				=> 'Keine verlinkten Seiten',
	'ReferringPages'			=> 'referenzierende Seiten:',
	'NoReferringPages'			=> 'Keine verweisenden Seiten',
	'Footnotes'					=> 'Fußnoten:',
	'Footnote'					=> 'Fußnote',
	'MostPopularPages'			=> 'Meistbesuchte Seiten',
	'MostCommentedPages'		=> 'Meistkommentierte Seiten',
	'NoAccessToSourcePage'		=> 'Du hast keine Leseberechtigung für den Quelltext.',
	'SourcePageDoesntExist'		=> 'Quelltext existiert noch nicht',
	'NotLoggedInThusEdited'		=> 'Um die Liste der von dir geänderten Seiten zu sehen, musst du dich anmelden.',
	'DidntEditAnyPage'			=> 'Du hast noch keine Seiten gändert.',
	'NoPagesFound'				=> 'Keine Seiten gefunden.',
	'MyChangesTitle1'			=> 'von dir geänderte Seiten, sortiert nach letzter Änderung',
	'MyChangesTitle2'			=> 'von dir geänderte Seiten, sortiert nach Alphabet',
	'OrderABC'					=> 'alphabetisch',
	'OrderCreation'				=> 'nach Erstellung',
	'OrderChange'				=> 'nach Änderung',
	'ListOwnedPages'			=> 'Liste deiner Seiten (alphabetisch sortiert)',
	'ListOwnedPages2'			=> 'Liste deiner Seiten (nach Datum sortiert)',
	'ListOwnedPages3'			=> 'Liste deiner Seiten (nach Änderung sortiert)',
	'NotLoggedInThusOwned'		=> 'Um die Liste deiner Seiten zu sehen, musst du dich anmelden.',
	'NoOrphaned'				=> 'Keine verwaisten Seiten gefunden. Gut.',
	'NoRecentComments'			=> 'Keine neuen Kommentare.',
	'LatestCommentBy'			=> 'zuletzt kommentiert von',
	'NoRecentlyCommented'		=> 'Keine Seite kürzlich kommentiert.',
	'NoDeletedPages'			=> 'Keine gelöschten Seiten gefunden.',
	'NoDeletedRevisions'		=> 'Keine gelöschten Revisionen gefunden.',
	'NoDeletedFiles'			=> 'Keine gelöschten Dateien gefunden.',
	'CommentsDisabled'			=> 'Kommentarfunktion ist nicht verfügbar.',

	'SearchResults'				=> 'Suchergebnisse für ',
	'NotFound'					=> 'nicht gefunden',
	'NoResultsFor'				=> 'Keine Ergebnisse für ',
	'SearchFor'					=> 'Suche nach:',
	'TopicSearchResults'		=> 'Suchergebnisse in Titeln für ',
	'NotFoundInTopics'			=> 'nicht in Titeln gefunden',
	'FilterLangNotAvailable'	=> 'Die gewählte Sprache ist nicht verfügbar!',

	'PostedBy'					=> 'eingetragen von',
	'ThisIsCommentOn'			=> 'Das ist ein Kommentar zu',
	'At'						=> 'am',
	'To'						=> 'zu',
	'By'						=> 'von',
	'From'						=> 'von',
	'For'						=> 'zu',
	'ReturnToCommented'			=> 'zurück zur kommentierten Seite',
	'AbandonedComment'			=> 'Die Seite, zu der dieser Kommentar gehört, existiert nicht mehr!',

	'PagesLinkingTo'			=> 'Seiten, die verweisen auf',
	'NoPageLinkingTo'			=> 'Keine Seite verweist auf',
	'NoWantedPages'				=> 'Keine offenen Seiten. Gut.',
	'RemoveWatch'				=> 'Beobachte die Seite nicht mehr',
	'SetWatch'					=> 'Beobachte die Seite',
	'WatchText'					=> 'Beobachten',
	'UnwatchText'				=> 'Nicht beobachten',
	'UserSettingsStored'		=> 'Benutzereinstellungen gespeichert!',
	'LoggedOut'					=> 'Du bist jetzt abgemeldet.',
	'LoggedOutAuto'				=> 'Aus Sicherheitsgründen wurde deine Sitzung beendet. Bitte melde dich erneut an.',

	// user settings
	'EmailConfirmResent'		=> 'E-Mail-Bestätigungscode wurde erneut zugesand.',
	'EmailConfirmNotSent'		=> 'Senden des Bestätigungscodes nicht möglich: E-Mail wurde nicht angegeben!',
	'Hello'						=> 'Hallo',
	'UserName'					=> 'Benutzername',
	'EmailAddress'				=> 'E-Mail-Adresse',
	'RealName'					=> 'Vollständiger Name',
	'MenuItemsShown'			=> 'Gezeigte Menüpunkte',
	'RecordsPerPage'			=> 'Datensätze pro Seite',
	'DoShowComments'			=> 'Zeige Kommentare',
	'DoubleclickEditing'		=> 'Bearbeiten durch Doppelklick',
	'UpdateSettingsButton'		=> 'Speichere Einstellungen',

	'AccountDisabled'			=> 'Dein Konto ist deaktiviert oder gesperrt.',
	'WrongPassword'				=> 'Falsches Passwort!',
	'ConfirmPassword'			=> 'Passwort bestätigen',
	'Email'						=> 'E-Mailadresse',
	'MustBeWikiName'			=> 'Benutzername muss im <a href="https://wackowiki.org/doc/Doc/Deutsch/WikiName" target="_blank">WikiName</a>-Format sein!',
	'SpecifyEmail'				=> 'Du musst eine E-Mailadresse angeben.',
	'NotAEmail'					=> 'Das sieht nicht nach einer E-Mailadresse aus.',
	'EmailTaken'				=> 'Die angegebene E-Mail-Adresse wird bereits verwendet.',
	'EmailDomainNotAllowed'		=> 'Die E-Mail %1 ist nicht in der Liste der erlaubten Domains.',
	'PasswordsDidntMatch'		=> 'Passwörter stimmen nicht überein.',
	'SpacesArentAllowed'		=> 'Leerzeichen sind im Passwort nicht zulässig.',
	'ListMyPages'				=> 'Liste deiner Seiten',
	'ListMyChanges'				=> 'Liste deiner Änderungen',
	'ListMyWatches'				=> 'Liste der beobachteten Seiten',
	'ListMyChangesWatches'		=> 'Änderungen an den von dir beobachteten Seiten',
	'SeeListOfPages'			=> 'Zeige Liste meiner Seiten (MeineSeiten) und die Seiten, die ich editiert haben (MeineAenderungen).',
	'AddBookmark'				=> 'Lesezeichen für aktuelle Seite setzen',
	'RemoveBookmark'			=> 'Entferne Lesezeichen für aktuelle Seite',

	'YourLanguage'				=> 'Wähle Sprache',
	'ShowSpaces'				=> 'Zeige Leerzeichen in WikiNamen',
	'WrongPage4Redirect'		=> 'Umleitung funktioniert wegen falschen Umleitungsparametern nicht',
	'RedirectsToItself'			=> 'Die Seite leitet auf auf sich selbst weiter.',
	'ReallyDeletePage'			=> 'Willst du wirklich diese Seite löschen?<br>Diese Aktion kann nicht rückgängig gemacht werden!<br><br>WARNUNG: Mit dieser Seite werden alle zur Seite gehörigen Versionen, Kommentare, Anhänge, Berechtigungen und Verweise gelöscht.',
	'CommentForWatchedPage'		=> 'neuer Kommentar zur Seite ',
	'SomeoneCommented'			=> ' kommentierte die von dir beobachtete Seite: ',
	'AlertReferringPages'		=> 'Auf diese Seite wird von folgenden Seiten verwiesen',

	'AccountDelete'				=> 'Konto löschen',
	'AccountDeleteConfirm'		=> 'Bist du sicher, dass du das Konto löschen willst?',
	'AccountDeleted'			=> 'Konto erfolgreich gelöscht',
	'AccountDeleteHeader'		=> 'Lösche Konto %1',
	'AccountDeleteInfo'			=> 'Von den von dir erstellten Daten (z.B. E-Mail, Einstellungen, Anhänge, Wiki-Einträge) werden so weit wie möglich gelöscht. Beachte jedoch, dass Daten wie Dateien und Wiki-Einträge nicht gelöscht werden können, ohne die Arbeit der anderen Benutzer zu beeinträchtigen. Diese Daten werden daher einem Konto namens %1 zugewiesen. Da die Daten eines jeden gelöschten Kontos diesem Konto wieder zugeordnet werden, ist es nicht möglich, die von dir erstellten Daten von den Daten eines anderen gelöschten Kontos zu unterscheiden.',
	'AccountDeleteWarning'		=> 'Das Löschen des Kontos kann nicht rückgängig gemacht werden.',
	'AccountDeleteHint'			=> 'Dein Konto wird aus dem System entfernt. Es wird daher nicht mehr möglich sein, dich mit deinem derzeitigen Nutzernamen und Passwort anzumelden. Bei Bedarf, kannst du dir über die von der Anwendung zur Verfügung gestellten Mechanismen ein neues Konto anlegen.',
	'AccountDeleteVerify'		=> 'Gib deinen Nuzernamen ein, um das Löschen deines Kontos zu bestätigen. Zusätzlich wird nach dem Absenden des Formulars dein Password abgefragt.',

	'MarkRead'					=> 'Als gelesen markieren',
	'CurrentTime'				=> 'aktuelle Zeit',
	'Created'					=> 'erstellt',
	'Modified'					=> 'geändert',

	'EditIcon'					=> 'Bearbeiten',
	'TreeClusterTitle'			=> 'Baumansicht des Clusters %1',
	'TreeSiteTitle'				=> 'Baumansicht der Seite',
	'TreeEmpty'					=> '%1 hat keine Unterseiten',
	'TreeEmptyLevels'			=> '%1 hat keine Unterseiten für die angegebene Baumtiefe. Erhöhe den Wert für die Tiefe.',
	'TreeTooBig'				=> 'zu viele Unterseiten',

	// clone handler
	'ClonePage'					=> 'Klone Seite',
	'CloneText'					=> 'Klonen',
	'CloneName'					=> 'Neuer Name für die den Klon dieser Seite',
	'CloneButton'				=> 'Klonen',
	'PageCloned'				=> 'Seite %1 geklont.',
	'ClonedFrom'				=> 'Geklont von %1.',
	'MassClone'					=> 'Klone gesamten Cluster',
	'MassCloning'				=> 'Klone Cluster.',
	'CloneCannotRead'			=> 'Seite %1 lässt sich nicht lesen.',
	'CloneCannotCreate'			=> 'Seite %1 lässt sich nicht erstellen.',

	'SortComment'				=> 'Kommentare sortieren',
	'SortCommentAsc'			=> 'Neueste unten',
	'SortCommentDesc'			=> 'Neueste oben',

	'RenamePage'				=> 'Seite umbenennen',
	'RenameText'				=> 'Umbenennen',
	'RenameTip'					=> 'Seite umbenennen',
	'NewName'					=> 'Neuer Name für diese Seite',
	'AlreadyExists'				=> 'Seite %1 existiert bereits.',
	'AlreadyNamed'				=> 'Diese Seite heißt bereits %1.',
	'PageRenamed'				=> 'Seite wurde umbenannt.',
	'NewNameOfPage'				=> 'Neuer Name dieser Seite: ',
	'NotOwnerCantRename'		=> 'Du bist nicht der Besitzer dieser Seite und kannst sie daher nicht umbenennen.',
	'NeedRedirect'				=> 'Weiterleitung von der alten zur neuen Seite einrichten.',
	'RedirectCreated'			=> 'Weiterleitung von der Seite %1 zur neuen Seite eingerichtet.',

	'UserSettings'				=> 'Benutzereinstellungen',
	'UserSettingsGeneral'		=> 'Allgemein',
	'UserSettingsNotifications'	=> 'Mitteilungen',

	'NotifyMinorEdit'			=> 'Benachrichtigung auch bei kleinen Änderungen',
	'NotifyPageEdit'			=> 'Änderung',
	'NotifyComment'				=> 'Kommentar',
	'NotifyOff'					=> 'Aus',
	'NotifyAlways'				=> 'Immer',
	'NotifyPending'				=> 'Ausstehend',
	'NotifyDigest'				=> 'Sammeln',
	'NotifyPendingPageTip'		=> 'Es wird nur für die erste Änderung einer beobachteten Seite eine Benachrichtigung gesendet.',
	'NotifyPendingCommentTip'	=> 'Es wird nur für den ersten Kommentar einer beobachteten Seite eine Benachrichtigung gesendet.',
	'NotifyPendingTip'			=> 'Die Benachrichtigung wird automatisch wieder aktiviert, wenn die aktuelle Version der Seite aufgerufen wird.',

	'FurtherPending'			=> 'Es wird keine weitere Benachrichtigungen für den Fall weiterer Änderungen geben, es sei denn, die Seite wird wieder besucht.',

	'UserSettingsEmailMe'		=> 'Sende E-Mail wenn ...',

	'UserSettingsExtended'		=> 'Erweitert',
	'UserSettingsOther'			=> 'weitere Einstellungen',
	'UserSpace'					=> 'Benutzerseite',
	'ChooseTheme'				=> 'Wähle ein Layout',

	'CreatePage'				=> 'Erstelle diese Seite',
	'CreateNewPage'				=> 'Neue Seite erstellen',
	'CreateNewPageText'			=> 'Erstellen',
	'CreateNewPageTip'			=> 'Neue Seite erstellen',

	'CreateRandomPage'			=> 'Beliebige Seite:',
	'CreateSubPage'				=> 'Unterseite in diesem Cluster:',
	'CreatePageParentCluster'	=> 'Seite im übergeordneten Cluster:',
	'CreatePageDenied'			=> 'Du verfügst nicht über die erforderlichen Zugriffsrechte.',
	'CreatePageDeniedAddress'	=> 'Du hast nicht das Recht, um die Seite unter dieser Adresse zu erstellen.',
	'PageAlreadyExists'			=> 'Die Seite %1 ist unter der Adresse bereits vorhanden.',
	'PageAlreadyExistsEdit'		=> 'Möchtest du sie %1',
	'PageAlreadyExistsEdit2'	=> 'bearbeiten',
	'PageAlreadyExistsEditDenied'	=> 'Du kannst sie nicht bearbeiten',

	'SimilarPagesExists'		=> 'Ähnliche Seiten wie %1 gibt es bereits:',
	'SimilarPagesHint'			=> 'Es gibt bereits ähnliche Seiten zu %1:',

	'PageReservedWord'			=> 'Du kannst %1 als Teil der Adresse nicht verwenden, weil es ein reserviertes Wort ist.',
	'UserReservedWord'			=> 'Benutzernamen können nicht %1 enthalten, da es ein reserviertes Wort ist.',

	'DontRedirect'				=> 'Keine automatische Weiterleitung erlauben, obwohl eine gesetzt ist.',
	'SendWatchEmail'			=> 'Bestätigunsmail senden, wenn jemand (außer dir) Seiten verändert, die du beobachtest',
	'AllowIntercom'				=> 'Erlaube persönliche Nachrichten von Nutzern des Systems',
	'AllowMassemail'			=> 'Administratoren dürfen mir Nachrichten per E-Mail schicken',
	'HideLastSession'			=> 'Letzte Sitzung verbergen',
	'ValidateIP'				=> 'Binde Sitzung an IP-Adresse',
	'AnonymousPub'				=> 'Vorzugsweise anonym veröffentlichen (den Namen verstecken)',
	'PageMoved'					=> 'Diese Seite wurde verschoben. Sie ist jetzt zu finden unter',
	'RedirectedFrom'			=> 'Weitergeleitet von %1',
	'RedirectedTo'				=> 'Weitergeleitet nach',
	'CurrentPassword'			=> 'Derzeitiges Passwort',
	'NewPassword'				=> 'Neues Passwort',
	'YouWantChangePassword'		=> 'Passwort ändern',
	'ChangePasswordButton'		=> 'Passwort ändern',
	'PasswordChanged'			=> 'Passwort geändert',
	'EmailWelcome'				=> 'Du bist registriert bei ',
	'EmailRegistered'			=> 'Du hast dich bei %1 registriert.' . "\n" . 'Dein Benutzername lautet: %2' . "\n\n",
	'EmailVerify'				=> 'Um Benachrichtigungen zu erhalten, bestätige bitte diese E-Mail. Folge diesem Link' . "\n" . '%1',
	'EmailRegisteredLogin'		=> 'Bitte kehre zum Wiki zurück und melde dich mit deinem neuen Benutzernamen und Passwort an.',
	'EmailRegisteredIgnore'		=> 'Wenn du dich nicht registriert hast, ignoriere diese Nachricht, es wird nichts passieren.',
	'EmailDoNotReply'			=> 'NICHT AUF DIESE NACHRICHT ANTWORTEN',
	'EmailReverify'				=> 'Jemand (vielleicht du) hat deine E-Mailadresse als Bestätigungsadresse bei %1 angegeben.' . "\n" . 'Dein Benutzername lautet: %2'."\n\n" . 'Um Benachrichtigungen zu erhalten, bestätige bitte diese E-Mail. Folge diesem Link:' . "\n" . '%3' . "\n\n",
	'EmailConfirm'				=> 'Bitte bestätige deine E-Mail.',
	'EmailConfirmed'			=> 'E-Mail wurde erfolgreich bestätigt.',
	'EmailNotConfirmed'			=> 'E-Mail konnte nicht bestätigt werden. Dies könnte an einen falschen Bestätigung-Code liegen oder die E-Mail-Adresse wurde möglicherweise bereits bestätigt. Du kannst prüfen ob die E-Mail bereits bestätigt wurde indem du dich anmeldst und deinen Status auf deiner %1 Seite einsiehst.',
	'EmailNotVerified'			=> 'E-Mail wurde nicht bestätigt!',
	'EmailNotVerifiedDesc'		=> 'Du erhälst keine Benachrichtigung über Änderungen oder Kommentare von beobachteten Seiten, ' .
									'Nachrichten von anderen Nutzern, ebenso wirst du nicht in der Lage sein <strong> ein vergessenes Passwort wieder herzustellen</strong>, ' .
									'bis deine E-Mail-Adresse bestätigt wurde, indem du den Link in der dir zugesendeten E-Mail folgst. ' .
									'Wenn innerhalb weniger Tage nach der Registrierung du keine E-Mail erhalten hast, kannst du sie erneut anfragen, klicke dazu ',

	'ForgotPasswordHint'		=> 'Benutzername und E-Mailadresse angeben,' . "\n" . 'du bekommst dann eine E-Mail mit weiteren Anweisungen.',
	'ForgotPassword'			=> 'Passwort vergessen?',
	'UserNotFound'				=> 'Ein Benutzer mit diesem Namen oder E-Mailadresse wurde nicht gefunden.',
	'NotConfirmedEmail'			=> 'Deine E-Mailadresse ist noch nicht bestätigt<br>E-Mails können nicht an unbestätigte E-Mailadressen verschickt werden.',
	'EmailForgotSubject'		=> 'Neues Passwort für ',
	'EmailForgotMessage'		=> 'Jemand (vielleicht du) hat sein Passwort für %1 vergessen.' . "\n" . 'Dein Benutzername lautet: %2' . "\n\n" . 'Um dein Passwort zu ändern, folge diesem Link oder kopiere ihn in die Adresszeile deines Browsers.' . "\n" . '%3' . "\n\n",
	'CodeWasSent'				=> 'Eine E-Mail mit Informationen zu deinem Passwort wurde versandt.',
	'WrongCode'					=> 'Falscher Code',
	'ChangePasswordForUser'		=> '%1\'s Passwort Änderung',

	'Watchers'					=> 'Beobachter für %1',
	'WatchersFor'				=> 'Beobachter für',
	'NoWatchers'				=> 'Keine Beobachter für %1',
	'NotOwnerToViewWatchers'	=> 'Du bist nicht der Besitzer dieser Seite und kannst die Liste der Beobachter nicht einsehen.',

	// thumbnail
	'TbnError'					=> 'Fehler beim Erstellen des Vorschaubildes: %1',
	'TbnImageAreaTooBig'		=> 'Datei mit Abmessungen größer als %1',
	'TbnImageMissing'			=> 'Datei scheint zu fehlen: %1',

	// admin_recovery action
	'GenerateRecoveryHash'		=> 'Generiere den Passwort-Hash für dein <code>recovery_password</code>',

	// import action
	'ImportTo'					=> 'Import in Cluster:',
	'ImportWhat'				=> 'XML-Datei die importiert werden soll:',
	'ImportButton'				=> 'Importieren',
	'ImportSuccess'				=> 'Erfolgreich importiert.',
	'ImportFailed'				=> 'Import fehlgeschlagen.',
	'ImportHint'				=> 'Bitte gib einen Cluster an, in den du importieren möchtest, keine relative Adressierung.',
	'ImportAttention'			=> 'Achtung! Überschreibt die gleichen Seiten im Cluster.',
	'ImportNote'				=> 'Importierte Seite',

	// mywatches action
	'WatchedPages'				=> 'Liste aller Seiten, die du auf Änderungen beobachtest',
	'UnwatchedPages'			=> 'Liste aller Seiten, die du nicht beobachtest',
	'NoWatchedPages'			=> 'Du hast keine beobachteten Seiten.',
	'NoUnwatchedPages'			=> 'Du beobachtest alle Seiten.',
	'ViewWatchedPages'			=> 'Zeige beobachtete Seiten',
	'ViewUnwatchedPages'		=> 'Zeige unbeobachtete Seiten',
	'NotLoggedInWatches'		=> 'Du bist nicht angemeldet, daher lässt sich die Liste deiner beobachteten Seiten nicht ermitteln.',

	// mychangeswatches action
	'MyChangesWatches'			=> 'Liste aller von dir beobachteten Seiten, welche seit deiner letzten Änderung zwischenzeitlich von anderen bearbeitet wurden',
	'ResetChangesWatches'		=> 'Liste der Änderungen zurücksetzen',
	'NoChangesWatches'			=> 'Unter deinen beobachteten Seiten sind keine Änderungen...',

	// whatsnew action
	'NewCommentAdded'			=> 'Kommentar hinzugefügt',
	'NewFileAdded'				=> 'Datei hinzugefügt',
	'NewPageCreated'			=> 'Neue Seite erstellt',
	'NewRevisionAdded'			=> 'Seite geändert',
	'Cluster'					=> 'Cluster',
	'PageDeleted'				=> 'Seite gelöscht',
	'CommentDeleted'			=> 'Kommentar gelöscht',
	'FileDeleted'				=> 'Anhang gelöscht',

	// users action
	'UsersSearch'				=> 'Benutzersuche',
	'UsersOpenProfile'			=> 'Profil anzeigen',
	'UsersNoMatching'			=> 'Keine passenden Benutzer gefunden. Versuche es mit weicheren Suchkriterien.',
	'UsersName'					=> 'Benutzername',
	'UsersPages'				=> 'Seiten',
	'UsersChanges'				=> 'Änderungen',
	'UsersSubscription'			=> 'Abonnement',
	'UsersWatches'				=> 'Beobachten',
	'UsersComments'				=> 'Kommentare',
	'UsersUploads'				=> 'Uploads',
	'UploadQuota'				=> 'Kontingent belegt',
	'UploadQuotaTip'			=> 'Upload-Kontingent',
	'UsersLogins'				=> 'Anmeldungen',
	'UsersRevisions'			=> 'Revisionen',
	'UsersSignup'				=> 'Anmeldung',
	'UsersLastSession'			=> 'Letzter Besuch',
	'UsersNotFound'				=> 'Benutzer %2 nicht gefunden. Klicke <a href="%1">hier</a>, um zur Hauptliste zu gehen.',
	'UsersProfile'				=> 'Profil',
	'UsersContact'				=> 'Kontakt',
	'UsersList'					=> 'Zeige gesamte Liste der Benutzer',
	'UsersNA'					=> '[nicht gesetzt]',
	'UsersNA2'					=> '[keine]',
	'UsersSignupDate'			=> 'Beitrittsdatum',
	'UsersGroupMembership'		=> 'Gruppen-Mitgliedschaft',
	'UsersPersonalInfo'			=> 'Persönliche Infos',
	'UsersOwnedPages'			=> 'Eigene Seiten:',
	'UsersCommentsPosted'		=> 'Kommentare erstellt:',
	'UsersFilesUploaded'		=> 'Dateien hochgeladen:',
	'UsersRevisionsMade'		=> 'Revisionen erstellt:',
	'UsersDocsSortName'			=> '[Sortiere nach Name]',
	'UsersDocsSortCreation'		=> '[Sortiere nach Erstellungsdatum]',
	'UsersChangesSortAsc'		=> '[Sortiere aufsteigend]',
	'UsersChangesSortDesc'		=> '[Sortiere absteigend]',
	'UsersSessionNA'			=> '[nicht aufgezeichnet]',
	'UsersSessionHidden'		=> '[verborgen]',
	'IntercomSubject'			=> 'Betreff:',
	'IntercomMessage'			=> 'Nachricht:',
	'IntercomCopy'				=> 'Sende mir eine Kopie',
	'IntercomSubjectN'			=> '[Beginne ein neues Thema]',
	'IntercomDisabled'			=> 'Du möchtest oder kannst keine privaten Nachrichten empfangen.',
	'IntercomHint'				=> 'Bitte melde dich zuerst an und folge dem Link erneut, wenn du die persönliche Nachricht beantworten möchtest, die du erhalten hast.',
	'IntercomDesc'				=> 'Hinweis: Sendet eine persönliche Nachricht an die E-Mail-Adresse des Empfänger ohne Offenlegung deiner Adresse. Der Empfänger hat die Möglichkeit dir zu antworten, indem er das gleiche Formular auf deiner Profilseite nutzt.',
	'PMOversized'				=> 'Die Länge der Nachricht überschreitet die maximal zulässige Größe um %1. Bitte kürze deine Mitteilung und übermittle sie erneut.',
	'PMFlooded'					=> 'Der Abstand zwischen dem Senden von persönlichen Nachrichten sollte nicht kleiner sein als %1 Sekunden.',
	'PMSent'					=> 'Persönliche Nachricht wurde erfolgreich an den Nutzer gesendet.',
	'PMBody'					=> 'Diese Nachricht wurde dir durch den Benutzer %1 geschickt.',
	'PMBodyCopy'				=> 'Du habst die folgende Nachricht an den Benutzer %1 gesendet.',
	'PMReply'					=> 'Um auf diese Email-Nachricht zu antworten, klicke den folgenden Link (verwende nicht die Schaltfläche \'Antworten\' in deinem Mailprogramm):',
	'PMNotLoggedIn'				=> 'Du bist nicht im System angemeldet und kannst daher keine persönlichen Nachrichten an andere Nutzer übermitteln.',

	// admin_replace action
	'ReplaceText'				=> 'Text ersetzen',
	'TextOriginal'				=> 'Vorhandener Text:',
	'TextReplacement'			=> 'Neuer Text:',
	'ReplaceTextRegex'			=> 'Platzhalter und reguläre Ausdrücke verwenden',
	'Namespace'					=> 'Namensraum:',
	'ReplaceTextCluster'		=> 'Suche und ersetze nur innerhalb dieses Clusters:',
	'ReplaceTextEditPages'		=> 'Ersetze Text im Seiteninhalt',
	'ReplaceTextEditComments'	=> 'Ersetze Text in Kommentaren',
	'ReplaceTextEditTitles'		=> 'Ersetze Text im Titel der Seite',
	'ReplaceTextGiveTarget'		=> 'Du musst eine Zeichenkette angeben, die ersetzt werden soll.',
	'ReplaceTextNoNamespace'	=> 'Mindestens ein Namensraum muss ausgewählt werden.',
	'ReplaceTextNoDifference'	=> 'Es gibt keinen Unterschied zwischen Ersetzungstext und Zieltext.',
	'ReplaceTextNoOption'		=> 'Du musst mindestens eine Ersetzungsoption wählen.',
	'ReplaceTextPagesEdit'		=> 'Ersetzte %1 mit %2 im Text der folgenden %3 Seiten:',
	'ReplaceTextTitlesEdit'		=> 'Ersetzte %1 mit %2 im Titel der folgenden %3 Seiten:',
	'ReplaceTextReplace'		=> 'Ersetzen',
	'ReplaceTextSuccess'		=> '%1 wurde in %3 Seiten durch %2 ersetzt.',
	'ReplaceTextNoMatch'		=> 'Es wurde keine Seite gefunden, die den Text %1 enthält.',
	'ReplaceTextNoTitleMatch'	=> 'Es wurde keine Seite gefunden, deren Titel den Text %1 enthält.',
	'ReplaceTextTitleTooBig'	=> 'Original- oder Ersatztext ist zu groß für den Titel.',
	'ReplaceTextReturn'			=> 'Zurück zum Formular',
	'ReplaceTextWarning'		=> 'Warnung: %1 Seiten enthalten bereits den zu ersetzenden Textteil %2. Sofern du nun die Ersetzungen durchführst, ist eine spätere Unterscheidung zwischen den nunmehr zu ersetzenden und den bereits vorhandenen Textteilen nicht mehr möglich.',
	'ReplaceTextBlankWarning'	=> 'Warnung: Da der zu ersetzende Textteil leer ist, kann der Vorgang nicht rückgängig gemacht werden. Möchtest du dennoch fortfahren?',
	'ReplaceTextEditSummary'	=> 'Textersetzung: %1 → %2',
	'InvertSelection'			=> 'Auswahl umkehren',

	// Properties
	'PropertiesFor'				=> 'Eigenschaften für Seite %1',
	'MetaTag'					=> 'Tag',
	'MetaTitle'					=> 'Titel',
	'MetaKeywords'				=> 'Schlüsselwörter',
	'MetaDescription'			=> 'Beschreibung',
	'On'						=> 'An',
	'Off'						=> 'Aus',
	'Registered'				=> 'Registriert',
	'MetaComments'				=> 'Kommentare anzeigen',
	'MetaFiles'					=> 'Dateileiste anzeigen',
	'MetaToc'					=> 'Inhaltsverzeichnis anzeigen',
	'MetaIndex'					=> 'Cluster Leiste anzeigen',
	'MetaIndexMode'				=> 'Ebenen anzeigen',
	'MetaIndexFull'				=> 'Baum',
	'MetaIndexUpper'			=> 'obere',
	'MetaIndexLower'			=> 'untere',
	'MetaHtml'					=> 'HTML Unterstützung für Seite',
	'MetaSafeHtml'				=> 'Unsicheres HTML filtern',
	'MetaTypografica'			=> 'Typografischer Korrektor',
	'MetaNoIndex'				=> 'Vom Suchmaschinen-Index ausnehmen',
	'SettingsID'				=> 'ID der Seite',
	'SettingsSize'				=> 'Größe',
	'SettingsSizeTip'			=> 'Quelltext / zusammengestellt',
	'SettingsCreated'			=> 'Erstellt',
	'SettingsCurrent'			=> 'Geändert',
	'SettingsTotalRevs'			=> 'Revsionen',
	'SettingsTotalComs'			=> 'Kommentare',
	'SettingsWatchers'			=> 'Beobachter',
	'SettingsHits'				=> 'Aufrufe',
	'SettingsText'				=> 'Einstellungen',
	'SettingsEdit'				=> 'Bearbeiten',
	'SettingsRevisions'			=> 'Versionen',
	'SettingsClone'				=> 'Klonen',
	'SettingsRename'			=> 'Umbenennen',
	'MassRename'				=> 'Ganzen Cluster umbenennen',
	'SettingsRemove'			=> 'Löschen',
	'SettingsPurge'				=> 'Bereinigen',
	'SettingsModerate'			=> 'Moderieren',
	'SettingsPermissions'		=> 'Berechtigungen',
	'AclForEntireCluster'		=> 'Berechtigungen für ganzen Cluster ändern',
	'SettingsAttachments'		=> 'Anhänge',
	'SettingsUpload'			=> 'Dateien hochladen',
	'SettingsCategories'		=> 'Kategorien',
	'SettingsLanguages'			=> 'Sprachen',
	'SettingsReferrers'			=> 'Verweise',
	'SettingsWatch'				=> 'Beobachten',
	'SettingsLatex'				=> 'LaTeX Version',
	'SettingsXML'				=> 'Export als XML',
	'NeedToChangeLang'			=> 'Die gewählte Seitensprache %1 wird nicht unterstützt und muss geändert werden.',
	'SetLang'					=> 'Sprache dieser Seite',
	'SetMenuLabel'				=> 'Menü-Label',
	'SetShowMenuLabel'			=> 'Zeige in der Navigation',

	// upload
	'UploadFiles'				=> 'Dateien hochladen',
	'UploadFor'					=> 'Datei hochladen:',
	'UploadButton'				=> 'Hochladen',
	'UploadGlobalText'			=> 'für alle Benutzer',
	'UploadGlobal'				=> 'global',
	'UploadLocalText'			=> 'nur für Benutzer, die diese Seite sehen dürfen',
	'UploadAsName'				=> 'Hochladen als (optional):',
	'UploadOverwrite'			=> 'Bestehende Dateien überschreiben',
	'FileDesc'					=> 'Beschreibung:',
	'UploadForbidden'			=> 'Du hast keine Berechtigung, hier Dateien hochzuladen.',
	'UploadOverwriteDenied'		=> 'Nur der Dateieigentümer oder der Administrator kann die Datei %1 überschreiben.',
	'UploadNoFile'				=> 'Keine Datei gefunden... aus irgendeinem Grund.',
	'UploadMaxSizeReached'		=> 'Datei ist zu groß!',
	'UploadDirNotWritable'		=> 'Datei-Verzeichnis ist nicht schreibbar!',
	'UploadNotAPicture'			=> 'Nur das Hochladen von Bildern ist erlaubt.',
	'UploadEmptyExtension'		=> 'Der Dateiname und auch die Erweiterung dürfen nicht leer sein.',
	'FilenameTooLong'			=> 'Dateinamen dürfen nicht größer als 240 Bytes sein.',
	'BannedFiletype'			=> '%1 ist ein nicht erlaubter Dateityp.',
	'PermittedFiletype'			=> 'Erlaubte Dateitypen:',
	'UploadMimeMismatch'		=> 'Dateierweiterung %1 stimmt nicht mit dem MIME-Typ (%2) überein.',
	'UploadBadMime'				=> 'Dateien mit dem MIME-Typ %1 dürfen nicht hochgeladen werden.',
	'FileIsDuplicate'			=> 'Die hochgeladene Datei ist ein exaktes Duplikat der aktuellen Version.',
	'FileHasDuplicate'			=> 'Diese Datei ist ein Duplikat der folgenden Dateien:',

	'UploadMaxFileQuota'		=> 'Dein Speicherplatz ist voll. Du kannst keine weiteren Dateien hochladen.',
	'UploadDone'				=> 'Datei erfolgreich hochgeladen',
	'UploadFileForbidden'		=> 'Datei-Zugriff verweigert',
	'UploadTitle'				=> 'Dateien zu dieser Seite',
	'UploadTitleGlobal'			=> 'Dateien, die global verwendet werden können',

	'UploadFile'				=> 'Hochladen',
	'UploadMax'					=> 'Nicht mehr als ',
	'UploadUsedStorage'			=> 'Speicherplatz in Verwendung',

	// attachments
	'Attachments'				=> 'Anhänge',
	'Attachment'				=> 'Anhang',
	'AttachmentsToPage'			=> 'zur Seite',
	'AttachmentsToCluster'		=> 'Cluster',
	'AttachmentsByTime'			=> 'nach Zeit',
	'AttachmentsGlobal'			=> 'global',
	'AttachmentsAll'			=> 'alle',
	'AttachmentsLinked'			=> 'verwendet',

	'FileViewProperties'		=> 'anzeigen',
	'FileViewPropertiesTip'		=> 'Zeige Metadaten der Datei',
	'FileEditProperties'		=> 'bearbeiten',
	'FileEditPropertiesTip'		=> 'Bearbeite Metadaten dieser Datei',
	'FileEditedMeta'			=> 'Metadaten der Datei aktualisiert',
	'FileEditDenied'			=> 'Du hast keine Berechtigung, diese Datei zu bearbeiten.',
	'FileLabel'					=> 'kennzeichnen',
	'FileLabelTip'				=> 'Kennzeichne diese Datei',
	'FileRemove'				=> 'löschen',
	'FileRemovedFromDB'			=> 'Datei aus der Datenbank gelöscht',
	'FileRemovedFromFS'			=> 'Datei im Dateisystem gelöscht',
	'FileRemovedFromFSError'	=> 'Löschen der Datei fehlgeschlagen!',
	'FileRemoveConfirm'			=> 'Sicher, dass diese Datei gelöscht werden soll?',
	'FileRemoveDenied'			=> 'Du hast keine Berechtigung, diese Datei zu löschen.',
	'FileNotFound'				=> 'Datei nicht gefunden',

	'FileSearch'				=> 'Dateisuche:',
	'UploadBy'					=> 'Hochgeladen von:',
	'FileAdded'					=> 'Hinzugefügt:',
	'FileModified'				=> 'Geändert:',
	'FileSize'					=> 'Größe:',
	'FileDimension'				=> 'Maße:',
	'MimeType'					=> 'MIME-Typ:',
	'FileName'					=> 'Name:',
	'FileCaption'				=> 'Bildunterschrift:',
	'FileAuthor'				=> 'Urheber:',
	'FileSource'				=> 'Quelle:',
	'FileSourceUrl'				=> 'URL:',
	'FileAttachedTo'			=> 'Angehängt an:',
	'FileSyntax'				=> 'Syntax:',
	'FileAbsolutePath'			=> 'absoluter Pfad',
	'FileRelativePath'			=> 'relativer Pfad',
	'FileUsage'					=> 'Dateiverwendung:',
	'FileUsageText'				=> 'Folgenden Seiten verwenden diese Datei:',
	'NoFileUsage'				=> 'Diese Datei wird auf keiner Seite verwendet.',

	'FileSortExt'				=> 'Erweiterung',
	'FileSortName'				=> 'Name',
	'FileSortSize'				=> 'Größe',
	'FileSortTime'				=> 'Hinzugefügt',

	'SortBy'					=> 'Sortiere nach',
	'Ascending'					=> 'aufsteigend',
	'Decending'					=> 'absteigend',

	'Files0'					=> 'Dateien (0)',
	'Files1'					=> 'Dateien (1)',
	'FilesN'					=> 'Dateien (%1)',
	'Files'						=> 'Dateien',
	'File'						=> 'Datei',
	'ShowFiles'					=> 'Zeige Dateien',
	'HideFiles'					=> 'Verberge Dateien',
	'DoShowFiles'				=> 'Zeige Dateiliste',
	'NoAttachments'				=> 'Keine Anhänge zum Anzeigen.',

	'RegistrationLang'			=> 'Sprachauswahl',
	'InvalidWikiName'			=> 'Seitenname ist ungültig',
	'InvalidUserName'			=> 'Benutzername ist ungültig',
	'Bookmarks'					=> 'Lesezeichen',
	'ReallyDeleteComment'		=> 'Willst du den Kommentar wirklich löschen?<br>Diese Aktion kann nicht rückgängig gemacht werden!',
	'ReallyDeleteRevision'		=> 'Willst du diese Revision wirklich löschen?<br>Diese Aktion kann nicht rückgängig gemacht werden!',

	'RegistrationClosed'		=> 'Registrierung ist nicht verfügbar. Kontaktiere bei Interesse den Administrator.',
	'AclAreYouSure'				=> 'Du bist dabei die ACLs von dieser Seite und aller ihrer Unterseiten zu ändern. Fortfahren?',

	'BookmarkDeleteSelected'	=> 'Lösche Ausgewählte',
	'BookmarkMark'				=> 'Markieren',
	'BookmarkNumber'			=> 'Nr.',
	'BookmarkNone'				=> 'Du hast keine Lesezeichen gesetzt.',
	'BookmarkTitle'				=> 'Lesezeichen Titel',
	'BookmarkPage'				=> 'Seite',
	'BookmarkSaveChanges'		=> 'Speichere Änderungen',
	'BookmarksAddPage'			=> 'Setze ein Lesezeichen für die folgende Seite',
	'BookmarkAlreadyExists'		=> 'Das Lesezeichen gibt es bereits.',

	'PoweredBy'					=> 'Betrieben mit',

	'MassRenaming'				=> 'Ganzen Cluster umbenennen',
	'MassNewName'				=> 'Einen neuen Namen für diesen Cluster eingeben',
	'MassNeedRedirect'			=> 'Weiterleitung von den alten zu den neuen Seiten einrichten.',

	// pagination
	'ToOverview'				=> 'Zur Übersicht',
	'ToThePage'					=> 'Zu Seite:',
	'Next'						=> 'weiter',
	'Prev'						=> 'zurück',
	'NextAcr'					=> 'weiter',
	'PrevAcr'					=> 'zurück',
	'Back'						=> 'zurück',

	// filter
	'Filter'					=> 'Filter',
	'OptionalFilters'			=> 'Optionale Filter:',
	'Any'						=> 'Alle',

	// My Groups
	'UserGroups'				=> 'Nutzergruppen',
	'MyGroups'					=> 'Gruppenzugehörigkeiten',
	'Group'						=> 'Gruppe',
	'Groups'					=> 'Gruppen',

	// license action
	'DistributedUnder'			=> 'Dieses Werk ist lizenziert unter einer ',
	'AuthorsDisplayHint'		=> 'Die Liste der Autoren wird angezeigt, wenn die Seite gespeichert wurde.',
	'AnonymousUsers'			=> 'Anonyme Benutzer',
	'License'					=> 'Lizenz',
	'LicenseArray'				=> [
		'1'		=> 'Namensnennung - Keine Bearbeitungen',
		'2'		=> 'Namensnennung - Nicht kommerziell - Weitergabe unter gleichen Bedingungen',
		'3'		=> 'Namensnennung - Nicht kommerziell - Keine Bearbeitungen',
		'4'		=> 'Namensnennung - Weitergabe unter gleichen Bedingungen',
		'5'		=> 'Namensnennung - Nicht kommerziell',
		'6'		=> 'Namensnennung',
		'7'		=> 'CC0 1.0 Universal',
		'8'		=> 'GNU Free Documentation License',
		'9'		=> 'gemeinfrei',
		'10'	=> 'Alle Rechte vorbehalten',
	],
	'LicenseMeta'				=> [
		'1'		=> 'Öffentliche Domäne',
		'2'		=> 'Bestimmte Rechte vorbehalten',
		'3'		=> 'Alle Rechte vorbehalten',
	],

	// Cache
	'ClearCache'				=> 'Zwischenspeicher leeren',
	'CacheCleared'				=> 'Zwischenspeicher geleert.',
	'ConfigCache'				=> 'Config-Zwischenspeicher',
	'FeedCache'					=> 'Feed-Zwischenspeicher',
	'PageCache'					=> 'Seiten-Zwischenspeicher',
	'SQLCache'					=> 'SQL-Zwischenspeicher',
	'TemplateCache'				=> 'Template-Zwischenspeicher',
	'ThumbCache'				=> 'Vorschaubild-Zwischenspeicher',

	// Embed
	'EmbedNoURL'				=> 'Bitte gib die Adresse der Ressource mit dem Parameter url an. (z.B. {{embed url="https://example.com/embed/video.mp4"}} )',

	// Feed
	'FeedTitle'					=> 'Feed Titel',
	'FeedMulti'					=> 'Multi-Feed',
	'FeedNoURL'					=> 'Bitte gib einen Feed mit dem Parameter url an. (z.B. {{feed url="https://example.com/feed.xml"}}',
	'FeedError'					=> 'Kann Feed nicht laden oder parsen',
	'FeedSource'				=> 'Quelle:',
	'FeedXMLTip'				=> '',

	// XML / RSS autodiscovery
	'ChangesXMLTitle'			=> ' - Letzte Änderungen',
	'ChangesXML'				=> 'Letzte Änderungen im ',
	'CommentsXMLTitle'			=> ' - Letzte Kommentare',
	'CommentsXML'				=> 'Letzte Kommentare im ',
	'NewsXMLTitle'				=> ' - Aktuelle Nachrichten',
	'NewsXML'					=> 'Aktuelle Nachrichten zu ',
	'RevisionXMLTip'			=> 'Seitenversionen im XML-Format ansehen.',
	'CommentsXMLTip'			=> 'Letzte Kommentare im XML-Format ansehen.',
	'ChangesXMLTip'				=> 'Letzten Änderungen im XML-Format ansehen.',
	'NewsXMLTip'				=> 'Letzten Nachrichten im XML-Format ansehen.',
	'RevisionsXML'				=> 'Revisionen von ',
	'ExportClusterXML'			=> 'Export des ganzen Clusters von ',
	'AccessDeniedXML'			=> 'Du hast keine Berechtigung für den Zugriff auf diese Seite.',

	'ChangesFeed'				=> 'Änderungen',
	'CommentsFeed'				=> 'Kommentare',
	'NewsFeed'					=> 'Nachrichten',
	'RevisionsFeed'				=> 'Versionen von ',

	'LastModification'			=> 'Letzte Änderung',

	// Captcha
	'Captcha'					=> 'Bitte schreibe das Wort welches du im Bild lesen kannst',
	'CaptchaFailed'				=> 'Du hast das Captcha-Wort nicht korrekt eingegeben. Bitte versuche es erneut.',
	'CaptchaReload'				=> 'Neues Captcha',
	'CaptchaReloadWarning'		=> 'Kann das Captcha Bild nicht neu laden, du musst die Seite neu laden um das zu tun.',

	// news
	'News'						=> 'Nachrichten',
	'NewsName'					=> 'Titel:',
	'NewsNoName'				=> 'Du habst vergessen eine Schlagzeile hinzuzufügen.',
	'NewsNotAvailable'			=> 'Keine Nachrichten verfügbar.',
	'NewsNoClusterDefined'		=> 'Kein Nachrichten-Cluster definiert.',
	'NewsDiscuss'				=> 'Diskutiere diesen Artikel...',

	// blog
	'BlogNewTopic'				=> 'Erstelle einen neuen Beitrag',
	'NoPostAvailable'			=> 'Noch kein Beitrag verfügbar.',

	// Review
	'Reviewer'					=> 'Prüfer',
	'Reviewed'					=> 'Geprüft',
	'Review'					=> 'Ungeprüft',
	'ReviewedBy'				=> 'gesichtet von',
	'RemoveReview'				=> 'Revidiere diese Version',
	'SetReview'					=> 'Vidiere diese Version',
	'SetAsReviewed'				=> 'Seite als geprüft gesetzt',
	'SetAsUnreviewed'			=> 'Seite als ungeprüfed gesetzt',

	// word filter
	'PotentialSpam'				=> 'Fehler: möglicher Spam erkannt',

	// moderation handler
	'Moderation'				=> 'Moderation',
	'Topics'					=> 'Themen',
	'ModerateSection'			=> 'Bereich / Seite ',

	'NotModerator'				=> 'Du hast nicht die Berechtigung diese Seite / das Thema zu moderieren',
	'ModerateDeleteTopic'		=> 'Lösche Thema / Seite',
	'ModerateDeletePosts'		=> 'Lösche Kommentare',
	'ModerateMove'				=> 'Verschieben',
	'ModerateSplit'				=> 'Trenne / Verschiebe Kommentare',
	'ModerateMerge'				=> 'Zusammenführen',
	'ModerateLock'				=> 'Sperren',
	'ModerateUnlock'			=> 'Entsperren',
	'ModerateAccept'			=> 'Bestätigen',
	'ModerateDeleteConfirm'		=> 'Bist du dir sicher das du folgende Themen <strong>löschen</strong> willst?',
	'ModerateRenameConfirm'		=> 'Gib einen neuen Titel für die gewählte Seite an',
	'ModerateRenameExists'		=> 'Es gibt bereits eine Seite mit dem gleichen Namen! Wähle einen anderen Seiten-Namen.',
	'ModerateRename1Only'		=> 'Hinweise: Es wird nur die erste gewählte Seite umbenannt!',
	'ModerateMovesConfirm'		=> 'Wähle den Ziel-Cluster in welchen das Forum verschoben werden soll',
	'ModerateMoveConfirm'		=> 'Wähle ein Forum oder gib einen Cluster an in welchen du die Themen verschieben willst. Um die Seite in die Root zu verschieben, schreibe &quot;/&quot;',
	'ModeratePgMoveConfirm'		=> 'Gib den Namen des Clusters an, in welchen du die Seite verschieben willst. Um die Seite in die Root zu verschieben, schreibe &quot;/&quot;',
	'ModerateMoveExists'		=> 'Vorgang abgebrochen: In dem Bereich gibt es bereits Themen mit dem gleichen Namen %1.<br>Falls die ausgewählten Themen dennoch verschoben werden sollen, benenne diese bitte erst um.',
	'ModerateMoveNotExists'		=> 'Diese Seite / Cluster gibt es nicht. Bitte überprüfe den Namen und versuche es erneut.',
	'ModerateMergeConfirm'		=> 'Wähle ein Thema, unter welchem die bestehenden zusammengeführt werden sollen',
	'ModerateMerge2Min'			=> 'Zum Zusammenführen musst du mindestens zwei Themen wählen!',
	'ModerateComDelConfirm'		=> 'Bist du dir sicher das du  %1 %2 <strong>löschen</strong> willst?',
	'ModerateComment'			=> 'Kommentar',
	'ModerateComments'			=> 'Kommentare',
	'ModerateSplitNewName'		=> 'Gib den Namen für das zu trennende Thema an und wähle ein Trennungs-Schema',
	'ModerateSplitPageName'		=> 'Gib den Namen der Seite / des Themas an, in welche die abgetrennten Kommentare verschoben werden sollen, und wähle ein Trennungs-Schema',
	'ModerateSplitAllAfter'		=> 'Trenne alle Kommentare nach dem ersten ausgewählten (diesen eingeschlossen)',
	'ModerateSplitSelected'		=> 'Trenne nur ausgewählte Kommentare (gesamt %1)',
	'ModerateUserProfile'		=> 'Profil',
	'ModerateNoItemChosen'		=> 'Bitte wähle mindestens einen Datensatz über die Set-Taste.',

	'ModerateSection2'			=> 'moderiere Bereich',
	'ModerateTopicsDeleted'		=> 'Ausgewählte Themen wurden erfolgreich gelöscht.',
	'ModerateTopicsRelocated'	=> 'Ausgewählte Themen wurden erfolgreich verschoben.',
	'ModerateTopicsRenamed'		=> 'Thema erfolgreich umbenannt.',
	'ModerateTopicsMerged'		=> 'Ausgewählte Themen wurden erfolgreich zusammengeführt.',
	'ModerateTopicsBlocked'		=> 'Ausgewählte Themen wurden erfolgreich gesperrt',
	'ModerateTopicsUnlocked'	=> 'Ausgewählte Themen wurden erfolgreich entsperrt.',
	'ModerateTopicDeleted'		=> 'Ausgewähltes Thema wurde erfolgreich gelöscht.',
	'ModeratePageMoved'			=> 'Seite erfolgreich verschoben.',
	'ModerateTopicRenamed'		=> 'Thema erfolgreich umbenannt.',
	'ModerateTopicBlocked'		=> 'Thema erfolgreich gesperrt',
	'ModerateTopicUnlocked'		=> 'Thema erfolgreich entsperrt.',
	'ModerateCommentsDeleted'	=> 'Ausgewählte Kommentare wurden erfolgreich gelöscht.',
	'ModerateCommentsSplit'		=> 'Ausgewählte Kommentare wurden erfolgreich einem neuem Thema zugewiesen.',
	'ModerateCommentsSplitFailed'	=> 'Hinweis: Aus irgendeinem Grund ist das Abtrennen der ausgewählen Kommentare zu einem neuen Thema gescheiterte.<br>Normalerweise sollte dies nicht geschehen, setze daher den Site-Administrator von dem Ereignis in Kenntnis.<br>Als Vorsichtsmaßnahme hat es die Kommentare in ihrer ursprünglichen Form belassen.',
	'ModerateCommentsMoved'		=> 'Ausgewählte Kommentare erfolgreich zur angegebenen Seite verschoben.',

	// forum
	'ForumSubforums'			=> 'Forum',
	'ForumTopic'				=> 'Thema',
	'ForumTopics'				=> 'Themen',
	'ForumPosts'				=> 'Beiträge',
	'ForumReplies'				=> 'Antworten',
	'ForumAuthor'				=> 'Autor',
	'ForumViews'				=> 'Zugriffe',
	'ForumCreated'				=> 'Erstellt',
	'ForumComments'				=> 'Kommentare',
	'ForumLastComment'			=> 'Letzter Kommentar',
	'ForumNoComments'			=> 'Keine Kommentare',
	'ForumNoTopics'				=> 'In diesem Forum gibt es keine Themen oder Beiträge.',
	'ForumNewTopic'				=> 'Beginne eine neue Diskussion',
	'ForumTopicName'			=> 'Neues Thema:',
	'ForumTopicSubmit'			=> 'Thema erstellen',
	'ForumNoTopicName'			=> 'Gib einen Namen für die neue Seite an.',
	'ForumNewPosts'				=> 'neuer Beitrag',
	'ForumLocked'				=> 'Bereich gesperrt',
	'ForumUpdated'				=> 'aktualisiert',
	'ForumNoClusterDefined'		=> 'Kein Formum-Cluster definiert.',
	'ForumOutsideCluster'		=> 'Die Aktion %1 befindet sich nicht im Forum-Cluster.',

	// password complexity
	'PwdCplxShort'				=> 'Passwort ist zu kurz.',
	'PwdCplxEquals'				=> 'Passwort enthält den Benutzernamen.',
	'PwdCplxWeak'				=> 'Kennwort entspricht nicht der Komplexitäts-Anforderungen.',
	'PwdCplxDesc1'				=> 'Anforderungen an das Kennwort: ',
	'PwdCplxDesc2'				=> 'Das Passwort sollte nicht weniger als %1 Zeichen sein',
	'PwdCplxDesc3'				=> 'darf nicht deinen Benutzernamen enthalten ',
	'PwdCplxDesc4'				=> 'sollte bestehen aus ',
	'PwdCplxDesc41'				=> 'Buchstaben und Zahlen',
	'PwdCplxDesc42'				=> 'Groß- und Kleinbuchstaben und Zahlen',
	'PwdCplxDesc43'				=> 'Groß- und Kleinbuchstaben, Ziffern und nicht-alphabetische Zeichen',
	'PwdCplxDesc5'				=> 'Es können alle Buchstaben, Zahlen und Sonderzeichen, außer Leerzeichen, verwendet werden.',

	'PasswordTooShort'			=> 'Passwort zu kurz.',
	'PasswordTooCommon'			=> 'Das Passwort wird zu häufig verwendet.',
	'PasswordSameAsUsername'	=> 'Dein Passwort entspricht deinem Benutzernamen.',
	'PasswordSameAsEmail'		=> 'Dein Passwort entspricht deiner E-Mail-Adresse.',

	'Timezone'					=> 'Zeitzone',

	'LanguageArray'	=> [
		'bg' => 'Bulgarisch',
		'da' => 'Dänisch',
		'de' => 'Deutsch',
		'el' => 'Griechisch',
		'en' => 'Englisch',
		'es' => 'Spanisch',
		'et' => 'Estnisch',
		'fa' => 'Persisch',
		'fr' => 'Französisch',
		'hi' => 'Hindi',
		'hu' => 'Ungarisch',
		'it' => 'Italienisch',
		'ja' => 'Japanisch',
		'ko' => 'Koreanisch',
		'nl' => 'Niederländisch',
		'pl' => 'Polnisch',
		'pt' => 'Portugiesisch',
		'ru' => 'Russisch',
		'zh' => 'Chinesisch',
		'zh-tw' => 'Chinesisch',
	],

	'AccountStatus'				=> 'Kontostatus',
	'AccountStatusArray' => [
		'0' => 'aktiv',
		'1' => 'ausstehend',
		'2' => 'gesperrt',
		'3' => 'inaktiv',
	],

	'JustNow'		=> 'gerade eben',
	'MinuteAgo'		=> 'vor einer Minute',
	'MinutesAgo'	=> 'vor %1 Minuten',
	'HourAgo'		=> 'vor einer Stunde',
	'HoursAgo'		=> 'vor %1 Stunden',
	'DayAgo'		=> 'gestern',
	'DaysAgo'		=> 'vor %1 Tagen',
	'WeekAgo'		=> 'vor einer Woche',
	'WeeksAgo'		=> 'vor %1 Wochen',
	'MonthAgo'		=> 'vor einem Monat',
	'MonthsAgo'		=> 'vor %1 Monaten',
	'YearAgo'		=> 'vor einem Jahr',
	'YearsAgo'		=> 'vor %1 Jahren',

	'InAMoment'		=> 'gleich',
	'InAMinute'		=> 'in einer Minute',
	'InMinutes'		=> 'in %1 Minuten',
	'InAnHour'		=> 'in einer Stunde',
	'InHours'		=> 'in %1 Stunden',
	'Tomorrow'		=> 'morgen',
	'InDays'		=> 'in %1 Tagen',
	'InAWeek'		=> 'in einer Woche',
	'InWeeks'		=> 'in %1 Wochen',
	'InAMonth'		=> 'in einem Monat',
	'InMonths'		=> 'in %1 Monaten',
	'InAYear'		=> 'in einem Jahr',
	'InYears'		=> 'in %1 Jahren',

	// norm multiples
	'ByteDecimalShort'			=> ['B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
	'ByteDecimalLong'			=> ['Byte', 'Kilobyte', 'Megabyte', 'Gigabyte', 'Terabyte', 'Petabyte', 'Exabyte', 'Zettabyte', 'Yottabyte'],
	'ByteBinaryShort'			=> ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'],
	'ByteBinaryLong'			=> ['Byte', 'Kibibyte', 'Mebibyte', 'Gibibyte', 'Tebibyte', 'Pebibyte', 'Exbibyte', 'Zebibyte', 'Yobibyte'],
	'PixelDecimalShort'			=> ['px', 'KP', 'MP', 'GP', 'TP', 'PP', 'EP', 'ZP', 'YP'],
	'PixelDecimalLong'			=> ['pixel', 'Kpx', 'Mpx', 'Gpx', 'Tpx', 'Ppx', 'Epx', 'Zpx', 'Ypx'],

	// loading error
	'UnknownAction'				=> 'Unbekannte Aktion',
	'UnknownMethod'				=> 'Unbekannte Methode',
	'FormatterNotFound'			=> 'Formatierer %1 nicht gefunden',

	// log
	'LogAdminLoginSuccess'		=> 'Erfolgreiche Anmeldung im Verwaltungs-Panel',
	'LogAdminLogout'			=> 'Abmeldung aus dem Verwaltungs-Panel',
	'LogAdminLoginFailed'		=> '!!Gescheiterter Anmeldeversuch ins Verwaltungs-Panel!!',
	'LogAdminLoginLocked'		=> 'Anmeldung ins Verwaltungs-Panel gesperrt',
	'LogUserCookieForged'		=> '!!**Ein Versuch sich mit einem gefälschten Cookie ##%1## anzumelden**!!',
	'LogInvalidFormToken'		=> 'Möglicher CSRF-Angriff im Gange: %1',
	'LogRemovedPage'			=> '!!Seite entfernt ##%1## (Nutzer %2)!!',
	'LogRemovedCluster'			=> '!!**Cluster** ##%1## entfernt (Nutzer %2)!!',
	'LogRemovedRevision'		=> '!!Revision ##%3## der Seite [[/%1]] entfernt (Nutzer %2)!!',
	'LogRemovedComment'			=> '!!Kommentar von %3 auf Seite [[/%1]] entfernt (Nutzer %2)!!',
	'LogRemovedFile'			=> '!!Datei ##%2## von Seite [[/%1]] entfernt!!',
	'LogRemovedAllComments'		=> '!!Alle Kommentare der Seite [[/%1]] entfernt!!',
	'LogRemovedAllRevisions'	=> '!!Alle Revisionen der Seite [[/%1]] entfernt!!',
	'LogRemovedAllFiles'		=> '!!Alle Dateien, angehängt an [[/%1]] entfernt!!',
	'LogTopicLocked'			=> 'Forum Thema gesperrt [[/%1]]',
	'LogTopicUnlocked'			=> 'Forum Thema entsperrt [[/%1]]',
	'LogAclUpdated'				=> 'Berechtigungen von Seite aktualisiert [[/%1]]',
	'LogOwnershipChanged'		=> 'Besitz der Seite [[/%1]] wurde auf den Nutzer ##%2## übertragen',
	'LogUserLoginFailed'		=> '!!Gescheiterter Versuch sich mit ##~%1## anzumelden!!',
	'LogClonedPage'				=> 'Seite ##%1## nach [[/%2]] geklont ',
	'LogRenamedPage'			=> 'Seite ##%1## nach [[/%2]] umbenannt',
	'LogRenamedPage2'			=> '. Link zur neuen Seite auf der alten gesetzt',
	'LogSplittedPage'			=> 'Kommentare auf der Seite [[/%1]] zu Seite [[/%2]] abgetrennt',
	'LogMergedPages'			=> 'Seite %1 mit Seite [[/%2]] zusammengeführt',
	'LogUserPasswordReminded'	=> 'Nutzer ##%1## hat den Vorgang zur Passwort-Wiederherstellung auf die E-Mail-Adresse ##%2## angefordert',
	'LogUserPasswordRecovered'	=> 'Nutzer ##%1## hat sein vergessenes Passwort erfolgreich wieder hergestellt',
	'LogUserPasswordChanged'	=> 'Nutzer ##%1## hat erfolgfreich sein Passwort geändert.',
	'LogUserPasswordMismatch'	=> '!!Nutzer ##%1## scheiterte sein Passwort zu ändern: Passwort stimmt nicht mit dem aktuellen überein!!',
	'LogUserIPSwitched'			=> 'Unerlaubter Wechsel der IP-adresse den Nutzers %1 von %2 zu %3',
	'LogPageImported'			=> 'Seite importiert [[/%1]]',
	'LogSaveNoRights'			=> 'Keine ausreichenden Rechte um die Seite [[/%1]] zu speichern.',
	'LogPageCreated'			=> 'Neue Seite erstellt [[/%1]]',
	'LogPagePropertiesUpdated'	=> 'Seiteneigenschaften aktualisiert [[/%1]]',
	'LogPageOwnershipClaimed'	=> 'Du hast den Besitz der der Seite [[/%1]] beansprucht',
	'LogFileUploadedLocal'		=> 'Zu Seite [[/%1]] neue Datei hochgeladen ##%2## (Größe %3)',
	'LogFileUploadedGlobal'		=> 'Neue Datei in globalen Ordner hochgeladen ##%2## (Größe %3)',
	'LogPMSent'					=> 'Persönliche Nachricht ##%1## -> ##%2## erfolgreich gesendet',
	'LogUserSimilarName'		=> 'Es gab einen Versuch sich unter einen bereits bestehenden Namen zu registrieren: ##%1##',
	'LogUserEmailNotAllowed'	=> 'E-Mail ##%1## nicht in der Liste der erlaubten Domains',
	'LogRegisterTiming'			=> 'Registrierung fehlgeschlagen, Zeitschwelle für das Formular ist ##%1## Sekunden (war ##%2##)',
	'LogUserRegistered'			=> 'Ein neuer Nutzer wurde erfolgreich registriert ##%1## (##%2##)',
	'LogUserEmailActivated'		=> 'Erfolgreiche E-Mail ##%1## von Nutzer ##%2## aktiviert',
	'LogCommentPosted'			=> '[[/%1 Neuer Kommentar]] wurde zu Seite [[/%2]] hinzugefügt',
	'LogUserLoginOK'			=> 'Nutzer ##%1## hat sich erfolgreich im System angemeldet',
	'LogUserLoggedOut'			=> 'Nutzer ##%1## hat sich erfolgreich aus dem System abgemeldet',
	'LogUserSessionContinued'	=> 'Nutzer ##%1## continued to suspend the session',
	'LogUserSettingsUpdate'		=> 'Nutzer ##%1## hat seite Nutzereinstellungen aktualisiert',
	'LogPageEdited'				=> 'Seite bearbeitet [[/%1]]',
	'LogCommentEdited'			=> 'Kommentar bearbeitet [[/%1]]',
	'LogUpdatedFileMeta'		=> 'Datei Metadaten für ##%2## von Seite [[/%1]] aktualisiert',
	'LogUpdatedFileCategories'	=> 'Datei Kategorien für ##%2## von Seite [[/%1]] aktualisiert',

	'LogXmlSitemapGenerated'	=> 'XML Seitenverzeichnis erstellt',
	'LogReferrersPurged'		=> 'Wartung: Referrer gelöscht',
	'LogRevisionsPurged'		=> 'Wartung: veraltete Seitenrevisionen gelöscht',
	'LogDeletedPagesPurged'		=> 'Wartung: entfernte Seiten gelöscht',
	'LogSystemLogPurged'		=> 'Wartung: Systemprotokoll gelöscht',
	'LogCachedPagesPurged'		=> 'Wartung: Seiten-Cache gelöscht',
	'LogSqlCachePurged'			=> 'Wartung: zwischengespeicherte SQL-Ergebnisse gelöscht',
	'LogExpiredTokensPurged'	=> 'Wartung: abgelaufene Cookie-Token gelöscht',
	'LogErrorSplitComments'		=> 'Fehler beim Trennen der Kommentare vom Thema [[/%1]], das neue Thema ##%2## konnte nicht erstellt werden',
	'LogCategoriesUpdated'		=> 'Kategorien zur Seite [[/%1]] aktualisiert',
	'LogCategoryCreated'		=> 'Neue Kategorie ##%1## erstellt',
	'LogCategoryRenamed'		=> 'Kategorie ##%1## umbenannt zu ##%2##',
	'LogCategoryDebundled'		=> 'Kategorie ##%1## entbündelt',
	'LogCategoryGrouped'		=> 'Kategorie ##%1## mit Wort ##%2## gruppiert',
	'LogCategoryRemoved'		=> 'Kategorie ##%1## aus der Datenbank entfernt',

	'ErrorMinPHPVersion'		=> 'Die PHP Version muss größer sein als <strong>' . PHP_MIN_VERSION . '</strong>,' .
									' der Server scheint die Version <strong>' . PHP_VERSION . '</strong> zu nutzen.' .
									'  Aktualisiere bitte PHP auf eine neuere Version, damit  WackoWiki ordnungsgemäß funtioniert.',

];
