<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$wacko_translation = [

	// language
	'lang_scheme'	=> [
		'name'		=> 'Japanese',
		'code'		=> 'ja',
		'dir'		=> 'ltr',
		'locale'	=> 'ja_JP.UTF-8',
	],

	// common
	'AddButton'					=> '追加',
	'ArchiveButton'				=> 'Archive',
	'CancelButton'				=> 'キャンセル',
	'ContinueButton'			=> '続行',
	'ConvertButton'				=> '変換',
	'CreateButton'				=> '作成',
	'DeleteButton'				=> '削除',
	'RemoveButton'				=> '削除',
	'RenameButton'				=> '名前を変更',
	'ResetButton'				=> 'リセット',
	'RestoreButton'				=> '復元',
	'SaveButton'				=> '保存',
	'SearchButton'				=> '検索',
	'SendButton'				=> 'Send',
	'SetButton'					=> 'Set',
	'SubmitButton'				=> '送信',
	'UpdateButton'				=> '更新',

	'FormInvalid'				=> 'The submitted form was invalid. Try submitting again.',
	'UnitPixel'					=> 'ピクセル',
	'Number'					=> 'Number',

	// logged in panel
	'AccountText'				=> 'アカウント',
	'AccountTip'				=> 'アカウントの設定',
	'AdminText'					=> '管理',
	'AdminTip'					=> '管理パネル',
	'LogoutLink'				=> 'ログアウト',
	'LogoutButton'				=> 'ログアウト',
	'LogoutAreYouSure'			=> 'Do you really want to log out?',

	// registration panel
	'RegistrationWelcome'		=> 'アカウント作成:',
	'RegistrationButton'		=> 'アカウントを作成',
	'UserNameOwned'				=> 'This username is already registered. Please choose another.',
	'SiteRegistered'			=> 'You have successfully registered on the site %1.',
	'RegistrationEmailInfo'		=> 'A valid email address. All emails from the system will be sent to this address. The email address is not made public and will only be used if you wish to receive a new password or wish to receive certain news or notifications by email.',
	'EmailConfirmHint'			=> 'Please confirm your E-mail address by clicking on the link in the instructions sent to you. <br>If you do not verify your email address, you will not be able to retrieve a possible lost password. <br>Furthermore you will not be notified of recent page changes and comments.',
	'EmailConfirmRequired'		=> 'メールアドレスが確認できない場合は、ログインできません。',
	'NameTooShort'				=> 'The Username is too short, a minimum of %2 characters is required.',
	'NameTooLong'				=> 'The Username is too long, a maximum of %2 characters is allowed.',
	'NameAlphanumOnly'			=> 'Username must be between %1 and %2 chars long and use only alphanumeric characters. Upper case characters are OK.',
	'NameCamelCaseOnly'			=> 'Username must be between %1 and %2 chars long and WikiName formatted.',
	'NewUserAccount'			=> 'new user account',

	'NewAccountSubject'			=> 'アカウントの登録',
	'NewAccountAdminCreated'	=> 'The user %1 has created an account for you with username "%2". In order to complete your registration, visit the following URL (make sure it is entered as the single line) and set your own access password:',
	'NewAccountUsername'		=> 'ユーザー名：',
	'AccountLanguage'			=> '言語：',
	'NewAccountEmail'			=> 'メールアドレス：',
	'NewAccountIP'				=> 'リモートIPアドレス：',
	'NewAccountSignupInfo'		=> 'The following account has been created:',

	'UserWaitingApproval'		=> 'An email has been sent to the site administrator. The administrator will review the information that has been submitted and either approve or deny your request.',
	'UserRequiresApproval'		=> 'To approve or deny this user access to %1 go to the admin panel.',
	'UserApprovalInfo'			=> 'After you register, your request will be sent to the site administrator for approval. You will then receive an email with further instructions.',
	'UserApprovalHint'			=> 'The successful activation of your account will be announced in a specific e-mail. Until then, a login is not possible.',

	'UserApprovalPending'		=> 'Your account is still pending approval.',
	'UserApprovalDenied'		=> 'Your account has been denied access to this site.',

	'RegistrationApproved'		=> 'Registration Approved',
	'RegistrationDenied'		=> 'Registration Denied',
	'PendingApproval'			=> 'Pending Approval',

	'UserApprovedInfo'			=> 'You have been approved to access %1.',
	'UserDeniedInfo'			=> 'You have been denied access to %1.',

	'RegistrationThreshold'		=> 'フォームに入力する時間は、%1秒以下であってはなりません',
	'Language'					=> '言語',

	// login panel
	'LoginWelcome'				=> 'ログイン',
	'CreateAccount'				=> 'アカウントの作成',
	'RegistrationLink'			=> 'アカウント作成',
	'LoginName'					=> 'ユーザー名',
	'Password'					=> 'パスワード',
	'LoginButton'				=> 'ログイン',
	'LoginLink'					=> 'ログイン',
	'PersistentCookie'			=> 'ログイン状態を保持',
	'Session'					=> 'セッション',
	'SessionTip'				=> 'parameters of current session',
	'SessionDuration'			=> 'Session duration',
	'SessionDurationSession'	=> 'browser session',
	'SessionDurationDay'		=> '1日',
	'SessionDurationWeek'		=> '1週',
	'SessionDurationMonth'		=> '1ヶ月',
	'LoggedInAs'				=> 'You are logged in as',

	'ClearCookies'				=> 'Delete all cookies',
	'BindSessionIp'				=> 'Bind session to the IP-address',
	'BindSessionIpOn'			=> 'enabled (current IP %1)',
	'TrafficProtection'			=> 'Traffic Protection',
	'SessionEnds'				=> 'The current session ends',
	'LastVisit'					=> 'Last visit was recorded',

	'LoginIncorrect'			=> 'The username or password you have entered is invalid.',
	'WelcomeBack'				=> 'Welcome back, %1',
	'LoginAttemptsExceeded'		=> 'You exceeded the maximum allowed number of login attempts.<br>In addition to your username and password you now also have to solve the CAPTCHA below.',

	// session notice
	'IPAddressChanged'			=> 'IP address changed to %1 (was %2)',

	'SessionReplay'				=> 'Session terminated due to replay.',
	'SessionObsolete'			=> 'Session is outdated.',
	'SessionExpired'			=> 'Session has expired.',
	'SessionTimeout'			=> 'Session terminated due to timeout.',
	'SessionInactivity'			=> 'Session terminated due to inactivity.',
	'SessionUaChange'			=> 'Session terminated due to user agent change.',
	'SessionTLSChange'			=> 'Session terminated due to TLS change.',
	'SessionIPChange'			=> 'Session terminated due to IP change.',

	// other
	'Guest'						=> 'ゲスト',
	'Everybody'					=> 'Everybody',
	'Help'						=> 'ヘルプ',
	'TopicSearchText'			=> 'Search in titles only',
	'WordprocessorVersion'		=> 'Word processor version',

	// notifications
	'EmailHello'				=> 'Hello ',
	'EmailModerator'			=> 'モデレータ',
	'WatchedPageChanged'		=> 'Page changed ',
	'SomeoneChangedThisPage'	=> ' changed a page that you are watching: ',
	'NewPageCreatedSubj'		=> 'A new page',
	'NewPageCreatedBody'		=> 'User %1 has created a new page: ',
	'FileUploadedSubj'			=> 'A new file',
	'FileUploadedBody'			=> 'User %1 has uploaded a new file: ',
	'FileReplacedBody'			=> 'User %1 has replaced the file: ',

	'ActionDenied'				=> 'Action is denied here.',
	'TocTitle'					=> '目次 ',
	'OuterLink2'				=> 'Outgoing link',
	'FileLink'					=> '',
	'PDFLink'					=> 'PDF Document',
	'RDFLink'					=> 'RDF Document',
	'EmailLink'					=> 'Write an email (mail client launch)',
	'JabberLink'				=> 'Chat via XMPP (Jabber client launch)',
	'PermaLink'					=> 'パーマリンク',
	'PermaLinkTip'				=> 'このページのこの版への固定リンク',
	'PermaLink0Tip'				=> 'Permanent link to this page',

	'ShowTip'					=> 'Return in view mode',
	'ShowText'					=> 'ビュー',
	'WikieditAutocomplete'		=> 'Complete wikilinks by Ctrl+Space',
	'WikiEditInactiveJs'		=> 'In order to be able to use WikiEdit, please enable JavaScript in your browser.',
	'NumerateLinks'				=> 'Numerate links in print view',
	'Comment'					=> 'コメント',
	'Comments0'					=> 'コメントを追加',
	'Comments1'					=> 'コメントを読む (1 コメント)',
	'CommentsN'					=> 'コメントを読む (%1 コメント)',
	'Comments'					=> 'コメント',
	'CommentHint'				=> '<a href="%1">ログイン</a>または<a href="%2">アカウント作成</a>して、コメントを投稿してください。',
	'CommentEdited'				=> 'edited',
	'Links'						=> 'リンク',
	'Version'					=> 'バージョン',

	// details formatter
	'ShowHideDetails'			=> '詳細',

	'PrivacyPolicy'				=> 'プライバシーポリシー',
	'TermsOfUse'				=> '利用規約',
	'AcceptTermsOfUse'			=> 'I have read, understood and agree to the Terms of service of the site.',

	'ShowComments'				=> 'Display comments / form',
	'HideComments'				=> 'Hide comments / form',
	'AddComment'				=> 'Attach a comment to this page:',
	'AddCommentTitle'			=> 'コメントのタイトル：',
	'CommentTitleRe'			=> 'Re:',
	'AddCommentButton'			=> 'コメントを追加',
	'HereLink'					=> 'here',
	'PageHandlerMoreTip'		=> '続き',

	'ThemeCorrupt'				=> 'Theme is corrupt',
	'InvalidNamespace'			=> 'Invalid namespace given.',
	'DoesNotExists'				=> 'このページは存在しません。',
	'PromptCreate'				=> 'Maybe you want to <strong><a href="%1">create</a></strong> it?',
	'RevisionHint'				=> 'This is an old revision of <a href="%1">%2</a> from %3 edited by %4.',
	'ReadAccessDenied'			=> 'You aren\'t allowed to read this page.',
	'ReadAccessDeniedHintGuest'	=> 'To read this page, you should log in.',
	'PageDeletedInfo'			=> 'このページは削除されました。',
	'RevisionDeletedInfo'		=> 'This revision has been deleted.',
	'CommentDeletedInfo'		=> 'このコメントは削除されました。',

	'LastEditedBy'				=> 'Last edited by',
	'YouAreOwner'				=> 'あなたはこのページの所有者です。',
	'Owner'						=> '所有者：',
	'Nobody'					=> 'Nobody',
	'TakeOwnership'				=> 'Take Ownership',
	'FilesTip'					=> 'Manage attached files',
	'FilesText'					=> '添付ファイル',
	'DeleteTip'					=> 'Delete page, it\'s files and comments',
	'DeleteCommentTip'			=> 'コメントの削除',
	'DeleteText'				=> '削除',
	'AclText'					=> '権限',
	'AclTip'					=> 'Edit Permissions',

	'PropertiesText'			=> 'プロパティー',
	'PropertiesTip'				=> 'Edit Page Properties',
	'EditTip'					=> 'Edit this page.',
	'EditText'					=> '編集',
	'EditSection'				=> '節を編集 %1',
	'EditSectionHint'			=> 'Section %1 of %2',
	'SectionHeadline'			=> '節を',
	'EditCommentTip'			=> 'Edit comment',
	'EditComment'				=> 'Edit this comment',
	'ReplyComment'				=> 'Reply',
	'ReplyCommentTip'			=> 'Reply this comment',
	'RevisionTip'				=> 'View page revisions',
	'RevisionText'				=> 'リビジョン',
	'ReferrersTip'				=> 'View a list of URLs referring to this page',
	'ReferrersText'				=> 'リファラ',
	'ModerateTip'				=> 'Moderation of topics and forum posts',
	'ModerateText'				=> 'モデレート',
	'SearchText'				=> '検索： ',

	'AclUpdated'				=> 'Access control lists updated',
	'AclGaveOwnership'			=> ' and gave ownership to %1.',
	'AclNoNewOwner'				=> 'Page ownership is not transferred, because the user %1 was not found.',
	'NewPageOwnership'			=> 'ページ所有権移転',
	'YouAreNewOwner'			=> 'former owner %1 transferred ownership ' . "\n" . 'of following page to you',
	'PageOwnershipInfo'			=> '',
	'AclRead'					=> '閲覧：',
	'AclWrite'					=> '編集：',
	'AclComment'				=> 'コメント：',
	'AclCreate'					=> '作成：',
	'AclUpload'					=> 'アップロード：',
	'AclFor'					=> 'Access Control Lists for %1',
	'SetOwner'					=> 'Set Owner:',
	'OwnerDontChange'			=> 'Don\'t change',
	'AclAccessDenied'			=> 'あなたはこのページの所有者ではありません。',
	'AclSyntaxError'			=> 'Access control list syntax error',
	'AclHelp'					=> '<code>*</code> - everyone is allowed<br>' .
									'<code>$</code> - only registered users<br>' .
									'<code>!</code> - a preceding exclamation mark denies the respective right<br>' .
									'<code>[UserName]</code> - names of allowed users<br>' .
									'<code>[GroupName]</code> - names of allowed usergroup (alias)<br>' .
									'<code>(an empty list)</code> - only the page owner has access',

	'AccessMode'				=> '閲覧の制限',
	'AccessDenied'				=> 'denied',
	'AccessPublic'				=> 'public',
	'AccessRegistered'			=> '登録済み',
	'AccessPrivate'				=> 'private',
	'AccessCustom'				=> 'custom',

	// purge handler
	'PurgePage'					=> 'Purge page',
	'NotOwnerAndCantPurge'		=> 'You are not the owner of the page and you can not purge it.',
	'ReallyPurge'				=> 'ATTENTION: Purging the page is irreversible!',
	'SelectPurgeOptions'		=> 'Select the necessary purge options:',
	'PurgeComments'				=> 'Purge all comments of the page',
	'CommentsPurged'			=> 'All comments were deleted.',
	'PurgeFiles'				=> 'Remove all attached files',
	'FilesPurged'				=> 'All attached files were removed.',
	'PurgeRevisions'			=> 'Purge all revisions of the page',
	'RevisionsPurged'			=> 'Revisions were purged.',
	'PurgeButton'				=> 'Purge',

	// categories handler
	'Categories'				=> 'カテゴリー',
	'CategoriesAssign'			=> 'assign',
	'CategoriesEdit'			=> '編集',
	'Category'					=> 'カテゴリー',
	'CategoriesFor'				=> 'Categories for',
	'CategoriesTip'				=> 'Edit categories',
	'CategoriesText'			=> 'カテゴリー',
	'CategoriesUpdated'			=> 'Categories updated',
	'CategoriesAlreadyExists'	=> '%1 このカテゴリはすでに存在しています。',
	'CategoriesAdded'			=> 'Category %1 added successfully.',
	'CategoriesRenamed'			=> 'Category successfully renamed.',
	'CategoriesUngrouped'		=> 'Category debundled successfully.',
	'CategoriesGrouped'			=> 'The category entered in the new group.',
	'NoMultilevelGrouping'		=> 'Multilevel grouping categories is not possible.',
	'CategoriesDeleted'			=> 'The category was deleted from the database and all pages.',
	'CategoriesAdd'				=> 'Add a new category',
	'CategoryDescription'		=> '説明',
	'CategoriesAddGrouped'		=> 'Grouped with the category',
	'CategoriesAddGroupedNo'	=> 'No group.',
	'CategoriesRename'			=> 'Rename the category %1 to',
	'CategoriesRenameInfo'		=> '* Note: Change will affect all pages that are assigned to that category.',
	'CategoriesGroup'			=> 'Group categories %1 with',
	'CategoriesGroupInfo'		=> '* Select [no group], to debundled the category.',
	'CategoriesNoGroup'			=> '[no group]',
	'CategoriesDelete'			=> 'Are you sure you want to remove category %1?',
	'CategoriesDeleteInfo'		=> '* Note: Change will affect all pages that are assigned to that category. If the word has a sub-category, they will not be deleted, but only debundled.',
	'CategoriesStoreInfo'		=> 'ページにカテゴリを割り当てるには、チェックボックスを選択します。',
	'CategoriesStoreButton'		=> 'Save Categories',
	'CategoriesGroupButton'		=> 'グループ',
	'CategoriesEditInfo'		=> 'To edit the Category list select the radio button.',
	'NoCategoriesForThisLang'	=> 'Categories for this language are not specified.',
	'PagesCategory'				=> 'Pages category',
	'CategoryNotExists'			=> 'Category does not exist.',
	'CategoryEmpty'				=> 'Category empty.',
	'NoCategorySelected'		=> 'No category selected.',
	'NoCategoriesAssigned'		=> 'No assigned categories for this language.',
	'TagCloud'					=> 'Tag Cloud',
	'PagesTaggedWith'			=> '%1 pages tagged with %2',
	'CategoriesOfCluster'		=> 'of cluster',
	'TaggedWithTip'				=> 'show pages tagged %1',

	// source handler
	'SourceText'				=> '由来',
	'SourceTip'					=> 'ソースを表示',
	'SourceCopyToClipboard'		=> 'クリップボードにコピー',
	'SourceFor'					=> '%1のソースを表示',

	// Groups action
	'GroupsSearch'				=> 'Find Groups',
	'GroupsNoMatching'			=> 'Matching groups not found. Try a softer search criteria.',
	'GroupsOpenProfile'			=> 'プロフィールを表示',
	'GroupsName'				=> 'グループ',
	'GroupsMembers'				=> 'Members',
	'GroupsDescription'			=> '説明',
	'GroupsCreated'				=> '作成',
	'GroupsNotFound'			=> 'Group %2 not found. Click <a href="%1">here</a>, to go to the main list.',
	'GroupsProfile'				=> 'プロフィール',
	'GroupsList'				=> 'View the entire list of groups',
	'GroupSpace'				=> 'Group space',

	'MetaUpdated'				=> 'Meta data updated',

	'PreviewButton'				=> 'プレビュー',
	'Preview'					=> 'プレビュー',
	'Chars'						=> 'chars',
	'PageBody'					=> 'Page body',
	'EditNote'					=> '概要を編集',
	'EditNoteMissing'			=> 'Edit summary missing',
	'EditMinor'					=> '小変更',
	'MinorEditHide'				=> 'マイナー編集を非表示',
	'MinorEditShow'				=> 'Show minor edit',
	'PostAnonymously'			=> 'Post anonymously without giving your name',
	'NotifyMe'					=> 'Notify me about new comments and changes of the page',
	'OverwriteAlert'			=> 'OVERWRITE ALERT: This page was modified by someone else while you were editing it.<br>Please copy your changes and re-edit this page.',
	'TextDbOversize'			=> '注意：あなたのテキストは、長さの制限を%1文字超えています。適度な文字数になるよう短縮してください。ヒント：残りのテキストを別のページに配置することができます。',
	'EditingRevisionWarning'	=> 'You are editing an old revision of this page. If you publish it, any changes made since then will be removed. <br>You may wish to edit the current revision instead.',
	'WriteAccessDenied'			=> 'You don\'t have write access to this page.',
	'EmptyPage'					=> 'Page body was empty - not saved!',
	'EmptyComment'				=> 'Comment body was empty - not saved!',
	'CommentAccessDenied'		=> 'Sorry, you\'re not allowed to post comments to this page.',
	'CommentFlooded'			=> 'The interval between the publication of the posts shall not be less than %1 seconds.',
	'CommentAdded'				=> 'Comment added.',
	'YouAreNowTheOwner'			=> 'You are now the owner of this page.',
	'PageSaved'					=> 'Page version %1 saved.',
	'CommentSaved'				=> 'Comment saved.',

	'RevisionsFor'				=> '履歴 %1',
	'DefaultDiffMode'			=> 'Default diff mode',
	'DiffMode'		=> [
		'0'		=> 'Full diff',
		'1'		=> 'Simple diff',
		'2'		=> 'ソース',
		'3'		=> '横に並べる',
		'4'		=> 'インライン',
		'5'		=> 'Merged',
		'6'		=> 'Unified',
		'7'		=> 'Context',
	],

	'PreviousEdit'				=> '前のリビジョン',
	'NextEdit'					=> '次のリビジョン',

	'Diff'						=> '差分',
	'PreviousVersion'			=> '古い版',
	'LatestVersion'				=> '最新版',
	'NextVersion'				=> '新しい版',

	'ShowDifferencesButton'		=> '差分を表示',
	'CancelReturnButton'		=> 'キャンセルし、ページに戻ります',
	'Comparison'				=> 'Difference between revisions for %1',
	'RevisionAsOf'				=> 'Revision %1 as of',
	'SimpleDiffAdditions'		=> 'Additions:',
	'SimpleDiffDeletions'		=> 'Deletions:',
	'NoDifferences'				=> 'No differences.',
	'ReEditOldRevision'			=> 'Re-edit this old revision',

	'ExternalPages'				=> 'External pages linking to %1 (%2) (<a href="%3">see list of domains</a>):',
	'ExternalPagesGlobal'		=> 'Sites linking to this WackoWiki (%2) (<a href="%1">see list of domains</a>):',
	'Last24Hours'				=> 'last 24 hours',
	'LastDays'					=> 'last %1 days',
	'DomainsSitesPages'			=> 'Domains/sites pages linking to  %1 (%2)  (<a href="%3">see list of different URLs</a>):',
	'DomainsSitesPagesGlobal'	=> 'Domains/sites linking to this WackoWiki (<a href="%1">see list of different URLs</a>):',
	'ViewReferrersPage'			=> 'to page',
	'ViewReferrersPerPage'		=> 'per page',
	'ViewReferrersByTime'		=> 'by time',
	'ViewReferrersGlobal'		=> 'グローバル',
	'NoneReferrers'				=> 'なし',
	'NotOwnerCantDelete'		=> 'You aren\'t owner of this page and can\'t delete it',

	// remove
	'RemovePage'				=> 'Remove page',
	'RemoveRevision'			=> 'Remove revision',
	'RemoveComment'				=> 'コメントの削除',
	'RemoveCluster'				=> 'Remove all pages of the cluster',
	'RemoveDontKeep'			=> 'Do not save a copy of a removed page and comments',
	'RemoveDontKeepRevision'	=> 'Do not save a copy of the removed revision',
	'RemoveDontKeepComment'		=> 'Do not save a copy of the removed comment',
	'RemoveDontKeepFile'		=> 'Do not save a copy of the removed file',
	'ReferrersRemoved'			=> 'Referrers removed.',
	'LinksRemoved'				=> 'Links removed.',
	'CategoriesRemoved'			=> 'Pages categories deleted.',
	'AclsRemoved'				=> 'Page acls removed.',
	'BookmarksRemoved'			=> 'Bookmarks removed.',
	'WatchesRemoved'			=> 'Watches removed.',
	'CommentsRemoved'			=> 'Comments from page removed.',
	'FilesRemoved'				=> 'Files from page removed.',
	'PageRemoved'				=> 'Page removed.',
	'PageCachePurged'			=> 'Cache purged.',
	'ClusterRemoved'			=> 'All pages of the cluster removed.',
	'RevisionRemoved'			=> 'Revision %1 removed.',
	'RevisionsRemoved'			=> 'Revisions removed.',
	'ActionHaveNoUndo'			=> 'この処理は取り消しできません。',

	// restore
	'PageRestored'				=> 'Page restored.',
	'RevisionRestored'			=> 'Revision restored.',
	'LocalFilesRestored'		=> 'Local files restored.',

	'PrintVersion'				=> 'Print version',
	'PrintText'					=> '印刷',
	'LinkedPages'				=> 'Linked pages:',
	'NoLinkedPages'				=> 'There are no linked pages',
	'ReferringPages'			=> 'Referring pages:',
	'NoReferringPages'			=> 'There are no referring pages',
	'Footnotes'					=> 'Footnotes:',
	'Footnote'					=> 'Footnote',
	'MostPopularPages'			=> '最も閲覧されているページ',
	'MostCommentedPages'		=> 'Most commented pages',
	'NoAccessToSourcePage'		=> 'You aren\'t allowed to read action source page.',
	'SourcePageDoesntExist'		=> 'Action source page doesn\'t exist yet',
	'NotLoggedInThusEdited'		=> 'You are not logged in, hence we couldn\'t identify the pages you\'ve edited.',
	'DidntEditAnyPage'			=> 'You haven\'t edited any pages yet.',
	'NoPagesFound'				=> 'No pages found.',
	'MyChangesTitle1'			=> 'This is the list of pages you\'ve edited, ordered by the time of your last change',
	'MyChangesTitle2'			=> 'This is the list of pages you\'ve edited, along with the time of your last change',
	'OrderABC'					=> 'alphabetically',
	'OrderCreation'				=> '日付順',
	'OrderChange'				=> 'by change',
	'ListOwnedPages'			=> 'This is the list of pages you own (ordered alphabetically)',
	'ListOwnedPages2'			=> 'This is the list of pages you own (ordered by date)',
	'ListOwnedPages3'			=> 'This is the list of pages you own (ordered by change)',
	'NotLoggedInThusOwned'		=> 'You\'re not logged in, hence we couldn\'t retrieve your pages.',
	'NoOrphaned'				=> 'No orphaned pages. Good.',
	'NoRecentComments'			=> 'No recent comments.',
	'LatestCommentBy'			=> 'latest comment by',
	'NoRecentlyCommented'		=> 'No recently commented page.',
	'NoDeletedPages'			=> 'No deleted pages found.',
	'NoDeletedRevisions'		=> 'No deleted revisions found.',
	'NoDeletedFiles'			=> 'No deleted files found.',
	'CommentsDisabled'			=> 'Comments are not available.',

	'SearchResults'				=> 'Search results for ',
	'NotFound'					=> 'not found',
	'NoResultsFor'				=> 'No results for ',
	'SearchFor'					=> '検索：',
	'TopicSearchResults'		=> 'Topics search results for ',
	'NotFoundInTopics'			=> 'not found in topics',
	'FilterLangNotAvailable'	=> 'The selected language is not available!',

	'PostedBy'					=> 'posted by',
	'ThisIsCommentOn'			=> 'This is a comment on',
	'At'						=> 'at',
	'To'						=> '宛先',
	'By'						=> 'by',
	'From'						=> '送信元',
	'For'						=> '対象',
	'ReturnToCommented'			=> 'Return to commented page',
	'AbandonedComment'			=> 'The page to which this comment belongs no longer exists!',

	'PagesLinkingTo'			=> 'Pages linking to',
	'NoPageLinkingTo'			=> 'No page is linking to',
	'NoWantedPages'				=> 'No wanted pages. Good.',
	'RemoveWatch'				=> 'ウォッチをやめる',
	'SetWatch'					=> 'このページをウォッチする',
	'WatchText'					=> 'ウォッチ',
	'UnwatchText'				=> 'ウォッチ解除',
	'UserSettingsStored'		=> 'User settings saved.',
	'LoggedOut'					=> 'あなたはログアウトしました。',
	'LoggedOutAuto'				=> 'セキュリティのため、お客様のセッションは終了しました。再度ログインしてください。',

	// user settings
	'EmailConfirmResent'		=> 'Repeated email confirmation code sent to your address.',
	'EmailConfirmNotSent'		=> 'Unable to send the confirmation code: email is not specified!',
	'Hello'						=> 'Hello',
	'UserName'					=> 'ユーザー名',
	'EmailAddress'				=> 'メールアドレス',
	'RealName'					=> 'フルネーム',
	'MenuItemsShown'			=> 'Menu items shown',
	'RecordsPerPage'			=> 'Records per page',
	'DoShowComments'			=> 'Show comments by default',
	'DoubleclickEditing'		=> 'ダブルクリック編集',
	'UpdateSettingsButton'		=> 'アップデート設定',

	'AccountDisabled'			=> 'Your account may be disabled or blocked.',
	'WrongPassword'				=> '間違ったパスワード！',
	'ConfirmPassword'			=> 'パスワードの確認',
	'Email'						=> 'メールアドレス',
	'MustBeWikiName'			=> 'User name must be <a href="https://wackowiki.org/doc/Doc/English/WikiName" target="_blank">WikiName</a> formatted!',
	'SpecifyEmail'				=> 'メールアドレスを指定してください。',
	'NotAEmail'					=> '有効なメールアドレスではないようです。',
	'EmailTaken'				=> 'The entered email address is already in use.',
	'EmailDomainNotAllowed'		=> 'The entered email address %1 is not in allowed domains list.',
	'PasswordsDidntMatch'		=> 'Passwords didn\'t match.',
	'SpacesArentAllowed'		=> 'Spaces aren\'t allowed in passwords.',
	'ListMyPages'				=> 'List your pages',
	'ListMyChanges'				=> 'List your changes',
	'ListMyWatches'				=> 'List of watched pages',
	'ListMyChangesWatches'		=> 'Changes among watched pages',
	'SeeListOfPages'			=> 'See a list of pages you own (MyPages) and pages you\'ve edited (MyChanges).',
	'AddBookmark'				=> 'Add current page to bookmarks',
	'RemoveBookmark'			=> 'Remove from bookmarks',

	'YourLanguage'				=> '言語を選択する',
	'ShowSpaces'				=> 'Show spaces in WikiNames',
	'WrongPage4Redirect'		=> 'Cannot redirect because of wrong redirect parameter',
	'RedirectsToItself'			=> 'The page redirects to itself.',
	'ReallyDeletePage'			=> 'Do you really want to DELETE this page?<br>There is no undo for this action!<br><br>WARNING: Deleting this page will delete all page versions, comments, attachments, ACLs and referrers.',
	'CommentForWatchedPage'		=> 'New comment for page ',
	'SomeoneCommented'			=> ' commented this page that you are watching: ',
	'AlertReferringPages'		=> 'This page is referred to by these pages',

	'AccountDelete'				=> 'Delete account',
	'AccountDeleteConfirm'		=> 'Are you sure you want to delete the account?',
	'AccountDeleted'			=> 'Account successfully deleted',
	'AccountDeleteHeader'		=> 'Delete account %1',
	'AccountDeleteInfo'			=> 'Of the data you created (e.g. email, preferences, attachments, wiki entries) as much as possible will be deleted. Note however, that data like attachments and wiki entries can not be deleted without impeding the work of the other users. Such data is hence reassigned to an account called %1. As the data of every deleted account is reassigned to this account it will not be possible to distinguish the data you created from the data of another deleted account.',
	'AccountDeleteWarning'		=> 'Deleting the user account is an irreversible action.',
	'AccountDeleteHint'			=> 'Your account will be deleted from the system. Therefore, you will no longer be able to log in with your current credentials. If you choose to become a user of this application again, you can do so by using the means this application grants.',
	'AccountDeleteVerify'		=> 'Enter your login %1 to verify the deletion. Once submitted, you will be asked to confirm your password.',

	'MarkRead'					=> '全て既読にする',
	'CurrentTime'				=> 'It is currently',
	'Created'					=> '作成',
	'Modified'					=> '変更済み',

	'EditIcon'					=> '編集',
	'TreeClusterTitle'			=> 'Tree of cluster %1',
	'TreeSiteTitle'				=> 'Site tree',
	'TreeEmpty'					=> '%1 has not subpages',
	'TreeEmptyLevels'			=> '%1 has not subpages for given levels of depth. Increase the value for depth.',
	'TreeTooBig'				=> 'too many subpages',

	// clone handler
	'ClonePage'					=> 'Clone page',
	'CloneText'					=> 'Clone',
	'CloneName'					=> 'Enter new name for a clone of this page',
	'CloneButton'				=> 'Clone',
	'PageCloned'				=> 'Page %1 cloned.',
	'ClonedFrom'				=> 'Cloned from %1.',
	'MassClone'					=> 'Clone entire cluster',
	'MassCloning'				=> 'Cloning cluster.',
	'CloneCannotRead'			=> 'Unreadable page %1.',
	'CloneCannotCreate'			=> 'Uncreatable page %1.',

	'SortComment'				=> 'Sort comments by',
	'SortCommentAsc'			=> 'Most recent on bottom',
	'SortCommentDesc'			=> 'Most recent on top',

	'RenamePage'				=> 'ページの名前を変更',
	'RenameText'				=> '名前を変更',
	'RenameTip'					=> 'ページの名前を変更',
	'NewName'					=> 'Enter new name for this page',
	'AlreadyExists'				=> 'Page %1 already exists.',
	'AlreadyNamed'				=> 'This page already named %1.',
	'PageRenamed'				=> 'Page renamed.',
	'NewNameOfPage'				=> 'New name of this page: ',
	'NotOwnerCantRename'		=> 'You aren\'t owner of this page and hence can\'t rename it',
	'NeedRedirect'				=> 'Create redirect to the new page on the old page',
	'RedirectCreated'			=> 'In the page %1 created redirect to the new one',

	'UserSettings'				=> 'ユーザーの設定',
	'UserSettingsGeneral'		=> '全般',
	'UserSettingsNotifications'	=> '通知',

	'NotifyMinorEdit'			=> 'Notify also minor edit',
	'NotifyPageEdit'			=> '編集',
	'NotifyComment'				=> 'コメント',
	'NotifyOff'					=> 'オフ',
	'NotifyAlways'				=> '常に',
	'NotifyPending'				=> 'Pending',
	'NotifyDigest'				=> 'Digest',
	'NotifyPendingPageTip'		=> 'Only one notification is sent for the first page change of a page you are watching.',
	'NotifyPendingCommentTip'	=> 'Only one notification is sent for the first comment to a page you are watching.',
	'NotifyPendingTip'			=> 'Notification is automatically re-enabled when you visit the current version of the page.',

	'FurtherPending'			=> 'There will be no other notifications in case of further changes unless you visit this page.',

	'UserSettingsEmailMe'		=> 'Email me when ...',

	'UserSettingsExtended'		=> '拡張',
	'UserSettingsOther'			=> 'その他の設定',
	'UserSpace'					=> 'ユーザー スペース',
	'ChooseTheme'				=> 'Choose theme',

	'CreatePage'				=> 'Create this page',
	'CreateNewPage'				=> '新しいページを作成する',
	'CreateNewPageText'			=> '作成',
	'CreateNewPageTip'			=> '新しいページを作成する',

	'CreateRandomPage'			=> 'Create a random page:',
	'CreateSubPage'				=> 'Create a sub page in the cluster:',
	'CreatePageParentCluster'	=> 'Create a page in the parent cluster:',
	'CreatePageDenied'			=> 'You do not have the necessary access rights.',
	'CreatePageDeniedAddress'	=> 'You do not have the right to create the page at this address.',
	'PageAlreadyExists'			=> 'According to the address provided the page %1 already exists.',
	'PageAlreadyExistsEdit'		=> 'Do you want %1 it?',
	'PageAlreadyExistsEdit2'	=> '編集',
	'PageAlreadyExistsEditDenied'	=> 'You can\'t edit it.',

	'SimilarPagesExists'		=> 'Similar pages to %1 already exists:',
	'SimilarPagesHint'			=> 'There are existing similar pages to %1:',

	'PageReservedWord'			=> 'You can\'t use %1 as the part of the address as it\'s a reserved word.',
	'UserReservedWord'			=> 'User names cannot contain %1 as it\'s a reserved word.',

	'DontRedirect'				=> 'Do not allow automatic redirection by action Redirect.',
	'SendWatchEmail'			=> 'Send notifying email when someone (except you) change any page you are watching',
	'AllowIntercom'				=> 'システムのユーザーからの個人的なメッセージを許可する',
	'AllowMassemail'			=> '管理者は情報をメールで送ることができる',
	'HideLastSession'			=> 'Hide last session',
	'ValidateIP'				=> 'Tying session to IP',
	'AnonymousPub'				=> 'Preferably, published anonymously (to hide the name)',
	'PageMoved'					=> 'This page moved. You can find it at',
	'RedirectedFrom'			=> '%1から転送',
	'RedirectedTo'				=> '転送先',
	'CurrentPassword'			=> '現在のパスワード',
	'NewPassword'				=> '新しいパスワード',
	'YouWantChangePassword'		=> 'パスワードを変更する',
	'ChangePasswordButton'		=> 'パスワードを変更する',
	'PasswordChanged'			=> 'パスワードを変更しました!',
	'EmailWelcome'				=> 'You\'ve registered at ',
	'EmailRegistered'			=> 'You\'ve successfully registered at %1.' . "\n" . 'Your username: %2' . "\n\n",
	'EmailVerify'				=> 'If you want to receive notifications, you must verify your email address. Please click on or copy the following link to a web browser: ' . "\n" . '%1',
	'EmailRegisteredLogin'		=> 'Please return to the Wiki and login with your new username and password.',
	'EmailRegisteredIgnore'		=> 'If you did not request this registration, ignore this message and nothing will happen.',
	'EmailDoNotReply'			=> 'Do not reply to this message.',
	'EmailReverify'				=> 'Someone (maybe you) submitted your email as notification address at %1.' . "\n" . 'Your username: %2'."\n\n" . 'If you want receive notifications, you need to approve your email. Please follow the link to do this.' . "\n" . '%3' . "\n\n",
	'EmailConfirm'				=> 'Please verify your email',
	'EmailConfirmed'			=> 'Email successfully confirmed.',
	'EmailNotConfirmed'			=> 'Email cannot be confirmed. This may be due to an incorrect confirmation code or the email address may already be confirmed. You can check if the email address is already confirmed by logging in and viewing its status on your %1 page.',
	'EmailNotVerified'			=> 'Email not verified!',
	'EmailNotVerifiedDesc'		=> 'You will not receive notification of changes or comments of watched pages, ' .
									'messages from other users, as well you <strong>will not be able to recover a forgotten password</strong>, ' .
									'until your email-address was confirmed, by following the link in the email sent to you. ' .
									'If, within days after registration You never got a email, ask for it again by clicking ',

	'ForgotPasswordHint'		=> 'Enter your login and email address,' . "\n" . 'then email with instructions will be send to you.',
	'ForgotPassword'			=> 'パスワードをお忘れですか?',
	'UserNotFound'				=> 'User with this name or email address was not found.',
	'NotConfirmedEmail'			=> 'Your email address is not confirmed.<br>Mail can\'t be send to non-confirmed address.',
	'EmailForgotSubject'		=> 'Password renewal for ',
	'EmailForgotMessage'		=> 'Someone (maybe you) forgot your password for %1.' . "\n" . 'Your login: %2'."\n\n" . 'Click the link or copy it to the browser address line to change your password.' . "\n" . '%3' . "\n\n",
	'CodeWasSent'				=> 'Password recovery instruction was sent to you by email.',
	'WrongCode'					=> 'Wrong code',
	'ChangePasswordForUser'		=> '%1\'s password change',

	'Watchers'					=> 'List of watchers for %1',
	'WatchersFor'				=> 'Watchers for',
	'NoWatchers'				=> 'There are no watchers for %1',
	'NotOwnerToViewWatchers'	=> 'You are not the owner of this page and you can\'t see list of watchers for it.',

	// thumbnail
	'TbnError'					=> 'サムネイルの作成エラー: %1',
	'TbnImageAreaTooBig'		=> '%1よりも大きな寸法のファイル',
	'TbnImageMissing'			=> 'ファイルが見つかりません: %1',

	// admin_recovery action
	'GenerateRecoveryHash'		=> 'Generate the password hash for your <code>recovery_password</code>',

	// import action
	'ImportTo'					=> 'Import in cluster:',
	'ImportWhat'				=> 'XML-file for import:',
	'ImportButton'				=> 'インポート',
	'ImportSuccess'				=> 'Imported successfully.',
	'ImportFailed'				=> 'IMPORT failed.',
	'ImportHint'				=> 'Please provide a cluster you want to import to, no relative addressing.',
	'ImportAttention'			=> 'Attention: Overwrites the same pages in the cluster.',
	'ImportNote'				=> 'Imported page',

	// mywatches action
	'WatchedPages'				=> 'List of all pages you follow for changes ',
	'UnwatchedPages'			=> 'List of all pages you do not watch',
	'NoWatchedPages'			=> 'You have no watched pages.',
	'NoUnwatchedPages'			=> 'You watch for changes in all pages.',
	'ViewWatchedPages'			=> 'Show watched pages',
	'ViewUnwatchedPages'		=> 'Show unwatched page',
	'NotLoggedInWatches'		=> 'You are not logged in, hence we couldn\'t identify so your list of watches.',

	// mychangeswatches action
	'MyChangesWatches'			=> 'List of all pages you watched that were edited by others since your last editing',
	'ResetChangesWatches'		=> 'reset the list of changes',
	'NoChangesWatches'			=> 'Among your watched pages are no changes...',

	// whatsnew action
	'NewCommentAdded'			=> 'Added new comment',
	'NewFileAdded'				=> 'Added new file',
	'NewPageCreated'			=> 'Created a new page',
	'NewRevisionAdded'			=> 'Changed page',
	'Cluster'					=> 'cluster',
	'PageDeleted'				=> 'Page deleted',
	'CommentDeleted'			=> 'Comment deleted',
	'FileDeleted'				=> 'File deleted',

	// users action
	'UsersSearch'				=> 'Find Users',
	'UsersOpenProfile'			=> 'プロフィールを表示',
	'UsersNoMatching'			=> 'Matching users not found. Try a softer search criteria.',
	'UsersName'					=> '名前',
	'UsersPages'				=> 'ページ',
	'UsersChanges'				=> '変化',
	'UsersSubscription'			=> '購読',
	'UsersWatches'				=> 'Watches',
	'UsersComments'				=> 'コメント',
	'UsersUploads'				=> 'アップロード',
	'UploadQuota'				=> 'Used space',
	'UploadQuotaTip'			=> 'Upload Space Quota',
	'UsersLogins'				=> 'Logins',
	'UsersRevisions'			=> 'リビジョン',
	'UsersSignup'				=> '登録',
	'UsersLastSession'			=> '最後のセッション',
	'UsersNotFound'				=> 'User %2 not found. Click <a href="%1">here</a>, to go to the main list.',
	'UsersProfile'				=> 'プロフィール',
	'UsersContact'				=> 'コンタクト',
	'UsersList'					=> 'View the entire list of users',
	'UsersNA'					=> '[セットされていません]',
	'UsersNA2'					=> '[いいえ]',
	'UsersSignupDate'			=> '登録日',
	'UsersGroupMembership'		=> 'Group membership',
	'UsersPersonalInfo'			=> 'Personal info',
	'UsersOwnedPages'			=> 'Owned pages:',
	'UsersCommentsPosted'		=> 'Comments posted:',
	'UsersFilesUploaded'		=> 'Files uploaded:',
	'UsersRevisionsMade'		=> 'Revisions made:',
	'UsersDocsSortName'			=> '[Sort by name]',
	'UsersDocsSortCreation'		=> '[Sort by creation date]',
	'UsersChangesSortAsc'		=> '[昇順に並べ替え]',
	'UsersChangesSortDesc'		=> '[降順に並べ替え]',
	'UsersSessionNA'			=> '[not recorded]',
	'UsersSessionHidden'		=> '[非表示]',
	'IntercomSubject'			=> '件名：',
	'IntercomMessage'			=> '本文：',
	'IntercomCopy'				=> '送信する',
	'IntercomSubjectN'			=> '[start a new topic]',
	'IntercomDisabled'			=> 'Sorry, you do not want or can not receive personal messages.',
	'IntercomHint'				=> 'Please log in first and follow the link again, if you  want answer the personal message you have received.',
	'IntercomDesc'				=> '注：自分のアドレスを公開せずに、相手のメールアドレスに個人的なメッセージを送信すること。受信者は、あなたのプロフィールページの同じフォームを使って、あなたに返信することができます。 ',
	'PMOversized'				=> 'The length of the message exceeds the maximum allowed size by %1. Please shorten your message and submit again.',
	'PMFlooded'					=> 'The interval between sending personal messages should not be less than %1 seconds.',
	'PMSent'					=> 'Personal message was successfully sent to the user.',
	'PMBody'					=> 'This message has been sent to you by the user %1.',
	'PMBodyCopy'				=> 'あなたはユーザー%1に以下のメッセージを送信しました。',
	'PMReply'					=> 'To answer this email, click on the following link (do not use the Reply button / Reply in mailer):',
	'PMNotLoggedIn'				=> 'You are not registered in the system and can not send personal messages to users.',

	// admin_replace action
	'ReplaceText'				=> '文字列の置換',
	'TextOriginal'				=> '置換前の文字列:',
	'TextReplacement'			=> '置換後の文字列:',
	'ReplaceTextRegex'			=> '正規表現を使用',
	'Namespace'					=> '名前空間:',
	'ReplaceTextCluster'		=> 'このクラスタ内でのみ検索と置換を行います：',
	'ReplaceTextEditPages'		=> 'ページ本文中の文字列を置換',
	'ReplaceTextEditComments'	=> 'コメント内のテキストを置換する',
	'ReplaceTextEditTitles'		=> 'ページ名中の文字列を置換する',
	'ReplaceTextGiveTarget'		=> '置換される対象となる文字列を指定する必要があります。',
	'ReplaceTextNoNamespace'	=> '名前空間を少なくとも1つ選択する必要があります。',
	'ReplaceTextNoDifference'	=> 'There is no difference between replace text and target text.',
	'ReplaceTextNoOption'		=> '置換オプションから少なくとも1つ選択する必要があります。',
	'ReplaceTextPagesEdit'		=> '以下の%3ページの本文中の「%1」を「%2」に置換する:',
	'ReplaceTextTitlesEdit'		=> '次の %3 ページのタイトルの %1 を %2 に置き換える：',
	'ReplaceTextReplace'		=> '置換',
	'ReplaceTextSuccess'		=> '%3ページで「%1」が「%2」に置換されます。',
	'ReplaceTextNoMatch'		=> '文字列「%1」を含むページは見つかりませんでした。',
	'ReplaceTextNoTitleMatch'	=> '「%1」を名前に含むページは見つかりませんでした。',
	'ReplaceTextEditFailed'		=> 'テキストの置換に失敗しました',
	'ReplaceTextTitleTooBig'	=> '原文または置換後の文字がタイトルに対して大きすぎる。',
	'ReplaceTextReturn'			=> 'フォームに戻る',
	'ReplaceTextWarning'		=> '警告: 置換後の文字列「%2」を含むページが既に %1 件あります。この置換を実行すると、これらの文字列と実際に置換された箇所を区別できなくなります。',
	'ReplaceTextBlankWarning'	=> '警告: 置換後文字列が空であるため、この操作は取り消せません。',
	'ReplaceTextEditSummary'	=> '文字列「%1」を「%2」に置換',
	'InvertSelection'			=> '選択を反転',

	// Properties
	'PropertiesFor'				=> 'Page properties for %1',
	'MetaTag'					=> 'タグ',
	'MetaTitle'					=> 'タイトル',
	'MetaKeywords'				=> 'キーワード',
	'MetaDescription'			=> '説明',
	'On'						=> 'オン',
	'Off'						=> 'オフ',
	'Registered'				=> '登録済み',
	'MetaComments'				=> 'Show comments',
	'MetaFiles'					=> 'Show files panel',
	'MetaToc'					=> 'Show table of contents',
	'MetaIndex'					=> 'Show cluster section panel',
	'MetaIndexMode'				=> 'Show Level Mode',
	'MetaIndexFull'				=> 'Tree',
	'MetaIndexUpper'			=> 'Upper',
	'MetaIndexLower'			=> 'Lower',
	'MetaHtml'					=> 'HTML support for page',
	'MetaSafeHtml'				=> 'Filtering of unsafe HTML',
	'MetaTypografica'			=> 'Typographical Proofreader',
	'MetaNoIndex'				=> 'Block search engines',
	'SettingsID'				=> 'ページ ID',
	'SettingsSize'				=> 'サイズ',
	'SettingsSizeTip'			=> 'source / compiled',
	'SettingsCreated'			=> '作成',
	'SettingsCurrent'			=> '変更済み',
	'SettingsTotalRevs'			=> 'リビジョン',
	'SettingsTotalComs'			=> 'コメント',
	'SettingsWatchers'			=> 'Watchers',
	'SettingsHits'				=> '表示',
	'SettingsText'				=> '設定',
	'SettingsEdit'				=> '編集',
	'SettingsRevisions'			=> 'リビジョン',
	'SettingsClone'				=> 'Clone',
	'SettingsRename'			=> '名前を変更',
	'MassRename'				=> 'for entire cluster',
	'SettingsRemove'			=> '削除',
	'SettingsPurge'				=> 'Purge',
	'SettingsModerate'			=> 'モデレート',
	'SettingsPermissions'		=> '権限',
	'AclForEntireCluster'		=> 'for entire cluster',
	'SettingsAttachments'		=> '添付ファイル',
	'SettingsUpload'			=> 'アップロード',
	'SettingsCategories'		=> 'カテゴリー',
	'SettingsLanguages'			=> '言語',
	'SettingsReferrers'			=> 'リファラ',
	'SettingsWatch'				=> 'ウォッチ',
	'SettingsLatex'				=> 'LaTeX version',
	'SettingsXML'				=> 'Export to XML',
	'NeedToChangeLang'			=> 'Unsupported page language %1 needs to be changed.',
	'SetLang'					=> 'このページの言語',
	'SetMenuLabel'				=> 'Menu label',
	'SetShowMenuLabel'			=> 'Show in navigation',

	// upload
	'UploadFiles'				=> 'ファイルをアップロード',
	'UploadFor'					=> 'ファイルアップロード：',
	'UploadButton'				=> 'アップロード',
	'UploadGlobalText'			=> '公開アクセス用',
	'UploadGlobal'				=> 'グローバル',
	'UploadLocalText'			=> '現在のページの閲覧を許可されたユーザーのみ',
	'UploadAsName'				=> '名前：',
	'UploadOverwrite'			=> '既存のファイルを上書き',
	'FileDesc'					=> '説明：',
	'UploadForbidden'			=> 'You are not allowed to upload files here.',
	'UploadOverwriteDenied'		=> 'ファイルの所有者または管理者のみが %1 ファイルを上書きできます。',
	'UploadNoFile'				=> 'There was not file in form, for some reason.',
	'UploadMaxSizeReached'		=> 'File size is over allowed limit!',
	'UploadDirNotWritable'		=> 'File directory is not writable!',
	'UploadNotAPicture'			=> 'There is allowed to upload pictures only, and what do you trying to upload?',
	'UploadEmptyExtension'		=> 'ファイル名と拡張子は空白にできません。',
	'FilenameTooLong'			=> '240バイトを超えるファイル名は禁止されています。',
	'BannedFiletype'			=> '%1 は許可されていないファイル形式です。',
	'PermittedFiletype'			=> '許可されているファイル形式:',
	'UploadMimeMismatch'		=> 'ファイルの拡張子「%1」がMIMEタイプ「%2」と一致しません。',
	'UploadBadMime'				=> 'MIMEタイプ「%1」のファイルのアップロードは許可されていません。',
	'FileIsDuplicate'			=> 'アップロードされたものはの現在のバージョンのものと全く同じです。',
	'FileHasDuplicate'			=> 'このファイルは以下のファイル群と重複しています:',

	'UploadMaxFileQuota'		=> 'You have reached your upload limit, this file can not be uploaded',
	'UploadDone'				=> 'File upload successful',
	'UploadFileForbidden'		=> 'File access prohibited',
	'UploadTitle'				=> 'Files accessible from this page',
	'UploadTitleGlobal'			=> 'Files accessible from anywhere',

	'UploadFile'				=> 'アップロード',
	'UploadMax'					=> 'No more than ',
	'UploadUsedStorage'			=> 'Storage in use ',

	// attachments
	'Attachments'				=> '添付',
	'Attachment'				=> '添付',
	'AttachmentsToPage'			=> 'to page',
	'AttachmentsToCluster'		=> 'cluster',
	'AttachmentsByTime'			=> 'by time',
	'AttachmentsGlobal'			=> 'グローバル',
	'AttachmentsAll'			=> 'すべて',
	'AttachmentsLinked'			=> 'used',

	'FileViewProperties'		=> 'ビュー',
	'FileViewPropertiesTip'		=> 'View the metadata of this file',
	'FileEditProperties'		=> '編集',
	'FileEditPropertiesTip'		=> 'Edit the metadata of this file',
	'FileEditedMeta'			=> 'Updated metadata of this file',
	'FileEditDenied'			=> 'You are not allowed to edit this file',
	'FileLabel'					=> 'ラベル',
	'FileLabelTip'				=> 'Label this file',
	'FileRemove'				=> '削除',
	'FileRemovedFromDB'			=> 'File removed from database',
	'FileRemovedFromFS'			=> 'File erased from physical hosting',
	'FileRemovedFromFSError'	=> 'It seems to be impossible to erase file!',
	'FileRemoveConfirm'			=> 'Sure to remove this file?',
	'FileRemoveDenied'			=> 'You are not allowed to remove this file',
	'FileNotFound'				=> 'ファイルが見つかりません。',

	'FileSearch'				=> 'Find File:',
	'UploadBy'					=> 'Uploaded by:',
	'FileAdded'					=> 'Added:',
	'FileModified'				=> '変更済み：',
	'FileSize'					=> 'サイズ：',
	'FileDimension'				=> '寸法：',
	'MimeType'					=> 'MIMEタイプ：',
	'FileName'					=> '名前：',
	'FileCaption'				=> 'キャプション：',
	'FileAuthor'				=> '投稿者：',
	'FileSource'				=> 'ソース：',
	'FileSourceUrl'				=> 'URL:',
	'FileAttachedTo'			=> 'Attached to:',
	'FileSyntax'				=> '統語論：',
	'FileAbsolutePath'			=> '絶対パス',
	'FileRelativePath'			=> '相対パス',
	'FileUsage'					=> 'ファイルの使用状況:',
	'FileUsageText'				=> '以下の​ ページがこのファイルを使用しています：',
	'NoFileUsage'				=> 'No pages link to this file.',

	'FileSortExt'				=> 'extension',
	'FileSortName'				=> 'name',
	'FileSortSize'				=> 'size',
	'FileSortTime'				=> 'created',

	'SortBy'					=> 'Sort by',
	'Ascending'					=> 'ascending',
	'Decending'					=> 'decending',

	'Files0'					=> 'ファイルを添付',
	'Files1'					=> 'ファイルを表示 (1 ファイル)',
	'FilesN'					=> 'ファイルを表示 (%1 ファイル)',
	'Files'						=> 'ファイル',
	'File'						=> 'ファイル',
	'ShowFiles'					=> 'Display files / form',
	'HideFiles'					=> 'Hide files / form',
	'DoShowFiles'				=> 'Show files lists by default',
	'NoAttachments'				=> '表示する添付ファイルはありません。',

	'RegistrationLang'			=> 'あなたの言語',
	'InvalidWikiName'			=> 'Chosen name is invalid',
	'InvalidUserName'			=> 'Chosen user name is invalid',
	'Bookmarks'					=> 'ブックマーク',
	'ReallyDeleteComment'		=> 'Do you really want to DELETE this comment?<br>There is no undo for this action!',
	'ReallyDeleteRevision'		=> 'Do you really want to DELETE this revision?<br>There is no undo for this action!',

	'RegistrationClosed'		=> 'ユーザー登録は無効化されました。 Try to contact site administrator.',
	'AclAreYouSure'				=> 'You are going to change ACLs of this page and all of its subpages. Continue?',

	'BookmarkDeleteSelected'	=> 'Delete selected',
	'BookmarkMark'				=> 'マーク',
	'BookmarkNumber'			=> '番号。',
	'BookmarkNone'				=> 'You have no bookmarks.',
	'BookmarkTitle'				=> 'ブックマークのタイトル',
	'BookmarkPage'				=> 'ページ',
	'BookmarkSaveChanges'		=> 'Save changes',
	'BookmarksAddPage'			=> 'Set a bookmark for the following page',
	'BookmarkAlreadyExists'		=> 'The bookmark already exists.',

	'PoweredBy'					=> 'Powered by',

	'MassRenaming'				=> 'Rename entire cluster',
	'MassNewName'				=> 'Enter new name for this cluster',
	'MassNeedRedirect'			=> 'Create redirect to the new pages on the old pages',

	// pagination
	'ToOverview'				=> '概要に戻る',
	'ToThePage'					=> 'To page:',
	'Next'						=> '次へ',
	'Prev'						=> '前へ',
	'NextAcr'					=> '次へ',
	'PrevAcr'					=> '前へ',
	'Back'						=> '戻る',

	// filter
	'Filter'					=> '絞り込み',
	'OptionalFilters'			=> 'オプションのフィルターです：',
	'Any'						=> 'すべて',

	// My Groups
	'UserGroups'				=> 'Groups of users',
	'MyGroups'					=> 'Group Associations',
	'Group'						=> 'グループ',
	'Groups'					=> 'グループ',

	// license action
	'DistributedUnder'			=> 'Material is distributed under',
	'AuthorsDisplayHint'		=> 'The list of authors will be displayed when saving the page.',
	'AnonymousUsers'			=> '匿名ユーザー',
	'License'					=> 'License',
	'LicenseArray'				=> [
		'1'		=> 'Attribution-NoDerivatives',
		'2'		=> 'Attribution-NonCommercial-ShareAlike',
		'3'		=> 'Attribution-NonCommercial-NoDerivatives',
		'4'		=> 'Attribution-ShareAlike',
		'5'		=> 'Attribution-NonCommercial',
		'6'		=> 'Attribution',
		'7'		=> 'CC0 1.0 Universal',
		'8'		=> 'GNU Free Documentation License',
		'9'		=> 'Public Domain / Free Use',
		'10'	=> 'All Rights Reserved',
	],
	'LicenseMeta'				=> [
		'1'		=> 'Public domain',
		'2'		=> 'Some rights reserved',
		'3'		=> 'All Rights Reserved',
	],

	// Cache
	'ClearCache'				=> 'キャッシュをクリア',
	'CacheCleared'				=> 'Cache cleared.',
	'ConfigCache'				=> 'Config cache',
	'FeedCache'					=> 'Feed cache',
	'PageCache'					=> 'Page cache',
	'SQLCache'					=> 'SQL cache',
	'TemplateCache'				=> 'Template cache',
	'ThumbCache'				=> 'Thumbnail cache',

	// Embed
	'EmbedNoURL'				=> 'Please specify a address of the resource with the Parameter url. (e.g. {{embed url="https://example.com/embed/video.mp4"}} )',

	// Feed
	'FeedTitle'					=> 'Feed Title',
	'FeedMulti'					=> 'Multi-Feed',
	'FeedNoURL'					=> 'Please specify a Feed with the Parameter url. (e.g. {{feed url="https://example.com/feed.xml"}} )',
	'FeedError'					=> 'Could not load or parse feed',
	'FeedSource'				=> 'ソース：',
	'FeedXMLTip'				=> '',

	// XML / RSS autodiscovery
	'ChangesXMLTitle'			=> ' - 最近の変化',
	'ChangesXML'				=> 'Recent changes to the ',
	'CommentsXMLTitle'			=> ' - 最近のコメント',
	'CommentsXML'				=> 'Recent comments to the ',
	'NewsXMLTitle'				=> ' - 最近のニュース',
	'NewsXML'					=> 'Recent news to the ',
	'RevisionXMLTip'			=> 'Click to view recent page revisions in XML format.',
	'CommentsXMLTip'			=> 'Click to view recent comments in XML format.',
	'ChangesXMLTip'				=> 'Click to view recent changes in XML format.',
	'NewsXMLTip'				=> 'Click to view recent news in XML format.',
	'RevisionsXML'				=> 'Revisions of ',
	'ExportClusterXML'			=> 'Export of entire cluster of ',
	'AccessDeniedXML'			=> 'この情報へのアクセスは許可されていません。',

	'ChangesFeed'				=> '変化',
	'CommentsFeed'				=> 'コメント',
	'NewsFeed'					=> 'ニュース',
	'RevisionsFeed'				=> 'Revisions of ',

	'LastModification'			=> 'Last Modification',

	// Captcha
	'Captcha'					=> '上の画像に表示されている文字列を入力',
	'CaptchaFailed'				=> 'You have entered the captcha word incorrectly. Please try again.',
	'CaptchaReload'				=> '新しいCaptcha',
	'CaptchaReloadWarning'		=> '申し訳ありませんが、Captcha画像をリロードできません。ページを再読み込みする必要があります。',

	// news
	'News'						=> 'ニュース',
	'NewsName'					=> 'タイトル：',
	'NewsNoName'				=> 'You forgot to add news headline.',
	'NewsNotAvailable'			=> 'No News available.',
	'NewsNoClusterDefined'		=> 'No News cluster defined.',
	'NewsDiscuss'				=> 'Discuss this article...',

	// blog
	'BlogNewTopic'				=> 'Create a new post',
	'NoPostAvailable'			=> 'No post available yet.',

	// Review
	'Reviewer'					=> 'Reviewer',
	'Reviewed'					=> 'reviewed',
	'Review'					=> 'review',
	'ReviewedBy'				=> 'reviewed by',
	'RemoveReview'				=> 'Remove review for this page',
	'SetReview'					=> 'Reviewed this page',
	'SetAsReviewed'				=> 'Set page as reviewed',
	'SetAsUnreviewed'			=> 'Set page as unreviewed',

	// word filter
	'PotentialSpam'				=> 'Identified Potential Spam',

	// moderation handler
	'Moderation'				=> 'モデレート',
	'Topics'					=> 'トピック',
	'ModerateSection'			=> 'section / page ',

	'NotModerator'				=> 'You do not have authority to moderate this page / chapter',
	'ModerateDeleteTopic'		=> 'Delete topic / page',
	'ModerateDeletePosts'		=> 'Delete comments',
	'ModerateMove'				=> '移動',
	'ModerateSplit'				=> 'Split / Move comments',
	'ModerateMerge'				=> '統合',
	'ModerateLock'				=> 'Lock',
	'ModerateUnlock'			=> 'Unlock',
	'ModerateAccept'			=> 'Accept',
	'ModerateDeleteConfirm'		=> 'Are you sure you want to <strong>remove</strong> the following topics?',
	'ModerateRenameConfirm'		=> 'Enter a new title for the selected page',
	'ModerateRenameExists'		=> '同じ名前のページがすでに存在します 別の名前を選んでください。',
	'ModerateRename1Only'		=> 'Note: only the first page you selected will be renamed!',
	'ModerateMovesConfirm'		=> 'Select the target partition to move the forum to',
	'ModerateMoveConfirm'		=> 'Select the forum or specify the cluster to move these topics. To move a page to the root of the site, type &quot;/&quot;',
	'ModeratePgMoveConfirm'		=> 'Specify the name of the cluster, in which to place the page. To move a page to the root of the site, type &quot;/&quot;',
	'ModerateMoveExists'		=> 'Operation aborted: in this section already exists topics with the same name %1. If you still need to transfer the above-mentioned topics, please rename them first.',
	'ModerateMoveNotExists'		=> 'The page / cluster does not exist. Please check the name and try again.',
	'ModerateMergeConfirm'		=> 'Choose a topic, which should combine the remaining',
	'ModerateMerge2Min'			=> 'To join you must select at least two topics!',
	'ModerateComDelConfirm'		=> 'Are you sure you want to <strong>remove</strong> %1 %2?',
	'ModerateComment'			=> 'コメント',
	'ModerateComments'			=> 'コメント',
	'ModerateSplitNewName'		=> 'Specify a name for separable topic and select a separation schema',
	'ModerateSplitPageName'		=> 'Enter the name of the page / topic, where to move detachable comments, and select a separation schema',
	'ModerateSplitAllAfter'		=> 'Detach all the comments after the first selected (and including)',
	'ModerateSplitSelected'		=> 'Separated only selected comments (total %1)',
	'ModerateUserProfile'		=> 'プロフィール',
	'ModerateNoItemChosen'		=> 'Please select at least one item via the Set button.',

	'ModerateSection2'			=> 'moderate section',
	'ModerateTopicsDeleted'		=> 'Selected topics successfully deleted.',
	'ModerateTopicsRelocated'	=> 'Selected topics successfully relocated.',
	'ModerateTopicsRenamed'		=> 'Topic successfully renamed.',
	'ModerateTopicsMerged'		=> 'Selected topics successfully merged.',
	'ModerateTopicsBlocked'		=> 'Selected topics successfully blocked',
	'ModerateTopicsUnlocked'	=> 'Selected topics successfully unlocked.',
	'ModerateTopicDeleted'		=> 'Topic has been successfully removed.',
	'ModeratePageMoved'			=> 'Page successfully moved.',
	'ModerateTopicRenamed'		=> 'Topic successfully renamed.',
	'ModerateTopicBlocked'		=> 'Topic successfully blocked',
	'ModerateTopicUnlocked'		=> 'Topic successfully unlocked.',
	'ModerateCommentsDeleted'	=> 'Selected comments removed successfully.',
	'ModerateCommentsSplit'		=> 'Selected comments successfully separated in a new topic.',
	'ModerateCommentsSplitFailed'	=> 'Note: For some reason to separate the selected comments to a new topic failed.<br>Usually this should not happen, so let the incident site administrator.<br>As a precaution, issue has been preserved in its original form.',
	'ModerateCommentsMoved'		=> 'Selected comments successfully migrated to the given page.',

	// forum
	'ForumSubforums'			=> 'フォーラム',
	'ForumTopic'				=> 'トピック',
	'ForumTopics'				=> 'トピック',
	'ForumPosts'				=> '投稿',
	'ForumReplies'				=> '返信',
	'ForumAuthor'				=> '投稿者',
	'ForumViews'				=> 'ビューズ',
	'ForumCreated'				=> '作成',
	'ForumComments'				=> 'コメント',
	'ForumLastComment'			=> '最新のコメント',
	'ForumNoComments'			=> 'コメントはありません。',
	'ForumNoTopics'				=> 'フォーラムに投稿されたトピックはありません',
	'ForumNewTopic'				=> 'Start a new discussion',
	'ForumTopicName'			=> 'トピック名：',
	'ForumTopicSubmit'			=> 'トピックを送信',
	'ForumNoTopicName'			=> 'Specify a name for the new page.',
	'ForumNewPosts'				=> '新しい記事',
	'ForumLocked'				=> 'section locked',
	'ForumUpdated'				=> '更新',
	'ForumNoClusterDefined'		=> 'No Forum cluster defined.',
	'ForumOutsideCluster'		=> 'Ensure that the %1 action is located inside the forum cluster.',

	// password complexity
	'PwdCplxShort'				=> 'パスワードが短すぎます。',
	'PwdCplxEquals'				=> 'Password contains the user name.',
	'PwdCplxWeak'				=> 'Password does not meet complexity requirements.',
	'PwdCplxDesc1'				=> 'パスワードの要件： ',
	'PwdCplxDesc2'				=> 'password should not be less than %1 characters',
	'PwdCplxDesc3'				=> 'must not contain your username',
	'PwdCplxDesc4'				=> 'should consist of ',
	'PwdCplxDesc41'				=> 'letters and numbers',
	'PwdCplxDesc42'				=> 'uppercase and lowercase letters and numbers',
	'PwdCplxDesc43'				=> 'uppercase and lowercase letters, digits and non-alphabetic characters',
	'PwdCplxDesc5'				=> 'You can use any letters, numbers and special characters, but gaps.',

	'PasswordTooShort'			=> 'パスワードが短すぎます。',
	'PasswordTooCommon'			=> 'That password is too common.',
	'PasswordSameAsUsername'	=> 'Your password is the same as your username.',
	'PasswordSameAsEmail'		=> 'Your password is the same as your email.',

	'Timezone'					=> 'タイムゾーン',

	'LanguageArray'	=> [
		'bg' => 'ブルガリア語',
		'da' => 'デンマーク語',
		'de' => 'ドイツ語',
		'el' => 'ギリシャ語',
		'en' => '英語',
		'es' => 'スペイン語',
		'et' => 'エストニア語',
		'fa' => 'Persian',
		'fr' => 'フランス語',
		'hi' => 'ヒンディー語',
		'hu' => 'ハンガリー語',
		'it' => 'イタリア語',
		'ja' => '日本語',
		'ko' => '韓国語',
		'nl' => 'オランダ語',
		'pl' => 'ポーランド語',
		'pt' => 'ポルトガル語',
		'ru' => 'ロシア語',
		'zh' => '中国語',
		'zh-tw' => '中国語',
	],

	'AccountStatus'				=> 'Account status',
	'AccountStatusArray' => [
		'0' => 'active',
		'1' => 'pending',
		'2' => 'blocked',
		'3' => 'inactive',
	],

	'JustNow'		=> 'just now',
	'MinuteAgo'		=> '1分前',
	'MinutesAgo'	=> '%1 分前',
	'HourAgo'		=> '1 時間前',
	'HoursAgo'		=> '%1 hours ago',
	'DayAgo'		=> 'yesterday',
	'DaysAgo'		=> '%1 days ago',
	'WeekAgo'		=> '1週間前',
	'WeeksAgo'		=> '%1 週間前',
	'MonthAgo'		=> 'a month ago',
	'MonthsAgo'		=> '%1 ヶ月前',
	'YearAgo'		=> 'a year ago',
	'YearsAgo'		=> '%1 年前',

	'InAMoment'		=> 'in a moment',
	'InAMinute'		=> 'in a minute',
	'InMinutes'		=> 'in %1 minutes',
	'InAnHour'		=> 'in an hour',
	'InHours'		=> 'in %1 hours',
	'Tomorrow'		=> 'tomorrow',
	'InDays'		=> 'in %1 days',
	'InAWeek'		=> 'in a week',
	'InWeeks'		=> 'in %1 weeks',
	'InAMonth'		=> 'in a month',
	'InMonths'		=> 'in %1 months',
	'InAYear'		=> 'in a year',
	'InYears'		=> 'in %1 years',

	// norm multiples
	'ByteDecimalShort'			=> ['B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
	'ByteDecimalLong'			=> ['Byte', 'Kilobyte', 'Megabyte', 'Gigabyte', 'Terabyte', 'Petabyte', 'Exabyte', 'Zettabyte', 'Yottabyte'],
	'ByteBinaryShort'			=> ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'],
	'ByteBinaryLong'			=> ['Byte', 'Kibibyte', 'Mebibyte', 'Gibibyte', 'Tebibyte', 'Pebibyte', 'Exbibyte', 'Zebibyte', 'Yobibyte'],
	'PixelDecimalShort'			=> ['px', 'KP', 'MP', 'GP', 'TP', 'PP', 'EP', 'ZP', 'YP'],
	'PixelDecimalLong'			=> ['pixel', 'Kpx', 'Mpx', 'Gpx', 'Tpx', 'Ppx', 'Epx', 'Zpx', 'Ypx'],

	// loading error
	'UnknownAction'				=> 'Unknown action',
	'UnknownMethod'				=> 'Unknown method',
	'FormatterNotFound'			=> 'Formatter %1 not found',

	// log
	'LogAdminLoginSuccess'		=> 'Successful login into the administrative panel',
	'LogAdminLogout'			=> 'Logout of the administrative panel',
	'LogAdminLoginFailed'		=> '!!Failure to authorize into the administrative panel!!',
	'LogAdminLoginLocked'		=> 'Locked login into the administrative panel',
	'LogUserCookieForged'		=> '!!**An attempt to login on a forged cookie with login ##%1##**!!',
	'LogInvalidFormToken'		=> 'Potential CSRF attack in progress detected: %1',
	'LogRemovedPage'			=> '!!Removed page ##%1## (user %2)!!',
	'LogRemovedCluster'			=> '!!Removed **cluster** ##%1## (user %2)!!',
	'LogRemovedRevision'		=> '!!Removed revision ##%3## of page [[/%1]] (user %2)!!',
	'LogRemovedComment'			=> '!!Removed comment from %3 on page [[/%1]] (user %2)!!',
	'LogRemovedFile'			=> '!!Removed file ##%2## from page [[/%1]]!!',
	'LogRemovedAllComments'		=> '!!Removed all comments of the page [[/%1]]!!',
	'LogRemovedAllRevisions'	=> '!!Removed all revisions of the page [[/%1]]!!',
	'LogRemovedAllFiles'		=> '!!Removed all files, attached to [[/%1]]!!',
	'LogTopicLocked'			=> 'Forum topic is locked [[/%1]]',
	'LogTopicUnlocked'			=> 'Unlocked forum topic [[/%1]]',
	'LogAclUpdated'				=> 'Updated ACL page [[/%1]]',
	'LogOwnershipChanged'		=> 'Ownership of the page [[/%1]] transferred to the user ##%2##',
	'LogUserLoginFailed'		=> '!!Unsuccessful attempts to log in with ##~%1##!!',
	'LogClonedPage'				=> 'Page ##%1## cloned to [[/%2]]',
	'LogRenamedPage'			=> 'Page ##%1## renamed to [[/%2]]',
	'LogRenamedPage2'			=> '. The old page set as the link to the new one',
	'LogSplittedPage'			=> 'Comments on the page [[/%1]] splitted to page [[/%2]]',
	'LogMergedPages'			=> 'Pages %1 merged to page [[/%2]]',
	'LogUserPasswordReminded'	=> 'User ##%1## asked for the password recovery process to address ##%2##',
	'LogUserPasswordRecovered'	=> 'User ##%1## successfully recover his forgotten password',
	'LogUserPasswordChanged'	=> 'User ##%1## successfully updated (changed) his password',
	'LogUserPasswordMismatch'	=> '!!User ##%1## failed to change his password: current password mismatch!!',
	'LogUserIPSwitched'			=> 'Unauthorized IP address change of the user %1 from %2 to %3',
	'LogPageImported'			=> 'Imported page [[/%1]]',
	'LogSaveNoRights'			=> 'No appropriate rights to save the page [[/%1]]',
	'LogPageCreated'			=> 'Created new page [[/%1]]',
	'LogPagePropertiesUpdated'	=> 'Updated page properties [[/%1]]',
	'LogPageOwnershipClaimed'	=> 'The user got ownership of the page [[/%1]]',
	'LogFileUploadedLocal'		=> 'New file ##%2## uploaded to the page [[/%1]] (size %3)',
	'LogFileUploadedGlobal'		=> 'New file ##%2## uploaded to the global folder (size %3)',
	'LogPMSent'					=> 'Personal message ##%1## -> ##%2## successfully sent',
	'LogUserSimilarName'		=> 'There were attempts to register under the same user name: ##%1##',
	'LogUserEmailNotAllowed'	=> 'Email ##%1## not in allowed domains list',
	'LogRegisterTiming'			=> '登録に失敗しました。フォームの時間閾値は ##%1## 秒です (以前は ##%2##)',
	'LogUserRegistered'			=> 'Successfully registered a new user ##%1## (##%2##)',
	'LogUserEmailActivated'		=> 'Successfully activated email ##%1## of user ##%2##',
	'LogCommentPosted'			=> 'Added [[/%1 new comment(s)]] to page [[/%2]]',
	'LogUserLoginOK'			=> 'User ##%1## successfully logged in the system',
	'LogUserLoggedOut'			=> 'User ##%1## successfully logged out the system',
	'LogUserSessionContinued'	=> 'User ##%1## continued the suspended session',
	'LogUserSettingsUpdate'		=> 'User ##%1## updated personal settings',
	'LogPageEdited'				=> 'Edited page [[/%1]]',
	'LogCommentEdited'			=> 'Edited comment [[/%1]]',
	'LogUpdatedFileMeta'		=> 'Updated file metadata for ##%2## from page [[/%1]]',
	'LogUpdatedFileCategories'	=> 'Updated file categories for ##%2## from page [[/%1]]',

	'LogXmlSitemapGenerated'	=> 'XML Sitemap generated',
	'LogReferrersPurged'		=> 'Maintenance: referrers purged',
	'LogRevisionsPurged'		=> 'Maintenance: outdated pages revisions purged',
	'LogDeletedPagesPurged'		=> 'Maintenance: deleted pages purged',
	'LogSystemLogPurged'		=> 'Maintenance: system log purged',
	'LogCachedPagesPurged'		=> 'Maintenance: cached pages purged',
	'LogSqlCachePurged'			=> 'Maintenance: cached sql results purged',
	'LogExpiredTokensPurged'	=> 'Maintenance: expired cookie_tokens purged',
	'LogErrorSplitComments'		=> 'Error when separating comments from the topic [[/%1]] a new topic ##%2##: page was not created',
	'LogCategoriesUpdated'		=> 'Updated page categories [[/%1]]',
	'LogCategoryCreated'		=> 'Created a new category //%1//',
	'LogCategoryRenamed'		=> 'Category ##%1## renamed to ##%2##',
	'LogCategoryDebundled'		=> 'Category ##%1## debundled',
	'LogCategoryGrouped'		=> 'Category ##%1## grouped with the word ##%2##',
	'LogCategoryRemoved'		=> 'Category ##%1## removed from the database',

	'ErrorMinPHPVersion'		=> 'PHPのバージョンは<strong>' . PHP_MIN_VERSION . '</strong>より大きい必要があります,' .
									' あなたのサーバーでは、<strong>' . PHP_VERSION . '</strong>が使用されているようです。' .
									'  WackoWiki を正しく動作させるには、PHP を最新のバージョンにアップグレードする必要があります。',

];
